/*
 * Decompiled with CFR 0.152.
 */
package com.clefal.nirvana_lib.client.render.batch;

import com.clefal.nirvana_lib.client.render.batch.BufferInfoRenderState;
import com.clefal.nirvana_lib.client.render.batch.ITextureBufferInfo;
import com.mojang.blaze3d.textures.GpuSampler;
import com.mojang.blaze3d.textures.GpuTextureView;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.render.TextureSetup;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.resources.Identifier;
import org.joml.Matrix3x2f;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;

public record TextureBufferInfo(float pX1, float pX2, float pY1, float pY2, float pBlitOffset, float pMinU, float pMaxU, float pMinV, float pMaxV, Matrix4f matrix4f, RenderInfo renderInfo) implements ITextureBufferInfo
{
    public static TextureBufferInfo of(float pX, float pY, float pBlitOffset, int pUOffset, int pVOffset, int pUWidth, int pVHeight, Matrix4f matrix4f) {
        return TextureBufferInfo.of(pX, pY, pBlitOffset, (float)pUOffset, (float)pVOffset, pUWidth, pVHeight, 256, 256, matrix4f);
    }

    public static TextureBufferInfo of(float pX, float pY, int pUOffset, int pVOffset, int pUWidth, int pVHeight, Matrix4f matrix4f) {
        return TextureBufferInfo.of(pX, pY, 0.0f, (float)pUOffset, (float)pVOffset, pUWidth, pVHeight, 256, 256, matrix4f);
    }

    public static TextureBufferInfo of(float pX, float pY, float pBlitOffset, float pUOffset, float pVOffset, int pUWidth, int pVHeight, int pTextureWidth, int pTextureHeight, Matrix4f matrix4f) {
        return TextureBufferInfo.of(pX, pX + (float)pUWidth, pY, pY + (float)pVHeight, pBlitOffset, pUWidth, pVHeight, pUOffset, pVOffset, pTextureWidth, pTextureHeight, matrix4f);
    }

    public static TextureBufferInfo of(float pX, float pY, int pWidth, int pHeight, float pUOffset, float pVOffset, int pUWidth, int pVHeight, int pTextureWidth, int pTextureHeight, Matrix4f matrix4f) {
        return TextureBufferInfo.of(pX, pX + (float)pWidth, pY, pY + (float)pHeight, 0.0f, pUWidth, pVHeight, pUOffset, pVOffset, pTextureWidth, pTextureHeight, matrix4f);
    }

    public static TextureBufferInfo of(float pX, float pY, int pWidth, int pHeight, float pBlitOffset, float pUOffset, float pVOffset, int pUWidth, int pVHeight, int pTextureWidth, int pTextureHeight, Matrix4f matrix4f) {
        return TextureBufferInfo.of(pX, pX + (float)pWidth, pY, pY + (float)pHeight, pBlitOffset, pUWidth, pVHeight, pUOffset, pVOffset, pTextureWidth, pTextureHeight, matrix4f);
    }

    public static TextureBufferInfo of(float pX, float pY, float pUOffset, float pVOffset, int pWidth, int pHeight, int pTextureWidth, int pTextureHeight, Matrix4f matrix4f) {
        return TextureBufferInfo.of(pX, pY, pWidth, pHeight, pUOffset, pVOffset, pWidth, pHeight, pTextureWidth, pTextureHeight, matrix4f);
    }

    public static TextureBufferInfo of(float pX, float pY, float pUOffset, float pVOffset, int pWidth, int pHeight, float pBlitOffset, int pTextureWidth, int pTextureHeight, Matrix4f matrix4f) {
        return TextureBufferInfo.of(pX, pY, pWidth, pHeight, pUOffset, pVOffset, pWidth, pHeight, pTextureWidth, pTextureHeight, matrix4f);
    }

    public static TextureBufferInfo of(float pX1, float pX2, float pY1, float pY2, float pBlitOffset, int pUWidth, int pVHeight, float pUOffset, float pVOffset, int pTextureWidth, int pTextureHeight, Matrix4f matrix4f) {
        return new TextureBufferInfo(pX1, pX2, pY1, pY2, pBlitOffset, (pUOffset + 0.0f) / (float)pTextureWidth, (pUOffset + (float)pUWidth) / (float)pTextureWidth, (pVOffset + 0.0f) / (float)pTextureHeight, (pVOffset + (float)pVHeight) / (float)pTextureHeight, matrix4f, new RenderInfo(1.0f));
    }

    public TextureBufferInfo withRenderInfo(RenderInfo renderInfo) {
        return new TextureBufferInfo(this.pX1, this.pX2, this.pY1, this.pY2, this.pBlitOffset, this.pMinU, this.pMaxU, this.pMinV, this.pMaxV, this.matrix4f, renderInfo);
    }

    @Override
    public void upload(VertexConsumer consumer) {
        int light = 0xF000F0;
        float opacity = Math.min(this.renderInfo().opacity, 1.0f);
        consumer.addVertex((Matrix4fc)this.matrix4f, this.pX1, this.pY1, this.pBlitOffset).setUv(this.pMinU, this.pMinV).setColor(1.0f, 1.0f, 1.0f, opacity);
        consumer.addVertex((Matrix4fc)this.matrix4f, this.pX1, this.pY2, this.pBlitOffset).setUv(this.pMinU, this.pMaxV).setColor(1.0f, 1.0f, 1.0f, opacity);
        consumer.addVertex((Matrix4fc)this.matrix4f, this.pX2, this.pY2, this.pBlitOffset).setUv(this.pMaxU, this.pMaxV).setColor(1.0f, 1.0f, 1.0f, opacity);
        consumer.addVertex((Matrix4fc)this.matrix4f, this.pX2, this.pY1, this.pBlitOffset).setUv(this.pMaxU, this.pMinV).setColor(1.0f, 1.0f, 1.0f, opacity);
    }

    public BufferInfoRenderState toRenderState(Identifier location, GuiGraphics guiGraphics) {
        TextureSetup textureSetup = TextureSetup.singleTexture((GpuTextureView)Minecraft.getInstance().getTextureManager().getTexture(location).getTextureView(), (GpuSampler)Minecraft.getInstance().getTextureManager().getTexture(location).getSampler());
        return new BufferInfoRenderState(RenderPipelines.GUI_TEXTURED, textureSetup, (Matrix3x2f)guiGraphics.pose(), this.pX1, this.pY1, this.pX2, this.pY2, this.pMinU, this.pMaxU, this.pMinV, this.pMaxV, -1, guiGraphics.peekScissorStack());
    }

    public record RenderInfo(float opacity) {
        public static RenderInfo ofOpacity(float opacity) {
            return new RenderInfo(opacity);
        }
    }
}

