/*
 * Decompiled with CFR 0.152.
 */
package me.clefal.lootbeams.data.new_render;

import com.clefal.nirvana_lib.relocated.net.neoforged.bus.api.Event;
import java.util.ArrayList;
import java.util.List;
import me.clefal.lootbeams.LootBeamsConstants;
import me.clefal.lootbeams.config.configs.LightConfig;
import me.clefal.lootbeams.config.configs.LootInfomationConfig;
import me.clefal.lootbeams.data.lbitementity.LBItemEntity;
import me.clefal.lootbeams.data.lbitementity.rarity.LBRarity;
import me.clefal.lootbeams.events.TooltipsGatherNameAndRarityEvent;
import net.minecraft.class_1542;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_746;

public abstract class LootBeamRenderState {
    public final LBRarity rarity;
    public final class_243 location;
    public final class_4587.class_4665 poseStack;

    private LootBeamRenderState(LBRarity rarity, class_243 location, class_4587.class_4665 poseStack) {
        this.rarity = rarity;
        this.location = location;
        this.poseStack = poseStack;
    }

    public static class BeamRenderState
    extends LootBeamRenderState {
        public final int fadeIn;
        public final float partialTick;
        public final boolean onGround;
        public final boolean isShaderOn;

        public BeamRenderState(LBRarity rarity, class_243 location, class_4587.class_4665 poseStack, int fadeIn, float partialTick, boolean onGround, boolean isShaderOn) {
            super(rarity, location, poseStack);
            this.fadeIn = fadeIn;
            this.partialTick = partialTick;
            this.onGround = onGround;
            this.isShaderOn = isShaderOn;
        }

        public static BeamRenderState make(LBItemEntity lbItemEntity, class_4587.class_4665 stack, float partialTick, boolean isShaderOn) {
            class_1542 item = lbItemEntity.item();
            BeamRenderState beamRenderState = new BeamRenderState(lbItemEntity.rarity(), new class_243(item.method_23317(), item.method_23318(), item.method_23321()), stack, lbItemEntity.fadeIn(), partialTick, lbItemEntity.item().method_24828(), isShaderOn);
            if (lbItemEntity.fadeIn() < (Integer)LightConfig.lightConfig.beam.beam_fade_in_time.get()) {
                lbItemEntity.updateFade();
            }
            return beamRenderState;
        }
    }

    public static class NameTagRenderState
    extends LootBeamRenderState {
        public final List<class_2561> nameAndRarity;
        public final boolean isLookingAtThis;

        public NameTagRenderState(LBRarity rarity, class_243 location, class_4587.class_4665 poseStack, List<class_2561> nameAndRarity) {
            super(rarity, location, poseStack);
            this.nameAndRarity = nameAndRarity;
            this.isLookingAtThis = NameTagRenderState.isLookingAt(class_310.method_1551().field_1724, location, ((Float)LootInfomationConfig.lootInfomationConfig.nameTag.name_tag_look_sensitivity.get()).floatValue());
        }

        public static NameTagRenderState fromLBEntity(LBItemEntity lbItemEntity, class_4587.class_4665 stack) {
            class_1542 item = lbItemEntity.item();
            TooltipsGatherNameAndRarityEvent tooltipsGatherNameAndRarityEvent = new TooltipsGatherNameAndRarityEvent(lbItemEntity);
            LootBeamsConstants.EVENT_BUS.post((Event)tooltipsGatherNameAndRarityEvent);
            ArrayList<class_2561> nameAndRarity = new ArrayList<class_2561>(tooltipsGatherNameAndRarityEvent.gather.values());
            return new NameTagRenderState(lbItemEntity.rarity(), new class_243(item.method_23317(), item.method_23318(), item.method_23321()), stack, nameAndRarity);
        }

        public static boolean isLookingAt(class_746 player, class_243 position, double accuracy) {
            class_243 difference = new class_243(position.field_1352 - player.method_23317(), position.field_1351 - player.method_23320(), position.field_1350 - player.method_23321());
            double length = difference.method_1033();
            double dot = class_310.method_1551().method_1560().method_5720().method_1029().method_1026(difference.method_1029());
            return dot > 1.0 - accuracy / length;
        }
    }
}

