/*
 * Decompiled with CFR 0.152.
 */
package me.clefal.lootbeams.modules.beam;

import com.clefal.nirvana_lib.relocated.io.vavr.control.Option;
import java.util.function.Function;
import me.clefal.lootbeams.CommonClass;
import me.clefal.lootbeams.config.configs.LightConfig;
import me.clefal.lootbeams.data.lbitementity.LBItemEntity;
import me.clefal.lootbeams.data.lbitementity.rarity.LBColor;
import me.clefal.lootbeams.data.new_render.LootBeamRenderState;
import me.clefal.lootbeams.duck.PoseCopy;
import me.clefal.lootbeams.modules.beam.BeamRenderType;
import me.clefal.lootbeams.modules.dynamicprovider.DynamicProvider;
import me.clefal.lootbeams.modules.dynamicprovider.DynamicProviderModule;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_746;
import net.minecraft.class_7833;
import org.joml.Matrix3fc;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class BeamRenderer {
    private static final class_2960 MAIN_BEAM = CommonClass.id("textures/entity/main_beam.png");
    private static final class_2960 BEAM_TOP = CommonClass.id("textures/entity/beam_top.png");
    public static final BeamRenderer INSTANCE = new BeamRenderer();
    private boolean isShaderOn = false;

    public void renderLootBeam(class_4587 stack, class_4597 buffer, float partialTick, LBItemEntity LBItemEntity2, boolean isShaderOn) {
        PoseCopy last = (PoseCopy)stack.method_23760();
        this.isShaderOn = isShaderOn;
        this.renderLootBeam(buffer, LootBeamRenderState.BeamRenderState.make(LBItemEntity2, last.copy(), partialTick, isShaderOn));
    }

    public void renderLootBeam(class_4597 buffer, LootBeamRenderState.BeamRenderState renderState) {
        LBColor color = renderState.rarity.color();
        int lifeTime = renderState.fadeIn;
        class_4587.class_4665 pose = renderState.poseStack;
        class_4587 stack = new class_4587();
        stack.method_23760().method_23761().set((Matrix4fc)pose.method_23761());
        stack.method_23760().method_23762().set((Matrix3fc)pose.method_23762());
        LightConfig.Beam beamConfig = LightConfig.lightConfig.beam;
        LightConfig.Glow glowConfig = LightConfig.lightConfig.glow;
        int fadeInTime = (Integer)beamConfig.beam_fade_in_time.get();
        float fadeInFactor = 1.0f * (float)lifeTime / (float)fadeInTime;
        int R = color.red();
        int G = color.green();
        int B = color.blue();
        float preBeamAlpha = ((Float)beamConfig.beam_alpha.get()).floatValue();
        class_746 player = class_310.method_1551().field_1724;
        double distance = class_3532.method_15355((float)((float)player.method_5707(renderState.location)));
        float fadeDistance = ((Float)beamConfig.beam_fade_in_distance.get()).floatValue();
        if (distance > (double)fadeDistance) {
            float m = (float)distance - fadeDistance;
            preBeamAlpha *= 1.0f / Math.max(m / fadeDistance, 1.0f);
        }
        float beamRadius = 0.08f * ((Float)beamConfig.beam_radius.get()).floatValue();
        float beamHeight = ((Float)beamConfig.beam_height.get()).floatValue();
        float yOffset = ((Float)beamConfig.beam_y_offset.get()).floatValue();
        if (beamConfig.common_shorter_beam && renderState.rarity.absoluteOrdinal() <= 0) {
            beamHeight *= 0.65f;
            yOffset -= yOffset;
        }
        int beamAlpha = (int)(preBeamAlpha * 255.0f);
        Option<DynamicProvider> dynamicProvider1 = DynamicProviderModule.getDynamicProvider();
        if (dynamicProvider1.isDefined()) {
            beamAlpha = (int)((float)beamAlpha * Math.min(((DynamicProvider)dynamicProvider1.get()).getBeamLightFactor(), 1.0f));
            beamHeight += ((DynamicProvider)dynamicProvider1.get()).getBeamLightFactor() - 0.3f;
            beamRadius += 0.005f * ((DynamicProvider)dynamicProvider1.get()).getGlowFactor();
        }
        beamAlpha = (int)((float)beamAlpha * fadeInFactor);
        beamHeight *= fadeInFactor;
        Vector3f playerPos = player.method_30950(renderState.partialTick).method_46409();
        Vector3f targetPos = renderState.location.method_46409();
        Vector3f sub = targetPos.sub((Vector3fc)playerPos);
        Vector3f direction = sub.normalize();
        double v = Math.atan2(direction.x(), direction.z());
        float bloomRadius = beamRadius * 1.35f;
        int bloomAlpha = (int)((float)beamAlpha * 0.4f);
        stack.method_22903();
        stack.method_22907((Quaternionfc)class_7833.field_40716.rotation((float)v));
        Function<class_2960, class_4588> getBeam = location -> buffer.method_73477(BeamRenderType.getBeamRendertype(location, this.isShaderOn));
        stack.method_22903();
        stack.method_46416(0.0f, yOffset + 1.0f, 0.0f);
        class_4588 buffer1 = getBeam.apply(MAIN_BEAM);
        this.draw(stack, buffer1, R, G, B, beamAlpha, -beamRadius, beamRadius, -beamHeight, beamHeight, 0.001f);
        this.draw(stack, buffer1, R, G, B, bloomAlpha, -bloomRadius, bloomRadius, -beamHeight, beamHeight, 0.001f);
        class_4588 buffer2 = getBeam.apply(BEAM_TOP);
        if (!this.isShaderOn) {
            this.draw(stack, buffer2, R, G, B, beamAlpha, beamRadius, -beamRadius, beamHeight * 3.0f / 2.0f, beamHeight, 0.001f);
        } else {
            this.draw(stack, buffer2, R, G, B, beamAlpha, -beamRadius, beamRadius, beamHeight -= 0.25f, beamHeight * 3.0f / 2.0f, 0.001f);
        }
        if (!this.isShaderOn) {
            this.draw(stack, buffer2, R, G, B, bloomAlpha, bloomRadius, -bloomRadius, beamHeight * 3.0f / 2.0f, beamHeight, 0.001f);
        } else {
            this.draw(stack, buffer2, R, G, B, bloomAlpha, -bloomRadius, bloomRadius, beamHeight, beamHeight * 3.0f / 2.0f, 0.001f);
        }
        stack.method_22909();
        stack.method_22909();
        if (glowConfig.enable_glow && renderState.onGround) {
            stack.method_22903();
            stack.method_22907((Quaternionfc)class_7833.field_40714.rotationDegrees(90.0f));
            float radius = ((Float)glowConfig.glow_effect_radius.get()).floatValue();
            stack.method_46416(0.0f, -radius, -0.01f);
            this.renderGlow(stack, getBeam.apply(BeamRenderType.GLOW_TEXTURE), R, G, B, (int)((float)beamAlpha * 0.4f), radius);
            stack.method_22909();
        }
    }

    private void renderGlow(class_4587 stack, class_4588 builder, int red, int green, int blue, int alpha, float radius) {
        this.draw(stack, builder, red, green, blue, alpha, -radius, radius, 0.0f, 1.0f, 0.0f);
    }

    private void draw(class_4587 stack, class_4588 builder, int red, int green, int blue, int alpha, float minX, float maxX, float minY, float maxY, float z) {
        if (this.isShaderOn) {
            this.drawOnShader(stack, builder, red, green, blue, alpha, minX, maxX, minY, maxY, z);
        } else {
            this.drawWithoutShader(stack, builder, red, green, blue, alpha, minX, maxX, minY, maxY, z);
        }
    }

    private void drawWithoutShader(class_4587 stack, class_4588 builder, int red, int green, int blue, int alpha, float minX, float maxX, float minY, float maxY, float z) {
        class_4587.class_4665 matrixentry = stack.method_23760();
        Matrix4f matrixpose = matrixentry.method_23761();
        builder.method_22918((Matrix4fc)matrixpose, minX, minY, z).method_1336(red, green, blue, alpha).method_22913(0.0f, 0.0f).method_22922(class_4608.field_21444).method_60803(0xF000F0).method_60831(matrixentry, 0.0f, 1.0f, 0.0f);
        builder.method_22918((Matrix4fc)matrixpose, minX, maxY, z).method_1336(red, green, blue, alpha).method_22913(0.0f, 1.0f).method_22922(class_4608.field_21444).method_60803(0xF000F0).method_60831(matrixentry, 0.0f, 1.0f, 0.0f);
        builder.method_22918((Matrix4fc)matrixpose, maxX, maxY, z).method_1336(red, green, blue, alpha).method_22913(1.0f, 1.0f).method_22922(class_4608.field_21444).method_60803(0xF000F0).method_60831(matrixentry, 0.0f, 1.0f, 0.0f);
        builder.method_22918((Matrix4fc)matrixpose, maxX, minY, z).method_1336(red, green, blue, alpha).method_22913(1.0f, 0.0f).method_22922(class_4608.field_21444).method_60803(0xF000F0).method_60831(matrixentry, 0.0f, 1.0f, 0.0f);
    }

    private void drawOnShader(class_4587 stack, class_4588 builder, int red, int green, int blue, int alpha, float minX, float maxX, float minY, float maxY, float z) {
        class_4587.class_4665 matrixentry = stack.method_23760();
        Matrix4f matrixpose = matrixentry.method_23761();
        builder.method_22918((Matrix4fc)matrixpose, minX, minY, z).method_22913(0.0f, 1.0f).method_1336(red, green, blue, alpha).method_60803(0xF000F0);
        builder.method_22918((Matrix4fc)matrixpose, minX, maxY, z).method_22913(0.0f, 0.0f).method_1336(red, green, blue, alpha).method_60803(0xF000F0);
        builder.method_22918((Matrix4fc)matrixpose, maxX, maxY, z).method_22913(1.0f, 0.0f).method_1336(red, green, blue, alpha).method_60803(0xF000F0);
        builder.method_22918((Matrix4fc)matrixpose, maxX, minY, z).method_22913(1.0f, 1.0f).method_1336(red, green, blue, alpha).method_60803(0xF000F0);
    }
}

