/*
 * Decompiled with CFR 0.152.
 */
package com.clefal.nirvana_lib.client.render.batch;

import com.clefal.nirvana_lib.client.render.batch.BufferInfoRenderState;
import com.clefal.nirvana_lib.client.render.batch.DrawStringBufferInfo;
import com.clefal.nirvana_lib.client.render.batch.IFillBufferInfo;
import com.clefal.nirvana_lib.client.render.batch.ITextureBufferInfo;
import com.clefal.nirvana_lib.client.render.batch.TextureBufferInfo;
import com.clefal.nirvana_lib.mixin.GuiGraphicsAccessor;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import com.mojang.math.Divisor;
import it.unimi.dsi.fastutil.ints.IntIterator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.render.state.GuiElementRenderState;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import org.joml.Matrix4f;

public class VertexContainer {
    public Multimap<ResourceLocation, ITextureBufferInfo> map = Multimaps.newListMultimap(new TreeMap(), ArrayList::new);
    public List<IFillBufferInfo> fillBufferInfos = new ArrayList<IFillBufferInfo>();
    public List<DrawStringBufferInfo> strings = new ArrayList<DrawStringBufferInfo>();

    public VertexContainer() {
    }

    public VertexContainer(int expectedKeys, int expectedValuesPerKey) {
        this.map = HashMultimap.create((int)expectedKeys, (int)expectedValuesPerKey);
    }

    public void putBliz(ResourceLocation resourceLocation, TextureBufferInfo bufferInfo) {
        this.putBliz(resourceLocation, (ITextureBufferInfo)bufferInfo);
    }

    public void putBliz(ResourceLocation resourceLocation, ITextureBufferInfo bufferInfo) {
        this.map.put((Object)resourceLocation, (Object)bufferInfo);
    }

    public void putBlitNineSliced(ResourceLocation atlasLocation, int x, int y, int width, int height, int sliceSize, int uOffset, int vOffset, int textureX, int textureY, Matrix4f matrix4f) {
        this.putBlitNineSliced(atlasLocation, x, y, width, height, sliceSize, sliceSize, sliceSize, sliceSize, uOffset, vOffset, textureX, textureY, matrix4f);
    }

    public void putBlitNineSliced(ResourceLocation atlasLocation, int x, int y, int width, int height, int sliceWidth, int sliceHeight, int uWidth, int vHeight, int textureX, int textureY, Matrix4f matrix4f) {
        this.putBlitNineSliced(atlasLocation, x, y, width, height, sliceWidth, sliceHeight, sliceWidth, sliceHeight, uWidth, vHeight, textureX, textureY, matrix4f);
    }

    public void putBlitNineSliced(ResourceLocation atlasLocation, int x, int y, int width, int height, int leftSliceWidth, int topSliceHeight, int rightSliceWidth, int bottomSliceHeight, int uWidth, int vHeight, int textureX, int textureY, Matrix4f matrix4f) {
        leftSliceWidth = Math.min(leftSliceWidth, width / 2);
        rightSliceWidth = Math.min(rightSliceWidth, width / 2);
        topSliceHeight = Math.min(topSliceHeight, height / 2);
        bottomSliceHeight = Math.min(bottomSliceHeight, height / 2);
        if (width == uWidth && height == vHeight) {
            this.putBliz(atlasLocation, TextureBufferInfo.of(x, y, textureX, textureY, width, height, matrix4f));
        } else if (height == vHeight) {
            this.putBliz(atlasLocation, TextureBufferInfo.of(x, y, textureX, textureY, leftSliceWidth, height, matrix4f));
            this.putBlizRepeating(atlasLocation, x + leftSliceWidth, y, width - rightSliceWidth - leftSliceWidth, height, textureX + leftSliceWidth, textureY, uWidth - rightSliceWidth - leftSliceWidth, vHeight, matrix4f);
            this.putBliz(atlasLocation, TextureBufferInfo.of(x + width - rightSliceWidth, y, textureX + uWidth - rightSliceWidth, textureY, rightSliceWidth, height, matrix4f));
        } else if (width == uWidth) {
            this.putBliz(atlasLocation, TextureBufferInfo.of(x, y, textureX, textureY, width, topSliceHeight, matrix4f));
            this.putBlizRepeating(atlasLocation, x, y + topSliceHeight, width, height - bottomSliceHeight - topSliceHeight, textureX, textureY + topSliceHeight, uWidth, vHeight - bottomSliceHeight - topSliceHeight, matrix4f);
            this.putBliz(atlasLocation, TextureBufferInfo.of(x, y + height - bottomSliceHeight, textureX, textureY + vHeight - bottomSliceHeight, width, bottomSliceHeight, matrix4f));
        } else {
            this.putBliz(atlasLocation, TextureBufferInfo.of(x, y, textureX, textureY, leftSliceWidth, topSliceHeight, matrix4f));
            this.putBlizRepeating(atlasLocation, x + leftSliceWidth, y, width - rightSliceWidth - leftSliceWidth, topSliceHeight, textureX + leftSliceWidth, textureY, uWidth - rightSliceWidth - leftSliceWidth, topSliceHeight, matrix4f);
            this.putBliz(atlasLocation, TextureBufferInfo.of(x + width - rightSliceWidth, y, textureX + uWidth - rightSliceWidth, textureY, rightSliceWidth, topSliceHeight, matrix4f));
            this.putBliz(atlasLocation, TextureBufferInfo.of(x, y + height - bottomSliceHeight, textureX, textureY + vHeight - bottomSliceHeight, leftSliceWidth, bottomSliceHeight, matrix4f));
            this.putBlizRepeating(atlasLocation, x + leftSliceWidth, y + height - bottomSliceHeight, width - rightSliceWidth - leftSliceWidth, bottomSliceHeight, textureX + leftSliceWidth, textureY + vHeight - bottomSliceHeight, uWidth - rightSliceWidth - leftSliceWidth, bottomSliceHeight, matrix4f);
            this.putBliz(atlasLocation, TextureBufferInfo.of(x + width - rightSliceWidth, y + height - bottomSliceHeight, textureX + uWidth - rightSliceWidth, textureY + vHeight - bottomSliceHeight, rightSliceWidth, bottomSliceHeight, matrix4f));
            this.putBlizRepeating(atlasLocation, x, y + topSliceHeight, leftSliceWidth, height - bottomSliceHeight - topSliceHeight, textureX, textureY + topSliceHeight, leftSliceWidth, vHeight - bottomSliceHeight - topSliceHeight, matrix4f);
            this.putBlizRepeating(atlasLocation, x + leftSliceWidth, y + topSliceHeight, width - rightSliceWidth - leftSliceWidth, height - bottomSliceHeight - topSliceHeight, textureX + leftSliceWidth, textureY + topSliceHeight, uWidth - rightSliceWidth - leftSliceWidth, vHeight - bottomSliceHeight - topSliceHeight, matrix4f);
            this.putBlizRepeating(atlasLocation, x + width - rightSliceWidth, y + topSliceHeight, leftSliceWidth, height - bottomSliceHeight - topSliceHeight, textureX + uWidth - rightSliceWidth, textureY + topSliceHeight, rightSliceWidth, vHeight - bottomSliceHeight - topSliceHeight, matrix4f);
        }
    }

    public void putBlizRepeating(ResourceLocation atlasLocation, int x, int y, int width, int height, int uOffset, int vOffset, int sourceWidth, int sourceHeight, Matrix4f matrix4f) {
        this.putBlizRepeating(atlasLocation, x, y, width, height, uOffset, vOffset, sourceWidth, sourceHeight, 256, 256, matrix4f);
    }

    public void putBlizRepeating(ResourceLocation atlasLocation, int x, int y, int width, int height, int uOffset, int vOffset, int sourceWidth, int sourceHeight, int textureWidth, int textureHeight, Matrix4f matrix4f) {
        int i = x;
        IntIterator intiterator = VertexContainer.slices(width, sourceWidth);
        while (intiterator.hasNext()) {
            int j = intiterator.nextInt();
            int k = (sourceWidth - j) / 2;
            int l = y;
            IntIterator intiterator1 = VertexContainer.slices(height, sourceHeight);
            while (intiterator1.hasNext()) {
                int i1 = intiterator1.nextInt();
                int j1 = (sourceHeight - i1) / 2;
                this.putBliz(atlasLocation, TextureBufferInfo.of(i, l, uOffset + k, vOffset + j1, j, i1, textureWidth, textureHeight, matrix4f));
                l += i1;
            }
            i += j;
        }
    }

    private static IntIterator slices(int target, int total) {
        int i = Mth.positiveCeilDiv((int)target, (int)total);
        return new Divisor(target, i);
    }

    public void putFill(IFillBufferInfo fillBufferInfo) {
        this.fillBufferInfos.add(fillBufferInfo);
    }

    public void putString(DrawStringBufferInfo s) {
        this.strings.add(s);
    }

    private void refresh() {
        this.map = HashMultimap.create((int)10, (int)100);
        this.fillBufferInfos = new ArrayList<IFillBufferInfo>();
        this.strings.clear();
    }

    public void draw(GuiGraphics guiGraphics) {
        for (Map.Entry entry : this.map.asMap().entrySet()) {
            ResourceLocation key = (ResourceLocation)entry.getKey();
            for (ITextureBufferInfo bufferInfo : (Collection)entry.getValue()) {
                if (!(bufferInfo instanceof TextureBufferInfo)) continue;
                TextureBufferInfo textureBufferInfo = (TextureBufferInfo)bufferInfo;
                BufferInfoRenderState renderState = textureBufferInfo.toRenderState(key, guiGraphics);
                ((GuiGraphicsAccessor)guiGraphics).getGuiRenderState().submitGuiElement((GuiElementRenderState)renderState);
            }
        }
        if (!this.fillBufferInfos.isEmpty()) {
            for (IFillBufferInfo fillBufferInfo : this.fillBufferInfos) {
                ((GuiGraphicsAccessor)guiGraphics).getGuiRenderState().submitGuiElement((GuiElementRenderState)fillBufferInfo.toRenderState(guiGraphics));
            }
        }
        if (!this.strings.isEmpty()) {
            for (DrawStringBufferInfo string : this.strings) {
                ((GuiGraphicsAccessor)guiGraphics).getGuiRenderState().submitText(string.toRenderState(guiGraphics));
            }
        }
        this.refresh();
    }
}

