/*
 * Decompiled with CFR 0.152.
 */
package me.clefal.lootbeams.modules.beam;

import com.mojang.blaze3d.pipeline.RenderPipeline;
import java.util.function.Function;
import me.clefal.lootbeams.CommonClass;
import net.minecraft.Util;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.client.renderer.RenderStateShard;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.resources.ResourceLocation;

public abstract class BeamRenderType
extends RenderType {
    public static final ResourceLocation LOOT_BEAM_TEXTURE = CommonClass.id("textures/entity/loot_beam.png");
    public static final ResourceLocation WHITE_TEXTURE = CommonClass.id("textures/entity/white.png");
    public static final ResourceLocation GLOW_TEXTURE = CommonClass.id("textures/entity/glow.png");
    private static final Function<ResourceLocation, RenderType> beamOnShader = Util.memoize(location -> {
        RenderType.CompositeState compositeState = RenderType.CompositeState.builder().setTextureState((RenderStateShard.EmptyTextureStateShard)new RenderStateShard.TextureStateShard(location, false)).setLightmapState(LIGHTMAP).setOverlayState(OVERLAY).setLayeringState(VIEW_OFFSET_Z_LAYERING).createCompositeState(true);
        return BeamRenderType.create((String)"translucent_beam", (int)1536, (boolean)true, (boolean)true, (RenderPipeline)RenderPipelines.TRANSLUCENT_PARTICLE, (RenderType.CompositeState)compositeState);
    });

    public BeamRenderType(String name, int bufferSize, boolean affectsCrumbling, boolean sortOnUpload, Runnable setupState, Runnable clearState) {
        super(name, bufferSize, affectsCrumbling, sortOnUpload, setupState, clearState);
    }

    public static RenderType getBeamRendertype(ResourceLocation location, boolean isShaderOn) {
        if (isShaderOn) {
            return beamOnShader.apply(location);
        }
        return RenderType.beaconBeam((ResourceLocation)location, (boolean)true);
    }
}

