/*
 * Decompiled with CFR 0.152.
 */
package me.clefal.lootbeams.modules.beam;

import com.clefal.nirvana_lib.relocated.io.vavr.control.Option;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import java.util.function.Function;
import me.clefal.lootbeams.CommonClass;
import me.clefal.lootbeams.config.configs.LightConfig;
import me.clefal.lootbeams.data.lbitementity.LBItemEntity;
import me.clefal.lootbeams.data.lbitementity.rarity.LBColor;
import me.clefal.lootbeams.data.new_render.LootBeamRenderState;
import me.clefal.lootbeams.duck.PoseCopy;
import me.clefal.lootbeams.modules.beam.BeamRenderType;
import me.clefal.lootbeams.modules.dynamicprovider.DynamicProvider;
import me.clefal.lootbeams.modules.dynamicprovider.DynamicProviderModule;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import org.joml.Matrix3fc;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class BeamRenderer {
    private static final ResourceLocation MAIN_BEAM = CommonClass.id("textures/entity/main_beam.png");
    private static final ResourceLocation BEAM_TOP = CommonClass.id("textures/entity/beam_top.png");
    public static final BeamRenderer INSTANCE = new BeamRenderer();
    private boolean isShaderOn = false;

    public void renderLootBeam(PoseStack stack, MultiBufferSource buffer, float partialTick, LBItemEntity LBItemEntity2, boolean isShaderOn) {
        PoseCopy last = (PoseCopy)stack.last();
        this.isShaderOn = isShaderOn;
        this.renderLootBeam(buffer, LootBeamRenderState.BeamRenderState.make(LBItemEntity2, last.copy(), partialTick, isShaderOn));
    }

    public void renderLootBeam(MultiBufferSource buffer, LootBeamRenderState.BeamRenderState renderState) {
        LBColor color = renderState.rarity.color();
        int lifeTime = renderState.fadeIn;
        PoseStack.Pose pose = renderState.poseStack;
        PoseStack stack = new PoseStack();
        stack.last().pose().set((Matrix4fc)pose.pose());
        stack.last().normal().set((Matrix3fc)pose.normal());
        LightConfig.Beam beamConfig = LightConfig.lightConfig.beam;
        LightConfig.Glow glowConfig = LightConfig.lightConfig.glow;
        int fadeInTime = (Integer)beamConfig.beam_fade_in_time.get();
        float fadeInFactor = 1.0f * (float)lifeTime / (float)fadeInTime;
        int R = color.red();
        int G = color.green();
        int B = color.blue();
        float preBeamAlpha = ((Float)beamConfig.beam_alpha.get()).floatValue();
        LocalPlayer player = Minecraft.getInstance().player;
        double distance = Mth.sqrt((float)((float)player.distanceToSqr(renderState.location)));
        float fadeDistance = ((Float)beamConfig.beam_fade_in_distance.get()).floatValue();
        if (distance > (double)fadeDistance) {
            float m = (float)distance - fadeDistance;
            preBeamAlpha *= 1.0f / Math.max(m / fadeDistance, 1.0f);
        }
        float beamRadius = 0.08f * ((Float)beamConfig.beam_radius.get()).floatValue();
        float beamHeight = ((Float)beamConfig.beam_height.get()).floatValue();
        float yOffset = ((Float)beamConfig.beam_y_offset.get()).floatValue();
        if (beamConfig.common_shorter_beam && renderState.rarity.absoluteOrdinal() <= 0) {
            beamHeight *= 0.65f;
            yOffset -= yOffset;
        }
        int beamAlpha = (int)(preBeamAlpha * 255.0f);
        Option<DynamicProvider> dynamicProvider1 = DynamicProviderModule.getDynamicProvider();
        if (dynamicProvider1.isDefined()) {
            beamAlpha = (int)((float)beamAlpha * Math.min(((DynamicProvider)dynamicProvider1.get()).getBeamLightFactor(), 1.0f));
            beamHeight += ((DynamicProvider)dynamicProvider1.get()).getBeamLightFactor() - 0.3f;
            beamRadius += 0.005f * ((DynamicProvider)dynamicProvider1.get()).getGlowFactor();
        }
        beamAlpha = (int)((float)beamAlpha * fadeInFactor);
        beamHeight *= fadeInFactor;
        Vector3f playerPos = player.getPosition(renderState.partialTick).toVector3f();
        Vector3f targetPos = renderState.location.toVector3f();
        Vector3f sub = targetPos.sub((Vector3fc)playerPos);
        Vector3f direction = sub.normalize();
        double v = Math.atan2(direction.x(), direction.z());
        float bloomRadius = beamRadius * 1.35f;
        int bloomAlpha = (int)((float)beamAlpha * 0.4f);
        stack.pushPose();
        stack.mulPose((Quaternionfc)Axis.YP.rotation((float)v));
        Function<ResourceLocation, VertexConsumer> getBeam = location -> buffer.getBuffer(BeamRenderType.getBeamRendertype(location, this.isShaderOn));
        stack.pushPose();
        stack.translate(0.0f, yOffset + 1.0f, 0.0f);
        VertexConsumer buffer1 = getBeam.apply(MAIN_BEAM);
        this.draw(stack, buffer1, R, G, B, beamAlpha, -beamRadius, beamRadius, -beamHeight, beamHeight, 0.001f);
        this.draw(stack, buffer1, R, G, B, bloomAlpha, -bloomRadius, bloomRadius, -beamHeight, beamHeight, 0.001f);
        VertexConsumer buffer2 = getBeam.apply(BEAM_TOP);
        if (!this.isShaderOn) {
            this.draw(stack, buffer2, R, G, B, beamAlpha, beamRadius, -beamRadius, beamHeight * 3.0f / 2.0f, beamHeight, 0.001f);
        } else {
            this.draw(stack, buffer2, R, G, B, beamAlpha, -beamRadius, beamRadius, beamHeight -= 0.25f, beamHeight * 3.0f / 2.0f, 0.001f);
        }
        if (!this.isShaderOn) {
            this.draw(stack, buffer2, R, G, B, bloomAlpha, bloomRadius, -bloomRadius, beamHeight * 3.0f / 2.0f, beamHeight, 0.001f);
        } else {
            this.draw(stack, buffer2, R, G, B, bloomAlpha, -bloomRadius, bloomRadius, beamHeight, beamHeight * 3.0f / 2.0f, 0.001f);
        }
        stack.popPose();
        stack.popPose();
        if (glowConfig.enable_glow && renderState.onGround) {
            stack.pushPose();
            stack.mulPose((Quaternionfc)Axis.XP.rotationDegrees(90.0f));
            float radius = ((Float)glowConfig.glow_effect_radius.get()).floatValue();
            stack.translate(0.0f, -radius, -0.01f);
            this.renderGlow(stack, getBeam.apply(BeamRenderType.GLOW_TEXTURE), R, G, B, (int)((float)beamAlpha * 0.4f), radius);
            stack.popPose();
        }
    }

    private void renderGlow(PoseStack stack, VertexConsumer builder, int red, int green, int blue, int alpha, float radius) {
        this.draw(stack, builder, red, green, blue, alpha, -radius, radius, 0.0f, 1.0f, 0.0f);
    }

    private void draw(PoseStack stack, VertexConsumer builder, int red, int green, int blue, int alpha, float minX, float maxX, float minY, float maxY, float z) {
        if (this.isShaderOn) {
            this.drawOnShader(stack, builder, red, green, blue, alpha, minX, maxX, minY, maxY, z);
        } else {
            this.drawWithoutShader(stack, builder, red, green, blue, alpha, minX, maxX, minY, maxY, z);
        }
    }

    private void drawWithoutShader(PoseStack stack, VertexConsumer builder, int red, int green, int blue, int alpha, float minX, float maxX, float minY, float maxY, float z) {
        PoseStack.Pose matrixentry = stack.last();
        Matrix4f matrixpose = matrixentry.pose();
        builder.addVertex(matrixpose, minX, minY, z).setColor(red, green, blue, alpha).setUv(0.0f, 0.0f).setOverlay(OverlayTexture.NO_OVERLAY).setLight(0xF000F0).setNormal(matrixentry, 0.0f, 1.0f, 0.0f);
        builder.addVertex(matrixpose, minX, maxY, z).setColor(red, green, blue, alpha).setUv(0.0f, 1.0f).setOverlay(OverlayTexture.NO_OVERLAY).setLight(0xF000F0).setNormal(matrixentry, 0.0f, 1.0f, 0.0f);
        builder.addVertex(matrixpose, maxX, maxY, z).setColor(red, green, blue, alpha).setUv(1.0f, 1.0f).setOverlay(OverlayTexture.NO_OVERLAY).setLight(0xF000F0).setNormal(matrixentry, 0.0f, 1.0f, 0.0f);
        builder.addVertex(matrixpose, maxX, minY, z).setColor(red, green, blue, alpha).setUv(1.0f, 0.0f).setOverlay(OverlayTexture.NO_OVERLAY).setLight(0xF000F0).setNormal(matrixentry, 0.0f, 1.0f, 0.0f);
    }

    private void drawOnShader(PoseStack stack, VertexConsumer builder, int red, int green, int blue, int alpha, float minX, float maxX, float minY, float maxY, float z) {
        PoseStack.Pose matrixentry = stack.last();
        Matrix4f matrixpose = matrixentry.pose();
        builder.addVertex(matrixpose, minX, minY, z).setUv(0.0f, 1.0f).setColor(red, green, blue, alpha).setLight(0xF000F0);
        builder.addVertex(matrixpose, minX, maxY, z).setUv(0.0f, 0.0f).setColor(red, green, blue, alpha).setLight(0xF000F0);
        builder.addVertex(matrixpose, maxX, maxY, z).setUv(1.0f, 0.0f).setColor(red, green, blue, alpha).setLight(0xF000F0);
        builder.addVertex(matrixpose, maxX, minY, z).setUv(1.0f, 1.0f).setColor(red, green, blue, alpha).setLight(0xF000F0);
    }
}

