/*
 * Decompiled with CFR 0.152.
 */
package me.clefal.lootbeams.modules.tooltip.nametag;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import java.awt.Color;
import java.util.List;
import java.util.Objects;
import me.clefal.lootbeams.config.configs.LootInfomationConfig;
import me.clefal.lootbeams.data.lbitementity.LBItemEntity;
import me.clefal.lootbeams.data.lbitementity.rarity.LBColor;
import me.clefal.lootbeams.data.new_render.LootBeamRenderState;
import me.clefal.lootbeams.duck.PoseCopy;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import org.joml.Matrix3fc;
import org.joml.Matrix4fc;

public class NameTagRenderer {
    public static void renderNameTag(PoseStack stack, MultiBufferSource buffer, LBItemEntity LBItemEntity2) {
        PoseCopy last = (PoseCopy)stack.last();
        NameTagRenderer.renderNameTag(buffer, LootBeamRenderState.NameTagRenderState.fromLBEntity(LBItemEntity2, last.copy()));
    }

    public static void renderNameTag(MultiBufferSource buffer, LootBeamRenderState.NameTagRenderState renderState) {
        LootInfomationConfig.nameTagSection nameTagSection2 = LootInfomationConfig.lootInfomationConfig.nameTag;
        PoseStack.Pose pose = renderState.poseStack;
        PoseStack stack = new PoseStack();
        stack.last().pose().set((Matrix4fc)pose.pose());
        stack.last().normal().set((Matrix3fc)pose.normal());
        if (Minecraft.getInstance().player.isCrouching() || nameTagSection2.render_name_tag_on_look && renderState.isLookingAtThis) {
            LBColor color = renderState.rarity.color();
            float foregroundAlpha = ((Float)nameTagSection2.name_tag_text_alpha.get()).floatValue();
            float backgroundAlpha = ((Float)nameTagSection2.name_tag_background_alpha.get()).floatValue();
            double yOffset = ((Float)nameTagSection2.name_tag_y_offset.get()).floatValue();
            int foregroundColor = color.changeA((int)(foregroundAlpha * 255.0f)).argb();
            int backgroundColor = color.changeA((int)(foregroundAlpha * 255.0f)).argb();
            stack.pushPose();
            stack.translate(0.0, Math.min(1.0, Minecraft.getInstance().player.distanceToSqr(renderState.location) * 0.025) + yOffset, 0.0);
            stack.mulPose(Minecraft.getInstance().getEntityRenderDispatcher().cameraOrientation());
            stack.mulPose(Axis.YP.rotationDegrees(180.0f));
            float nametagScale = ((Float)nameTagSection2.name_tag_scale.get()).floatValue();
            stack.scale(-0.02f * nametagScale, -0.02f * nametagScale, 0.02f * nametagScale);
            List<Component> nameAndRarity = renderState.nameAndRarity;
            Font fontrenderer = Minecraft.getInstance().font;
            stack.translate(0.0f, 2.0f, -10.0f);
            for (Component c : nameAndRarity) {
                String s = c.getString();
                if (s.isBlank()) continue;
                NameTagRenderer.renderText(fontrenderer, stack, buffer, s, foregroundColor, backgroundColor, backgroundAlpha);
                Objects.requireNonNull(Minecraft.getInstance().font);
                stack.translate(0.0f, 9.0f, 0.0f);
            }
            stack.popPose();
        }
    }

    private static void renderText(Font fontRenderer, PoseStack stack, MultiBufferSource buffer, String text, int foregroundColor, int backgroundColor, float backgroundAlpha) {
        if (LootInfomationConfig.lootInfomationConfig.nameTag.add_text_border) {
            float w = (float)(-fontRenderer.width(text)) / 2.0f;
            int bg = new Color(0, 0, 0, (int)(255.0f * backgroundAlpha)).getRGB();
            MutableComponent comp = Component.literal((String)text);
            fontRenderer.drawInBatch8xOutline(comp.getVisualOrderText(), w, 0.0f, foregroundColor, bg, stack.last().pose(), buffer, 0xF000F0);
        } else {
            fontRenderer.drawInBatch(text, (float)(-fontRenderer.width(text) / 2), 30.0f, foregroundColor, false, stack.last().pose(), buffer, Font.DisplayMode.NORMAL, backgroundColor, 0xF000E0);
        }
    }
}

