/*
 * Decompiled with CFR 0.152.
 */
package com.clefal.lootbeams.compat;

import com.clefal.lootbeams.LootBeamsConstants;
import com.clefal.lootbeams.data.lbitementity.LBItemEntity;
import com.clefal.lootbeams.data.lbitementity.rarity.ILBRarityApplier;
import com.clefal.lootbeams.data.lbitementity.rarity.LBColor;
import com.clefal.lootbeams.data.lbitementity.rarity.LBRarity;
import com.clefal.lootbeams.events.RegisterLBRarityEvent;
import com.clefal.lootbeams.modules.ILBCompatModule;
import com.clefal.nirvana_lib.relocated.io.vavr.control.Option;
import com.stereowalker.tiered.Reforged;
import com.stereowalker.tiered.api.PotentialAttribute;
import java.io.Serializable;
import net.minecraft.Util;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModList;

public class TieredReforgedCompatModule
implements ILBCompatModule {
    public static final TieredReforgedCompatModule INSTANCE = new TieredReforgedCompatModule();

    @Override
    public boolean shouldBeEnable() {
        try {
            Class.forName("com.stereowalker.tiered.Reforged");
        }
        catch (ClassNotFoundException e) {
            return false;
        }
        return ModList.get().isLoaded("tiered");
    }

    @Override
    public void tryEnable() {
        if (this.shouldBeEnable()) {
            LootBeamsConstants.LOGGER.info("Detected Tiered Reforged, enable TieredReforgedCompatModule!");
            LootBeamsConstants.EVENT_BUS.register(INSTANCE);
        }
    }

    @SubscribeEvent
    public void onEnable(RegisterLBRarityEvent.Pre event) {
        event.register((ILBRarityApplier & Serializable)itemEntity -> {
            ItemStack item1 = itemEntity.getItem();
            if (item1.get(DataComponents.CUSTOM_NAME) == null && Reforged.hasModifier((ItemStack)item1)) {
                ResourceLocation tier = (ResourceLocation)item1.get(Reforged.ComponentsRegistry.MODIFIER);
                PotentialAttribute potentialAttribute = (PotentialAttribute)Reforged.TIER_DATA.getTiers().get(tier);
                if (potentialAttribute != null) {
                    return Option.some((Object)LBItemEntity.of(itemEntity, LBRarity.of((Component)(potentialAttribute.getLiteralName() != null ? Component.literal((String)potentialAttribute.getLiteralName()) : Component.translatable((String)Util.makeDescriptionId((String)"tier", (ResourceLocation)Reforged.getKey((PotentialAttribute)potentialAttribute)))), LBColor.of(potentialAttribute.getStyle().getColor().getValue()), 0)));
                }
            }
            return Option.none();
        });
    }
}

