/*
 * Decompiled with CFR 0.152.
 */
package com.clefal.lootbeams.config.persistent;

import com.clefal.lootbeams.config.configs.Checker;
import com.clefal.lootbeams.config.configs.CustomConfig;
import com.clefal.lootbeams.config.persistent.PersistentConfigData;
import com.clefal.lootbeams.data.lbitementity.LBItemEntity;
import com.clefal.lootbeams.events.RegisterConfigConditionEvent;
import java.util.Set;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.CrossbowItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ShieldItem;
import net.minecraft.world.item.TieredItem;
import net.minecraft.world.item.TridentItem;

public class EquipmentConditions
extends PersistentConfigData<RegisterConfigConditionEvent.RegisterEquipmentItemEvent> {
    public static final EquipmentConditions INSTANCE = new EquipmentConditions();

    public EquipmentConditions() {
        CustomConfig.EquipmentRegister equipmentRegister = CustomConfig.customConfig.equipmentRegister;
        this.conditions.add(item -> Checker.checkItemInItemList(item, equipmentRegister.by_name));
        this.conditions.add(item -> Checker.checkItemHasTagInTagList(item, equipmentRegister.by_tag));
        this.conditions.add(item -> Checker.checkIsInThisModList(item, equipmentRegister.by_modid));
    }

    public static boolean isEquipment(LBItemEntity lbItemEntity) {
        Set resourceLocations = (Set)CustomConfig.customConfig.equipmentRegister.blacklist_by_name.get();
        Item item = lbItemEntity.item().getItem().getItem();
        return !resourceLocations.contains(lbItemEntity.resourceLocation()) && (item instanceof TieredItem || item instanceof ArmorItem || item instanceof ShieldItem || item instanceof BowItem || item instanceof CrossbowItem || item instanceof TridentItem || EquipmentConditions.INSTANCE.conditions.stream().anyMatch(x -> x.test(lbItemEntity)));
    }

    @Override
    public RegisterConfigConditionEvent.RegisterEquipmentItemEvent getEvent() {
        return new RegisterConfigConditionEvent.RegisterEquipmentItemEvent();
    }
}

