/*
 * Decompiled with CFR 0.152.
 */
package com.clefal.lootbeams.data.lbitementity;

import com.clefal.lootbeams.config.configs.CustomConfig;
import com.clefal.lootbeams.data.lbitementity.rarity.LBRarity;
import lombok.Generated;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.item.ItemEntity;

public class LBItemEntity {
    private final ItemEntity item;
    private final ResourceLocation resourceLocation;
    private LBRarity rarity;
    private boolean isSounded;
    private RenderState canBeRender = RenderState.NONE;
    private int fadeIn;

    private LBItemEntity(ItemEntity item, LBRarity rarity, boolean isSounded, int fadeIn) {
        this.item = item;
        this.resourceLocation = BuiltInRegistries.ITEM.getKey((Object)item.getItem().getItem());
        this.rarity = rarity;
        this.isSounded = isSounded;
        this.fadeIn = fadeIn;
    }

    public static LBItemEntity of(ItemEntity item, LBRarity rarity) {
        return new LBItemEntity(item, rarity, false, 0);
    }

    public LBItemEntity to(LBRarity rarity) {
        return LBItemEntity.of(this.item, rarity);
    }

    public void updateFade() {
        ++this.fadeIn;
    }

    public void passThis() {
        if (this.canBeRender != RenderState.PASS) {
            this.canBeRender = RenderState.PASS;
        }
    }

    public void rejectThis() {
        if (this.canBeRender != RenderState.REJECT) {
            this.canBeRender = RenderState.REJECT;
        }
    }

    public void updateSounded() {
        this.isSounded = true;
    }

    public boolean isCommon() {
        return this.rarity.absoluteOrdinal() <= 0;
    }

    public boolean isRare() {
        int min = (Integer)CustomConfig.customConfig.rareCondition.rare_ordinal_min.get();
        return this.rarity.absoluteOrdinal() >= min;
    }

    @Generated
    public ItemEntity item() {
        return this.item;
    }

    @Generated
    public ResourceLocation resourceLocation() {
        return this.resourceLocation;
    }

    @Generated
    public LBRarity rarity() {
        return this.rarity;
    }

    @Generated
    public boolean isSounded() {
        return this.isSounded;
    }

    @Generated
    public RenderState canBeRender() {
        return this.canBeRender;
    }

    @Generated
    public int fadeIn() {
        return this.fadeIn;
    }

    public static enum RenderState {
        PASS,
        REJECT,
        NONE;

    }
}

