/*
 * Decompiled with CFR 0.152.
 */
package com.clefal.lootbeams.data.lbitementity.rarity;

import net.minecraft.network.chat.TextColor;

public class LBColor {
    int argb;

    public LBColor(int argb) {
        this.argb = argb;
    }

    public static LBColor of(int argb) {
        return new LBColor(argb);
    }

    public static LBColor fromRGB(int rgb) {
        int red = rgb >> 16 & 0xFF;
        int green = rgb >> 8 & 0xFF;
        int blue = rgb & 0xFF;
        int alpha = 255;
        int argb = alpha << 24 | red << 16 | green << 8 | blue;
        return new LBColor(argb);
    }

    public static Mutable ofMutable(TextColor color) {
        return new Mutable(color);
    }

    public int rgb() {
        return this.argb & 0xFFFFFF;
    }

    public LBColor changeA(int a) {
        return new LBColor(a << 24 | this.argb() & 0xFFFFFF);
    }

    public int argb() {
        return this.argb;
    }

    public static class Mutable
    extends LBColor {
        TextColor color;

        private Mutable(TextColor color) {
            super(color.getValue());
            this.color = color;
        }

        @Override
        public int rgb() {
            return this.color.getValue();
        }

        @Override
        public int argb() {
            int a = this.argb >> 24 & 0xFF;
            return a << 24 | this.rgb();
        }
    }
}

