/*
 * Decompiled with CFR 0.152.
 */
package com.clefal.lootbeams.modules.beam;

import com.clefal.lootbeams.config.configs.LightConfig;
import com.clefal.lootbeams.data.lbitementity.LBItemEntity;
import com.clefal.lootbeams.data.lbitementity.rarity.LBColor;
import com.clefal.lootbeams.modules.beam.BeamRenderType;
import com.clefal.lootbeams.modules.dynamicprovider.DynamicProvider;
import com.clefal.lootbeams.modules.dynamicprovider.DynamicProviderModule;
import com.clefal.nirvana_lib.relocated.io.vavr.control.Option;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.util.FastColor;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import org.joml.Matrix4f;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class BeamRenderer {
    public static void renderLootBeam(PoseStack stack, MultiBufferSource buffer, float partialTick, LBItemEntity LBItemEntity2) {
        float fadeDistance;
        ItemEntity itemEntity = LBItemEntity2.item();
        LBColor color = LBItemEntity2.rarity().color();
        int lifeTime = LBItemEntity2.fadeIn();
        LightConfig.Beam beamConfig = LightConfig.lightConfig.beam;
        LightConfig.Glow glowConfig = LightConfig.lightConfig.glow;
        int fadeInTime = (Integer)beamConfig.beam_fade_in_time.get();
        float fadeInFactor = 1.0f * (float)lifeTime / (float)fadeInTime;
        int argb = color.argb();
        int R = FastColor.ARGB32.red((int)argb);
        int G = FastColor.ARGB32.green((int)argb);
        int B = FastColor.ARGB32.blue((int)argb);
        float preBeamAlpha = ((Float)beamConfig.beam_alpha.get()).floatValue();
        LocalPlayer player = Minecraft.getInstance().player;
        double distance = player.distanceTo((Entity)itemEntity);
        if (distance > (double)(fadeDistance = ((Float)beamConfig.beam_fade_in_distance.get()).floatValue())) {
            float m = (float)distance - fadeDistance;
            preBeamAlpha *= 1.0f / Math.max(m / fadeDistance, 1.0f);
        }
        float beamRadius = 0.05f * ((Float)beamConfig.beam_radius.get()).floatValue();
        float beamHeight = ((Float)beamConfig.beam_height.get()).floatValue();
        float yOffset = ((Float)beamConfig.beam_y_offset.get()).floatValue();
        if (beamConfig.common_shorter_beam && LBItemEntity2.isCommon()) {
            beamHeight *= 0.65f;
            yOffset -= yOffset;
        }
        int beamAlpha = (int)(preBeamAlpha * 255.0f);
        Option<DynamicProvider> dynamicProvider1 = DynamicProviderModule.getDynamicProvider();
        if (dynamicProvider1.isDefined()) {
            beamAlpha = (int)((float)beamAlpha * Math.min(((DynamicProvider)dynamicProvider1.get()).getBeamLightFactor(), 1.0f));
            beamHeight += ((DynamicProvider)dynamicProvider1.get()).getBeamLightFactor() - 0.3f;
            beamRadius += 0.005f * ((DynamicProvider)dynamicProvider1.get()).getGlowFactor();
        }
        beamAlpha = (int)((float)beamAlpha * fadeInFactor);
        Vector3f playerPos = player.getPosition(partialTick).toVector3f();
        Vector3f targetPos = itemEntity.getPosition(partialTick).toVector3f();
        Vector3f direction = targetPos.sub((Vector3fc)playerPos).normalize();
        double v = Math.atan2(direction.x(), direction.z());
        stack.pushPose();
        stack.mulPose(Axis.YP.rotation((float)v));
        stack.pushPose();
        stack.translate(0.0f, yOffset + 1.0f, 0.0f);
        VertexConsumer buffer1 = buffer.getBuffer(BeamRenderType.LOOT_BEAM_RENDERTYPE);
        buffer1.addVertex(stack.last().pose(), -beamRadius, -beamHeight, 0.01f).setColor(R, G, B, beamAlpha).setUv(0.0f, 0.0f).setLight(0xF000F0).setNormal(stack.last(), 0.0f, 1.0f, 0.0f);
        buffer1.addVertex(stack.last().pose(), -beamRadius, beamHeight, 0.01f).setColor(R, G, B, 0).setUv(0.0f, 1.0f).setLight(0xF000F0).setNormal(stack.last(), 0.0f, 1.0f, 0.0f);
        buffer1.addVertex(stack.last().pose(), beamRadius, beamHeight, 0.01f).setColor(R, G, B, 0).setUv(1.0f, 1.0f).setLight(0xF000F0).setNormal(stack.last(), 0.0f, 1.0f, 0.0f);
        buffer1.addVertex(stack.last().pose(), beamRadius, -beamHeight, 0.01f).setColor(R, G, B, beamAlpha).setUv(1.0f, 0.0f).setLight(0xF000F0).setNormal(stack.last(), 0.0f, 1.0f, 0.0f);
        float glowRadius = beamRadius * 1.35f;
        int glowAlpha = (int)((float)beamAlpha * 0.55f);
        buffer1.addVertex(stack.last().pose(), -glowRadius, -beamHeight, 0.001f).setColor(R, G, B, glowAlpha).setUv(0.0f, 0.0f).setLight(0xF000F0).setNormal(stack.last(), 0.0f, 1.0f, 0.0f);
        buffer1.addVertex(stack.last().pose(), -glowRadius, beamHeight, 0.001f).setColor(R, G, B, 0).setUv(0.0f, 1.0f).setLight(0xF000F0).setNormal(stack.last(), 0.0f, 1.0f, 0.0f);
        buffer1.addVertex(stack.last().pose(), glowRadius, beamHeight, 0.001f).setColor(R, G, B, 0).setUv(1.0f, 1.0f).setLight(0xF000F0).setNormal(stack.last(), 0.0f, 1.0f, 0.0f);
        buffer1.addVertex(stack.last().pose(), glowRadius, -beamHeight, 0.001f).setColor(R, G, B, glowAlpha).setUv(1.0f, 0.0f).setLight(0xF000F0).setNormal(stack.last(), 0.0f, 1.0f, 0.0f);
        stack.popPose();
        stack.popPose();
        if (glowConfig.enable_glow && itemEntity.onGround()) {
            stack.pushPose();
            stack.translate(0.0, 0.01, 0.0);
            float radius = ((Float)glowConfig.glow_effect_radius.get()).floatValue();
            BeamRenderer.renderGlow(stack, buffer.getBuffer(BeamRenderType.GLOW), R, G, B, (int)((float)beamAlpha * 0.4f), radius);
            stack.popPose();
        }
        if (lifeTime < fadeInTime) {
            LBItemEntity2.updateFade();
        }
    }

    private static void renderGlow(PoseStack stack, VertexConsumer builder, int red, int green, int blue, int alpha, float radius) {
        PoseStack.Pose matrixentry = stack.last();
        Matrix4f matrixpose = matrixentry.pose();
        builder.addVertex(matrixpose, -radius, 0.0f, -radius).setColor(red, green, blue, alpha).setUv(0.0f, 0.0f).setOverlay(OverlayTexture.NO_OVERLAY).setLight(0xF000F0).setNormal(matrixentry, 0.0f, 1.0f, 0.0f);
        builder.addVertex(matrixpose, -radius, 0.0f, radius).setColor(red, green, blue, alpha).setUv(0.0f, 1.0f).setOverlay(OverlayTexture.NO_OVERLAY).setLight(0xF000F0).setNormal(matrixentry, 0.0f, 1.0f, 0.0f);
        builder.addVertex(matrixpose, radius, 0.0f, radius).setColor(red, green, blue, alpha).setUv(1.0f, 1.0f).setOverlay(OverlayTexture.NO_OVERLAY).setLight(0xF000F0).setNormal(matrixentry, 0.0f, 1.0f, 0.0f);
        builder.addVertex(matrixpose, radius, 0.0f, -radius).setColor(red, green, blue, alpha).setUv(1.0f, 0.0f).setOverlay(OverlayTexture.NO_OVERLAY).setLight(0xF000F0).setNormal(matrixentry, 0.0f, 1.0f, 0.0f);
    }
}

