/*
 * Decompiled with CFR 0.152.
 */
package com.clefal.nirvana_lib.api;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerChunkCache;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.chunk.LevelChunk;

public interface NetworkHandler {
    default public <T> void sendToServer(T packet) {
        this.sendToServer(packet, false);
    }

    public <T> void sendToServer(T var1, boolean var2);

    default public <T> void sendToClient(T packet, ServerPlayer player) {
        this.sendToClient(packet, player, false);
    }

    public <T> void sendToClient(T var1, ServerPlayer var2, boolean var3);

    default public <T> void sendToClients(T packet, List<ServerPlayer> players) {
        this.sendToClients(packet, players, false);
    }

    default public <T> void sendToClients(T packet, List<ServerPlayer> players, boolean ignoreCheck) {
        for (ServerPlayer player : players) {
            this.sendToClient(packet, player, ignoreCheck);
        }
    }

    default public <T> void sendToAllClients(T packet, MinecraftServer server) {
        this.sendToAllClients(packet, server, false);
    }

    default public <T> void sendToAllClients(T packet, MinecraftServer server, boolean ignoreCheck) {
        this.sendToClients(packet, server.getPlayerList().getPlayers(), ignoreCheck);
    }

    default public <T> void sendToClientsInLevel(T packet, ServerLevel level) {
        this.sendToClientsInLevel(packet, level, false);
    }

    default public <T> void sendToClientsInLevel(T packet, ServerLevel level, boolean ignoreCheck) {
        this.sendToClients(packet, level.players(), ignoreCheck);
    }

    default public <T> void sendToClientsLoadingChunk(T packet, LevelChunk chunk) {
        this.sendToClientsLoadingChunk(packet, chunk, false);
    }

    default public <T> void sendToClientsLoadingChunk(T packet, LevelChunk chunk, boolean ignoreCheck) {
        ServerChunkCache chunkCache = (ServerChunkCache)chunk.getLevel().getChunkSource();
        this.sendToClients(packet, chunkCache.chunkMap.getPlayers(chunk.getPos(), false), ignoreCheck);
    }

    default public <T> void sendToClientsLoadingPos(T packet, ServerLevel level, ChunkPos pos) {
        this.sendToClientsLoadingPos(packet, level, pos, false);
    }

    default public <T> void sendToClientsLoadingPos(T packet, ServerLevel level, ChunkPos pos, boolean ignoreCheck) {
        this.sendToClientsLoadingChunk(packet, level.getChunk(pos.x, pos.z), ignoreCheck);
    }

    default public <T> void sendToClientsLoadingPos(T packet, ServerLevel level, BlockPos pos) {
        this.sendToClientsLoadingPos(packet, level, pos, false);
    }

    default public <T> void sendToClientsLoadingPos(T packet, ServerLevel level, BlockPos pos, boolean ignoreCheck) {
        this.sendToClientsLoadingPos(packet, level, new ChunkPos(pos), ignoreCheck);
    }

    default public <T> void sendToClientsInRange(T packet, ServerLevel level, BlockPos pos, double range) {
        this.sendToClientsInRange(packet, level, pos, range, false);
    }

    default public <T> void sendToClientsInRange(T packet, ServerLevel level, BlockPos pos, double range, boolean ignoreCheck) {
        for (ServerPlayer player : level.players()) {
            if (!(player.distanceToSqr((double)pos.getX(), (double)pos.getY(), (double)pos.getZ()) <= range * range)) continue;
            this.sendToClient(packet, player, ignoreCheck);
        }
    }
}

