/*
 * Decompiled with CFR 0.152.
 */
package com.clefal.nirvana_lib.networking;

import com.clefal.nirvana_lib.networking.PacketRegistrar;
import com.clefal.nirvana_lib.networking.PacketRegistrationHandler;
import com.clefal.nirvana_lib.networking.data.PacketContainer;
import com.clefal.nirvana_lib.networking.data.PacketContext;
import com.clefal.nirvana_lib.networking.data.Side;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;

public class DelayedPacketRegistrationHandler
implements PacketRegistrar {
    private static final Map<Class<?>, PacketContainer<?>> QUEUED_PACKET_MAP = new HashMap();

    @Override
    public Side getSide() {
        return Side.CLIENT;
    }

    @Override
    public <T> PacketRegistrar registerPacket(CustomPacketPayload.Type<? extends CustomPacketPayload> type, Class<T> packetClass, StreamCodec<? extends FriendlyByteBuf, T> codec, Consumer<PacketContext<T>> handler) {
        PacketContainer<T> container = new PacketContainer<T>(type, packetClass, codec, handler);
        QUEUED_PACKET_MAP.put(packetClass, container);
        return this;
    }

    public void registerQueuedPackets(PacketRegistrationHandler packetRegistration) {
        if (!QUEUED_PACKET_MAP.isEmpty()) {
            packetRegistration.PACKET_MAP.putAll(QUEUED_PACKET_MAP);
            QUEUED_PACKET_MAP.forEach((aClass, container) -> packetRegistration.registerPacket(container));
        }
    }
}

