/*
 * Decompiled with CFR 0.152.
 */
package com.clefal.nirvana_lib.utils;

import com.clefal.nirvana_lib.NirvanaLibConstants;
import com.clefal.nirvana_lib.platform.Services;
import lombok.Generated;

public final class DevUtils {
    public static boolean isInDev() {
        return Services.PLATFORM.isDevelopmentEnvironment();
    }

    public static void runWhenOnDev(Runnable runnable) {
        if (DevUtils.isInDev()) {
            runnable.run();
        }
    }

    public static void runWhenNotOnDev(Runnable runnable) {
        if (!DevUtils.isInDev()) {
            runnable.run();
        }
    }

    public static void runOnDifference(Runnable whenOn, Runnable whenOff) {
        if (DevUtils.isInDev()) {
            whenOn.run();
        } else {
            whenOff.run();
        }
    }

    public static void announceDevEnabled() {
        DevUtils.runWhenOnDev(() -> NirvanaLibConstants.LOGGER.info("Dev tool enabled!"));
    }

    @Generated
    private DevUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

