/*
 * Decompiled with CFR 0.152.
 */
package com.clefal.nirvana_lib.networking;

import com.clefal.nirvana_lib.NirvanaLibConstants;
import com.clefal.nirvana_lib.networking.PacketRegistrationHandler;
import com.clefal.nirvana_lib.networking.data.CommonPacketWrapper;
import com.clefal.nirvana_lib.networking.data.PacketContainer;
import com.clefal.nirvana_lib.networking.data.PacketContext;
import com.clefal.nirvana_lib.networking.data.Side;
import com.clefal.nirvana_lib.networking.exceptions.RegistrationException;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.networking.v1.PayloadTypeRegistry;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_2960;
import net.minecraft.class_3222;

public class FabricNetworkHandler
extends PacketRegistrationHandler {
    public FabricNetworkHandler(Side side) {
        super(side);
    }

    @Override
    protected <T> void registerPacket(PacketContainer<T> container) {
        try {
            PayloadTypeRegistry.playC2S().register(container.getType(), container.getCodec());
            PayloadTypeRegistry.playS2C().register(container.getType(), container.getCodec());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        if (Side.CLIENT.equals((Object)this.side)) {
            NirvanaLibConstants.LOGGER.debug("Registering packet {} : {} on the: {}", new Object[]{container.type().comp_2242(), container.classType(), Side.CLIENT});
            ClientPlayNetworking.registerGlobalReceiver(container.getType(), (payload, context) -> context.client().execute(() -> container.handler().accept(new PacketContext(payload.packet(), Side.CLIENT))));
        }
        NirvanaLibConstants.LOGGER.debug("Registering packet {} : {} on the: {}", new Object[]{container.type().comp_2242(), container.classType(), Side.SERVER});
        ServerPlayNetworking.registerGlobalReceiver(container.getType(), (payload, context) -> context.player().field_13995.execute(() -> container.handler().accept(new PacketContext(context.player(), payload.packet(), Side.SERVER))));
    }

    @Override
    public <T> void sendToServer(T packet, boolean ignoreCheck) {
        PacketContainer container = (PacketContainer)this.PACKET_MAP.get(packet.getClass());
        if (container != null) {
            if (ignoreCheck || ClientPlayNetworking.canSend((class_2960)container.type().comp_2242())) {
                ClientPlayNetworking.send(new CommonPacketWrapper<T>(container, packet));
            }
        } else {
            throw new RegistrationException(String.valueOf(packet.getClass()) + "{} packet not registered on the client, packets need to be registered on both sides!");
        }
    }

    @Override
    public <T> void sendToClient(T packet, class_3222 player, boolean ignoreCheck) {
        PacketContainer container = (PacketContainer)this.PACKET_MAP.get(packet.getClass());
        if (container != null) {
            if (ignoreCheck || ServerPlayNetworking.canSend((class_3222)player, (class_2960)container.type().comp_2242())) {
                ServerPlayNetworking.send((class_3222)player, new CommonPacketWrapper<T>(container, packet));
            }
        } else {
            throw new RegistrationException(String.valueOf(packet.getClass()) + "{} packet not registered on the server, packets need to be registered on both sides!");
        }
    }
}

