/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.bus;

import java.lang.reflect.Method;
import net.neoforged.bus.EventListenerFactory;
import net.neoforged.bus.IWrapperListener;
import net.neoforged.bus.api.Event;
import net.neoforged.bus.api.EventListener;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.ICancellableEvent;
import net.neoforged.bus.api.SubscribeEvent;
import org.objectweb.asm.Type;

public final class SubscribeEventListener
extends EventListener
implements IWrapperListener {
    private final EventListener handler;
    private final SubscribeEvent subInfo;
    private String readable;

    public SubscribeEventListener(Object target, Method method) {
        this.handler = EventListenerFactory.create(method, target);
        this.subInfo = method.getAnnotation(SubscribeEvent.class);
        this.readable = "@SubscribeEvent: " + target + " " + method.getName() + Type.getMethodDescriptor((Method)method);
    }

    @Override
    public void invoke(Event event) {
        if (this.handler != null && (this.subInfo.receiveCanceled() || !((ICancellableEvent)((Object)event)).isCanceled())) {
            this.handler.invoke(event);
        }
    }

    public EventPriority getPriority() {
        return this.subInfo.priority();
    }

    public String toString() {
        return this.readable;
    }

    @Override
    public EventListener getWithoutCheck() {
        return this.handler;
    }
}

