/*
 * Decompiled with CFR 0.152.
 */
package com.clefal.lootbeams.config.configs;

import com.clefal.lootbeams.config.services.IServiceCollector;
import com.clefal.lootbeams.utils.ResourceLocationHelper;
import com.google.common.collect.ImmutableList;
import java.util.LinkedHashMap;
import java.util.List;
import me.fzzyhmstrs.fzzy_config.api.ConfigApiJava;
import me.fzzyhmstrs.fzzy_config.api.RegisterType;
import me.fzzyhmstrs.fzzy_config.config.Config;
import me.fzzyhmstrs.fzzy_config.config.ConfigSection;
import me.fzzyhmstrs.fzzy_config.entry.Entry;
import me.fzzyhmstrs.fzzy_config.entry.EntryChecker;
import me.fzzyhmstrs.fzzy_config.util.AllowableStrings;
import me.fzzyhmstrs.fzzy_config.validation.collection.ValidatedIdentifierMap;
import me.fzzyhmstrs.fzzy_config.validation.collection.ValidatedMap;
import me.fzzyhmstrs.fzzy_config.validation.collection.ValidatedSet;
import me.fzzyhmstrs.fzzy_config.validation.minecraft.ValidatedIdentifier;
import me.fzzyhmstrs.fzzy_config.validation.misc.ValidatedColor;
import me.fzzyhmstrs.fzzy_config.validation.misc.ValidatedString;
import me.fzzyhmstrs.fzzy_config.validation.number.ValidatedFloat;
import me.fzzyhmstrs.fzzy_config.validation.number.ValidatedInt;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_7923;

public class LightConfig
extends Config {
    public static LightConfig lightConfig = (LightConfig)ConfigApiJava.registerAndLoadConfig(LightConfig::new, (RegisterType)RegisterType.CLIENT);
    public Beam beam = new Beam();
    public Glow glow = new Glow();
    public CustomColorSetting customColorSetting = new CustomColorSetting();
    public LightEffectFilter lightEffectFilter = new LightEffectFilter();

    public LightConfig() {
        super(ResourceLocationHelper.fromNameAndPath("lootbeams", "light_config"));
    }

    public static void init() {
    }

    public static class Beam
    extends ConfigSection {
        public boolean enable_beam = true;
        public ValidatedInt beam_fade_in_time = new ValidatedInt(10, 100, 1);
        public ValidatedFloat beam_fade_in_distance = new ValidatedFloat(15.0f, 100.0f, 1.0f);
        public ValidatedFloat beam_radius = new ValidatedFloat(0.55f, 5.0f, 0.0f);
        public ValidatedFloat beam_height = new ValidatedFloat(1.5f, 10.0f, 0.0f);
        public ValidatedFloat beam_y_offset = new ValidatedFloat(0.5f, 30.0f, -30.0f);
        public ValidatedFloat beam_alpha = new ValidatedFloat(0.75f, 1.0f, 0.0f);
        public boolean common_shorter_beam = true;
        public boolean solid_beam = true;
        public boolean require_on_ground = true;
    }

    public static class Glow
    extends ConfigSection {
        public boolean enable_glow = true;
        public ValidatedFloat glow_effect_radius = new ValidatedFloat(0.5f, 1.0f, 1.0E-5f);
    }

    public static class CustomColorSetting
    extends ConfigSection {
        public boolean enable_custom_color = false;
        public ValidatedIdentifierMap<ValidatedColor.ColorHolder> color_override_by_name = new ValidatedIdentifierMap(new LinkedHashMap(), ValidatedIdentifier.ofRegistry((class_2960)class_7923.field_41178.method_10137(), (class_2378)class_7923.field_41178), (Entry)new ValidatedColor(255, 255, 255, 255));
        public ValidatedMap<String, ValidatedColor.ColorHolder> color_override_by_tag = new ValidatedMap(new LinkedHashMap(), (Entry)new ValidatedString("#minecraft:air", "#.+:.+"), (Entry)new ValidatedColor(255, 255, 255, 255));
        public ValidatedMap<String, ValidatedColor.ColorHolder> color_override_by_modid = new ValidatedMap(new LinkedHashMap(), (Entry)new ValidatedString("lootbeams", (EntryChecker)new AllowableStrings(x -> !x.isBlank() && !x.contains("#"), IServiceCollector.COLLECTOR::gatherModIDList)), (Entry)new ValidatedColor(255, 255, 255, 255));
    }

    public static class LightEffectFilter
    extends ConfigSection {
        public boolean all_item = false;
        public boolean only_rare = false;
        public boolean only_equipment = true;
        private final List<class_2960> defaultVanillaWhitelist = ImmutableList.of((Object)"minecraft:totem_of_undying", (Object)"minecraft:end_crystal", (Object)"minecraft:nether_star", (Object)"minecraft:wither_skeleton_skull", (Object)"minecraft:diamond").stream().map(ResourceLocationHelper::fromWholeName).toList();
        public ValidatedSet<class_2960> whitelist_by_name = ValidatedIdentifier.ofRegistry((class_2960)class_7923.field_41178.method_10137(), (class_2378)class_7923.field_41178).toSet(this.defaultVanillaWhitelist);
        public ValidatedSet<String> whitelist_by_tag = new ValidatedString("#minecraft:air", "#.+:.+").toSet((Object[])new String[0]);
        public ValidatedSet<String> whitelist_by_modid = new ValidatedString("lootbeams", (EntryChecker)new AllowableStrings(x -> !x.isBlank() && !x.contains("#"), IServiceCollector.COLLECTOR::gatherModIDList)).toSet((Object[])new String[0]);
        public ValidatedSet<class_2960> blacklist_by_name = ValidatedIdentifier.ofRegistry((class_2960)class_7923.field_41178.method_10137(), (class_2378)class_7923.field_41178).toSet((Object[])new class_2960[0]);
        public ValidatedSet<String> blacklist_by_tag = new ValidatedString("#minecraft:air", "#.+:.+").toSet((Object[])new String[0]);
        public ValidatedSet<String> blacklist_by_modid = new ValidatedString("lootbeams", (EntryChecker)new AllowableStrings(x -> !x.isBlank() && !x.contains("#"), IServiceCollector.COLLECTOR::gatherModIDList)).toSet((Object[])new String[0]);
    }
}

