/*
 * Decompiled with CFR 0.152.
 */
package com.clefal.lootbeams.modules.beam;

import com.clefal.lootbeams.config.configs.LightConfig;
import com.clefal.lootbeams.data.lbitementity.LBItemEntity;
import com.clefal.lootbeams.data.lbitementity.rarity.LBColor;
import com.clefal.lootbeams.modules.beam.BeamRenderType;
import com.clefal.lootbeams.modules.dynamicprovider.DynamicProvider;
import com.clefal.lootbeams.modules.dynamicprovider.DynamicProviderModule;
import com.clefal.nirvana_lib.relocated.io.vavr.control.Option;
import net.minecraft.class_1297;
import net.minecraft.class_1542;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_5253;
import net.minecraft.class_746;
import net.minecraft.class_7833;
import org.joml.Matrix4f;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class BeamRenderer {
    public static void renderLootBeam(class_4587 stack, class_4597 buffer, float partialTick, LBItemEntity LBItemEntity2) {
        float fadeDistance;
        class_1542 itemEntity = LBItemEntity2.item();
        LBColor color = LBItemEntity2.rarity().color();
        int lifeTime = LBItemEntity2.fadeIn();
        LightConfig.Beam beamConfig = LightConfig.lightConfig.beam;
        LightConfig.Glow glowConfig = LightConfig.lightConfig.glow;
        int fadeInTime = (Integer)beamConfig.beam_fade_in_time.get();
        float fadeInFactor = 1.0f * (float)lifeTime / (float)fadeInTime;
        int argb = color.argb();
        int R = class_5253.class_5254.method_27765((int)argb);
        int G = class_5253.class_5254.method_27766((int)argb);
        int B = class_5253.class_5254.method_27767((int)argb);
        float preBeamAlpha = ((Float)beamConfig.beam_alpha.get()).floatValue();
        class_746 player = class_310.method_1551().field_1724;
        double distance = player.method_5739((class_1297)itemEntity);
        if (distance > (double)(fadeDistance = ((Float)beamConfig.beam_fade_in_distance.get()).floatValue())) {
            float m = (float)distance - fadeDistance;
            preBeamAlpha *= 1.0f / Math.max(m / fadeDistance, 1.0f);
        }
        float beamRadius = 0.05f * ((Float)beamConfig.beam_radius.get()).floatValue();
        float beamHeight = ((Float)beamConfig.beam_height.get()).floatValue();
        float yOffset = ((Float)beamConfig.beam_y_offset.get()).floatValue();
        if (beamConfig.common_shorter_beam && LBItemEntity2.isCommon()) {
            beamHeight *= 0.65f;
            yOffset -= yOffset;
        }
        int beamAlpha = (int)(preBeamAlpha * 255.0f);
        Option<DynamicProvider> dynamicProvider1 = DynamicProviderModule.getDynamicProvider();
        if (dynamicProvider1.isDefined()) {
            beamAlpha = (int)((float)beamAlpha * Math.min(((DynamicProvider)dynamicProvider1.get()).getBeamLightFactor(), 1.0f));
            beamHeight += ((DynamicProvider)dynamicProvider1.get()).getBeamLightFactor() - 0.3f;
            beamRadius += 0.005f * ((DynamicProvider)dynamicProvider1.get()).getGlowFactor();
        }
        beamAlpha = (int)((float)beamAlpha * fadeInFactor);
        Vector3f playerPos = player.method_30950(partialTick).method_46409();
        Vector3f targetPos = itemEntity.method_30950(partialTick).method_46409();
        Vector3f direction = targetPos.sub((Vector3fc)playerPos).normalize();
        double v = Math.atan2(direction.x(), direction.z());
        stack.method_22903();
        stack.method_22907(class_7833.field_40716.rotation((float)v));
        stack.method_22903();
        stack.method_46416(0.0f, yOffset + 1.0f, 0.0f);
        class_4588 buffer1 = buffer.getBuffer(BeamRenderType.LOOT_BEAM_RENDERTYPE);
        buffer1.method_22918(stack.method_23760().method_23761(), -beamRadius, -beamHeight, 0.01f).method_1336(R, G, B, beamAlpha).method_22913(0.0f, 0.0f).method_60803(0xF000F0).method_60831(stack.method_23760(), 0.0f, 1.0f, 0.0f);
        buffer1.method_22918(stack.method_23760().method_23761(), -beamRadius, beamHeight, 0.01f).method_1336(R, G, B, 0).method_22913(0.0f, 1.0f).method_60803(0xF000F0).method_60831(stack.method_23760(), 0.0f, 1.0f, 0.0f);
        buffer1.method_22918(stack.method_23760().method_23761(), beamRadius, beamHeight, 0.01f).method_1336(R, G, B, 0).method_22913(1.0f, 1.0f).method_60803(0xF000F0).method_60831(stack.method_23760(), 0.0f, 1.0f, 0.0f);
        buffer1.method_22918(stack.method_23760().method_23761(), beamRadius, -beamHeight, 0.01f).method_1336(R, G, B, beamAlpha).method_22913(1.0f, 0.0f).method_60803(0xF000F0).method_60831(stack.method_23760(), 0.0f, 1.0f, 0.0f);
        float glowRadius = beamRadius * 1.35f;
        int glowAlpha = (int)((float)beamAlpha * 0.55f);
        buffer1.method_22918(stack.method_23760().method_23761(), -glowRadius, -beamHeight, 0.001f).method_1336(R, G, B, glowAlpha).method_22913(0.0f, 0.0f).method_60803(0xF000F0).method_60831(stack.method_23760(), 0.0f, 1.0f, 0.0f);
        buffer1.method_22918(stack.method_23760().method_23761(), -glowRadius, beamHeight, 0.001f).method_1336(R, G, B, 0).method_22913(0.0f, 1.0f).method_60803(0xF000F0).method_60831(stack.method_23760(), 0.0f, 1.0f, 0.0f);
        buffer1.method_22918(stack.method_23760().method_23761(), glowRadius, beamHeight, 0.001f).method_1336(R, G, B, 0).method_22913(1.0f, 1.0f).method_60803(0xF000F0).method_60831(stack.method_23760(), 0.0f, 1.0f, 0.0f);
        buffer1.method_22918(stack.method_23760().method_23761(), glowRadius, -beamHeight, 0.001f).method_1336(R, G, B, glowAlpha).method_22913(1.0f, 0.0f).method_60803(0xF000F0).method_60831(stack.method_23760(), 0.0f, 1.0f, 0.0f);
        stack.method_22909();
        stack.method_22909();
        if (glowConfig.enable_glow && itemEntity.method_24828()) {
            stack.method_22903();
            stack.method_22904(0.0, 0.01, 0.0);
            float radius = ((Float)glowConfig.glow_effect_radius.get()).floatValue();
            BeamRenderer.renderGlow(stack, buffer.getBuffer(BeamRenderType.GLOW), R, G, B, (int)((float)beamAlpha * 0.4f), radius);
            stack.method_22909();
        }
        if (lifeTime < fadeInTime) {
            LBItemEntity2.updateFade();
        }
    }

    private static void renderGlow(class_4587 stack, class_4588 builder, int red, int green, int blue, int alpha, float radius) {
        class_4587.class_4665 matrixentry = stack.method_23760();
        Matrix4f matrixpose = matrixentry.method_23761();
        builder.method_22918(matrixpose, -radius, 0.0f, -radius).method_1336(red, green, blue, alpha).method_22913(0.0f, 0.0f).method_22922(class_4608.field_21444).method_60803(0xF000F0).method_60831(matrixentry, 0.0f, 1.0f, 0.0f);
        builder.method_22918(matrixpose, -radius, 0.0f, radius).method_1336(red, green, blue, alpha).method_22913(0.0f, 1.0f).method_22922(class_4608.field_21444).method_60803(0xF000F0).method_60831(matrixentry, 0.0f, 1.0f, 0.0f);
        builder.method_22918(matrixpose, radius, 0.0f, radius).method_1336(red, green, blue, alpha).method_22913(1.0f, 1.0f).method_22922(class_4608.field_21444).method_60803(0xF000F0).method_60831(matrixentry, 0.0f, 1.0f, 0.0f);
        builder.method_22918(matrixpose, radius, 0.0f, -radius).method_1336(red, green, blue, alpha).method_22913(1.0f, 0.0f).method_22922(class_4608.field_21444).method_60803(0xF000F0).method_60831(matrixentry, 0.0f, 1.0f, 0.0f);
    }
}

