/*
 * Decompiled with CFR 0.152.
 */
package com.clefal.nirvana_lib.utils;

import com.clefal.nirvana_lib.NirvanaLibConstants;
import com.clefal.nirvana_lib.network.newtoolchain.ModPacket;
import commonnetwork.api.Dispatcher;
import commonnetwork.api.Network;
import java.util.ArrayList;
import java.util.function.Supplier;
import lombok.Generated;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;

public final class NetworkUtils {
    public static <T> void sendToClient(T msg, ServerPlayer player) {
        Dispatcher.sendToClient(msg, (ServerPlayer)player);
    }

    public static <T> void sendToClients(T msg, Iterable<ServerPlayer> playerList) {
        playerList.forEach(x -> NetworkUtils.sendToClient(msg, x));
    }

    public static <T> void sendToServer(T msg) {
        Dispatcher.sendToServer(msg);
    }

    public static <T> void sendToAllClients(T msg, MinecraftServer level) {
        NetworkUtils.sendToClients(msg, level.m_6846_().m_11314_());
    }

    public static <MSG extends ModPacket<MSG>> void registerPacket(Supplier<MSG> supplier) {
        Class selfClass = ((ModPacket)supplier.get()).getSelfClass();
        Network.registerPacket((ResourceLocation)NetworkUtils.classToResourceLocation(selfClass), selfClass, ModPacket::write, buf -> {
            ModPacket msg = (ModPacket)supplier.get();
            msg.read((FriendlyByteBuf)buf);
            return msg;
        }, x -> ((ModPacket)x.message()).handle(x));
    }

    public static ResourceLocation classToResourceLocation(Class<?> clas) {
        String name = clas.getSimpleName().toLowerCase();
        ArrayList<Character> characters = new ArrayList<Character>();
        for (char c : name.toCharArray()) {
            characters.add(Character.valueOf(c));
        }
        String result = characters.stream().filter(NetworkUtils::validPathChar).collect(StringBuilder::new, StringBuilder::append, StringBuilder::append).toString();
        return NirvanaLibConstants.id(result.toLowerCase());
    }

    public static boolean validPathChar(char pathChar) {
        return pathChar == '_' || pathChar == '-' || pathChar >= 'a' && pathChar <= 'z' || pathChar >= '0' && pathChar <= '9' || pathChar == '/' || pathChar == '.';
    }

    @Generated
    private NetworkUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

