/*
 * Decompiled with CFR 0.152.
 */
package me.clefal.lootbeams.modules.tooltip.nametag;

import com.mojang.blaze3d.vertex.PoseStack;
import java.awt.Color;
import java.util.List;
import java.util.Objects;
import me.clefal.lootbeams.config.configs.LootInfomationConfig;
import me.clefal.lootbeams.data.lbitementity.LBItemEntity;
import me.clefal.lootbeams.data.lbitementity.rarity.LBColor;
import me.clefal.lootbeams.data.new_render.LootBeamRenderState;
import me.clefal.lootbeams.duck.PoseCopy;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import org.joml.Matrix3fc;
import org.joml.Matrix4fc;

public class NameTagRenderer {
    public static void renderNameTag(PoseStack stack, MultiBufferSource buffer, LBItemEntity LBItemEntity2) {
        PoseCopy last = (PoseCopy)stack.m_85850_();
        NameTagRenderer.renderNameTag(buffer, LootBeamRenderState.NameTagRenderState.fromLBEntity(LBItemEntity2, last.copy()));
    }

    public static void renderNameTag(MultiBufferSource buffer, LootBeamRenderState.NameTagRenderState renderState) {
        LootInfomationConfig.nameTagSection nameTagSection2 = LootInfomationConfig.lootInfomationConfig.nameTag;
        PoseStack.Pose pose = renderState.poseStack;
        PoseStack stack = new PoseStack();
        stack.m_85850_().m_252922_().set((Matrix4fc)pose.m_252922_());
        stack.m_85850_().m_252943_().set((Matrix3fc)pose.m_252943_());
        if (Minecraft.m_91087_().f_91074_.m_6047_() || nameTagSection2.render_name_tag_on_look && renderState.isLookingAtThis) {
            LBColor color = renderState.rarity.color();
            float foregroundAlpha = ((Float)nameTagSection2.name_tag_text_alpha.get()).floatValue();
            float backgroundAlpha = ((Float)nameTagSection2.name_tag_background_alpha.get()).floatValue();
            double yOffset = ((Float)nameTagSection2.name_tag_y_offset.get()).floatValue();
            int foregroundColor = color.changeA((int)(foregroundAlpha * 255.0f)).argb();
            int backgroundColor = color.changeA((int)(foregroundAlpha * 255.0f)).argb();
            stack.m_85836_();
            stack.m_85837_(0.0, Math.min(1.0, Minecraft.m_91087_().f_91074_.m_20238_(renderState.location) * 0.025) + yOffset, 0.0);
            stack.m_252781_(Minecraft.m_91087_().m_91290_().m_253208_());
            float nametagScale = ((Float)nameTagSection2.name_tag_scale.get()).floatValue();
            stack.m_85841_(-0.02f * nametagScale, -0.02f * nametagScale, 0.02f * nametagScale);
            List<Component> nameAndRarity = renderState.nameAndRarity;
            Font fontrenderer = Minecraft.m_91087_().f_91062_;
            stack.m_252880_(0.0f, 2.0f, -10.0f);
            for (Component c : nameAndRarity) {
                String s = c.getString();
                if (s.isBlank()) continue;
                NameTagRenderer.renderText(fontrenderer, stack, buffer, s, foregroundColor, backgroundColor, backgroundAlpha);
                Objects.requireNonNull(Minecraft.m_91087_().f_91062_);
                stack.m_252880_(0.0f, 9.0f, 0.0f);
            }
            stack.m_85849_();
        }
    }

    private static void renderText(Font fontRenderer, PoseStack stack, MultiBufferSource buffer, String text, int foregroundColor, int backgroundColor, float backgroundAlpha) {
        if (LootInfomationConfig.lootInfomationConfig.nameTag.add_text_border) {
            float w = (float)(-fontRenderer.m_92895_(text)) / 2.0f;
            int bg = new Color(0, 0, 0, (int)(255.0f * backgroundAlpha)).getRGB();
            MutableComponent comp = Component.m_237113_((String)text);
            fontRenderer.m_168645_(comp.m_7532_(), w, 0.0f, foregroundColor, bg, stack.m_85850_().m_252922_(), buffer, 0xF000F0);
        } else {
            fontRenderer.m_271703_(text, (float)(-fontRenderer.m_92895_(text) / 2), 30.0f, foregroundColor, false, stack.m_85850_().m_252922_(), buffer, Font.DisplayMode.NORMAL, backgroundColor, 0xF000E0);
        }
    }
}

