/*
 * Decompiled with CFR 0.152.
 */
package com.clefal.nirvana_lib.client.render.batch;

import com.clefal.nirvana_lib.client.render.batch.DrawStringBufferInfo;
import com.clefal.nirvana_lib.client.render.batch.IFillBufferInfo;
import com.clefal.nirvana_lib.client.render.batch.ITextureBufferInfo;
import com.clefal.nirvana_lib.client.render.batch.TextureBufferInfo;
import com.google.common.collect.HashMultimap;
import com.mojang.blaze3d.systems.RenderSystem;
import it.unimi.dsi.fastutil.ints.IntIterator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.class_1921;
import net.minecraft.class_2960;
import net.minecraft.class_3532;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_5253;
import net.minecraft.class_7836;
import org.joml.Matrix4f;

public class VertexContainer {
    public HashMultimap<class_2960, ITextureBufferInfo> map = HashMultimap.create((int)10, (int)100);
    public List<IFillBufferInfo> fillBufferInfos = new ArrayList<IFillBufferInfo>();
    public List<DrawStringBufferInfo> strings = new ArrayList<DrawStringBufferInfo>();

    public VertexContainer() {
    }

    public VertexContainer(int expectedKeys, int expectedValuesPerKey) {
        this.map = HashMultimap.create((int)expectedKeys, (int)expectedValuesPerKey);
    }

    public void putBliz(class_2960 resourceLocation, TextureBufferInfo bufferInfo) {
        this.putBliz(resourceLocation, (ITextureBufferInfo)bufferInfo);
    }

    public void putBliz(class_2960 resourceLocation, ITextureBufferInfo bufferInfo) {
        this.map.put((Object)resourceLocation, (Object)bufferInfo);
    }

    public void putBlitNineSliced(class_2960 atlasLocation, int x, int y, int width, int height, int sliceSize, int uOffset, int vOffset, int textureX, int textureY, Matrix4f matrix4f) {
        this.putBlitNineSliced(atlasLocation, x, y, width, height, sliceSize, sliceSize, sliceSize, sliceSize, uOffset, vOffset, textureX, textureY, matrix4f);
    }

    public void putBlitNineSliced(class_2960 atlasLocation, int x, int y, int width, int height, int sliceWidth, int sliceHeight, int uWidth, int vHeight, int textureX, int textureY, Matrix4f matrix4f) {
        this.putBlitNineSliced(atlasLocation, x, y, width, height, sliceWidth, sliceHeight, sliceWidth, sliceHeight, uWidth, vHeight, textureX, textureY, matrix4f);
    }

    public void putBlitNineSliced(class_2960 atlasLocation, int x, int y, int width, int height, int leftSliceWidth, int topSliceHeight, int rightSliceWidth, int bottomSliceHeight, int uWidth, int vHeight, int textureX, int textureY, Matrix4f matrix4f) {
        leftSliceWidth = Math.min(leftSliceWidth, width / 2);
        rightSliceWidth = Math.min(rightSliceWidth, width / 2);
        topSliceHeight = Math.min(topSliceHeight, height / 2);
        bottomSliceHeight = Math.min(bottomSliceHeight, height / 2);
        if (width == uWidth && height == vHeight) {
            this.putBliz(atlasLocation, TextureBufferInfo.of(x, y, textureX, textureY, width, height, matrix4f));
        } else if (height == vHeight) {
            this.putBliz(atlasLocation, TextureBufferInfo.of(x, y, textureX, textureY, leftSliceWidth, height, matrix4f));
            this.putBlizRepeating(atlasLocation, x + leftSliceWidth, y, width - rightSliceWidth - leftSliceWidth, height, textureX + leftSliceWidth, textureY, uWidth - rightSliceWidth - leftSliceWidth, vHeight, matrix4f);
            this.putBliz(atlasLocation, TextureBufferInfo.of(x + width - rightSliceWidth, y, textureX + uWidth - rightSliceWidth, textureY, rightSliceWidth, height, matrix4f));
        } else if (width == uWidth) {
            this.putBliz(atlasLocation, TextureBufferInfo.of(x, y, textureX, textureY, width, topSliceHeight, matrix4f));
            this.putBlizRepeating(atlasLocation, x, y + topSliceHeight, width, height - bottomSliceHeight - topSliceHeight, textureX, textureY + topSliceHeight, uWidth, vHeight - bottomSliceHeight - topSliceHeight, matrix4f);
            this.putBliz(atlasLocation, TextureBufferInfo.of(x, y + height - bottomSliceHeight, textureX, textureY + vHeight - bottomSliceHeight, width, bottomSliceHeight, matrix4f));
        } else {
            this.putBliz(atlasLocation, TextureBufferInfo.of(x, y, textureX, textureY, leftSliceWidth, topSliceHeight, matrix4f));
            this.putBlizRepeating(atlasLocation, x + leftSliceWidth, y, width - rightSliceWidth - leftSliceWidth, topSliceHeight, textureX + leftSliceWidth, textureY, uWidth - rightSliceWidth - leftSliceWidth, topSliceHeight, matrix4f);
            this.putBliz(atlasLocation, TextureBufferInfo.of(x + width - rightSliceWidth, y, textureX + uWidth - rightSliceWidth, textureY, rightSliceWidth, topSliceHeight, matrix4f));
            this.putBliz(atlasLocation, TextureBufferInfo.of(x, y + height - bottomSliceHeight, textureX, textureY + vHeight - bottomSliceHeight, leftSliceWidth, bottomSliceHeight, matrix4f));
            this.putBlizRepeating(atlasLocation, x + leftSliceWidth, y + height - bottomSliceHeight, width - rightSliceWidth - leftSliceWidth, bottomSliceHeight, textureX + leftSliceWidth, textureY + vHeight - bottomSliceHeight, uWidth - rightSliceWidth - leftSliceWidth, bottomSliceHeight, matrix4f);
            this.putBliz(atlasLocation, TextureBufferInfo.of(x + width - rightSliceWidth, y + height - bottomSliceHeight, textureX + uWidth - rightSliceWidth, textureY + vHeight - bottomSliceHeight, rightSliceWidth, bottomSliceHeight, matrix4f));
            this.putBlizRepeating(atlasLocation, x, y + topSliceHeight, leftSliceWidth, height - bottomSliceHeight - topSliceHeight, textureX, textureY + topSliceHeight, leftSliceWidth, vHeight - bottomSliceHeight - topSliceHeight, matrix4f);
            this.putBlizRepeating(atlasLocation, x + leftSliceWidth, y + topSliceHeight, width - rightSliceWidth - leftSliceWidth, height - bottomSliceHeight - topSliceHeight, textureX + leftSliceWidth, textureY + topSliceHeight, uWidth - rightSliceWidth - leftSliceWidth, vHeight - bottomSliceHeight - topSliceHeight, matrix4f);
            this.putBlizRepeating(atlasLocation, x + width - rightSliceWidth, y + topSliceHeight, leftSliceWidth, height - bottomSliceHeight - topSliceHeight, textureX + uWidth - rightSliceWidth, textureY + topSliceHeight, rightSliceWidth, vHeight - bottomSliceHeight - topSliceHeight, matrix4f);
        }
    }

    public void putBlizRepeating(class_2960 atlasLocation, int x, int y, int width, int height, int uOffset, int vOffset, int sourceWidth, int sourceHeight, Matrix4f matrix4f) {
        this.putBlizRepeating(atlasLocation, x, y, width, height, uOffset, vOffset, sourceWidth, sourceHeight, 256, 256, matrix4f);
    }

    public void putBlizRepeating(class_2960 atlasLocation, int x, int y, int width, int height, int uOffset, int vOffset, int sourceWidth, int sourceHeight, int textureWidth, int textureHeight, Matrix4f matrix4f) {
        int i = x;
        IntIterator intiterator = VertexContainer.slices(width, sourceWidth);
        while (intiterator.hasNext()) {
            int j = intiterator.nextInt();
            int k = (sourceWidth - j) / 2;
            int l = y;
            IntIterator intiterator1 = VertexContainer.slices(height, sourceHeight);
            while (intiterator1.hasNext()) {
                int i1 = intiterator1.nextInt();
                int j1 = (sourceHeight - i1) / 2;
                this.putBliz(atlasLocation, TextureBufferInfo.of(i, l, uOffset + k, vOffset + j1, j, i1, textureWidth, textureHeight, matrix4f));
                l += i1;
            }
            i += j;
        }
    }

    private static IntIterator slices(int target, int total) {
        int i = class_3532.method_38788((int)target, (int)total);
        return new class_7836(target, i);
    }

    public void putFill(IFillBufferInfo fillBufferInfo) {
        this.fillBufferInfos.add(fillBufferInfo);
    }

    public void putString(DrawStringBufferInfo s) {
        this.strings.add(s);
    }

    private void refresh() {
        this.map = HashMultimap.create((int)10, (int)100);
        this.fillBufferInfos = new ArrayList<IFillBufferInfo>();
        this.strings.clear();
    }

    public void draw(class_4597 guiGraphics, Function<class_2960, class_1921> renderTypeFunction) {
        RenderSystem.enableDepthTest();
        for (Map.Entry entry : this.map.asMap().entrySet()) {
            class_2960 key = (class_2960)entry.getKey();
            class_1921 statusRenderType = renderTypeFunction.apply(key);
            class_4588 buffer = guiGraphics.getBuffer(statusRenderType);
            for (ITextureBufferInfo bufferInfo : (Collection)entry.getValue()) {
                bufferInfo.upload(buffer);
            }
        }
        class_4588 buffer = guiGraphics.getBuffer(class_1921.method_51784());
        if (!this.fillBufferInfos.isEmpty()) {
            for (IFillBufferInfo fillBufferInfo : this.fillBufferInfos) {
                fillBufferInfo.upload(buffer);
            }
        }
        if (!this.strings.isEmpty()) {
            for (DrawStringBufferInfo string : this.strings) {
                string.upload(guiGraphics);
            }
        }
        class_4588 class_45882 = guiGraphics.getBuffer(class_1921.method_51784());
        int color = class_5253.class_5254.method_27764((int)0, (int)0, (int)0, (int)0);
        class_45882.method_22912(0.0, 0.0, 0.0).method_39415(color).method_1344();
        class_45882.method_22912(0.0, 0.0, 0.0).method_39415(color).method_1344();
        class_45882.method_22912(0.0, 0.0, 0.0).method_39415(color).method_1344();
        class_45882.method_22912(0.0, 0.0, 0.0).method_39415(color).method_1344();
        RenderSystem.disableDepthTest();
        this.refresh();
    }
}

