/*
 * Decompiled with CFR 0.152.
 */
package fr.madu59.fwa;

import com.mojang.blaze3d.vertex.PoseStack;
import fr.madu59.fwa.Animations;
import fr.madu59.fwa.anims.Animation;
import fr.madu59.fwa.anims.BellAnimation;
import fr.madu59.fwa.anims.ButtonAnimation;
import fr.madu59.fwa.anims.CampfireAnimation;
import fr.madu59.fwa.anims.ChiseledBookShelfAnimation;
import fr.madu59.fwa.anims.ComposterAnimation;
import fr.madu59.fwa.anims.DoorAnimation;
import fr.madu59.fwa.anims.EndPortalFrameAnimation;
import fr.madu59.fwa.anims.FenceGateAnimation;
import fr.madu59.fwa.anims.JukeBoxAnimation;
import fr.madu59.fwa.anims.LayeredCauldronAnimation;
import fr.madu59.fwa.anims.LecternAnimation;
import fr.madu59.fwa.anims.LeverAnimation;
import fr.madu59.fwa.anims.RepeaterAnimation;
import fr.madu59.fwa.anims.TrapDoorAnimation;
import fr.madu59.fwa.anims.TripWireHookAnimation;
import fr.madu59.fwa.config.SettingsManager;
import fr.madu59.fwa.config.configscreen.FancyWorldAnimationsConfigScreen;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.block.BellBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.ButtonBlock;
import net.minecraft.world.level.block.CampfireBlock;
import net.minecraft.world.level.block.CauldronBlock;
import net.minecraft.world.level.block.ChiseledBookShelfBlock;
import net.minecraft.world.level.block.ComposterBlock;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.EndPortalFrameBlock;
import net.minecraft.world.level.block.FenceGateBlock;
import net.minecraft.world.level.block.JukeboxBlock;
import net.minecraft.world.level.block.LavaCauldronBlock;
import net.minecraft.world.level.block.LayeredCauldronBlock;
import net.minecraft.world.level.block.LecternBlock;
import net.minecraft.world.level.block.LeverBlock;
import net.minecraft.world.level.block.RepeaterBlock;
import net.minecraft.world.level.block.TrapDoorBlock;
import net.minecraft.world.level.block.TripWireHookBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.IExtensionPoint;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.common.Mod;
import net.neoforged.neoforge.client.event.RenderLevelStageEvent;
import net.neoforged.neoforge.client.gui.IConfigScreenFactory;
import net.neoforged.neoforge.common.NeoForge;

@Mod(value="fwa", dist={Dist.CLIENT})
@EventBusSubscriber(modid="fwa", value={Dist.CLIENT})
public class FancyWorldAnimationsClient {
    private static final Animations animations = new Animations();

    public FancyWorldAnimationsClient(ModContainer container, IEventBus bus) {
        NeoForge.EVENT_BUS.register(FancyWorldAnimationsConfigScreen.class);
        container.registerExtensionPoint(IConfigScreenFactory.class, (IExtensionPoint)((IConfigScreenFactory)(client, parent) -> new FancyWorldAnimationsConfigScreen(parent)));
    }

    @SubscribeEvent
    public static void onRenderLevelStage(RenderLevelStageEvent.AfterEntities event) {
        double tickDelta = FancyWorldAnimationsClient.getPartialTick();
        FancyWorldAnimationsClient.render(event, tickDelta);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void onBlockUpdate(BlockPos blockPos, BlockState oldState, BlockState newState) {
        if (Minecraft.getInstance().level == null) {
            return;
        }
        Type type = FancyWorldAnimationsClient.typeOf(oldState, newState);
        if (type == Type.USELESS) {
            Animations animations = FancyWorldAnimationsClient.animations;
            synchronized (animations) {
                FancyWorldAnimationsClient.animations.removeAt(blockPos);
            }
            return;
        }
        if (!FancyWorldAnimationsClient.isSameType(type, newState)) {
            Animations animations = FancyWorldAnimationsClient.animations;
            synchronized (animations) {
                FancyWorldAnimationsClient.animations.removeAt(blockPos);
            }
            return;
        }
        boolean oldIsOpen = FancyWorldAnimationsClient.isOpen(oldState);
        boolean newIsOpen = FancyWorldAnimationsClient.isOpen(newState);
        double startTick = Minecraft.getInstance().level.getGameTime();
        Animations animations = FancyWorldAnimationsClient.animations;
        synchronized (animations) {
            Animation animation;
            if (FancyWorldAnimationsClient.animations.containsAt(blockPos) && (animation = FancyWorldAnimationsClient.animations.getAt(blockPos)).isUnique()) {
                startTick = (double)Minecraft.getInstance().level.getGameTime() - animation.getAnimDuration() * (1.0 - animation.getProgress(FancyWorldAnimationsClient.getPartialTick()));
                FancyWorldAnimationsClient.animations.removeAt(blockPos);
            }
            if (!FancyWorldAnimationsClient.shouldStartAnimation(oldIsOpen, newIsOpen, type, oldState, newState)) {
                return;
            }
            animation = FancyWorldAnimationsClient.createAnimation(blockPos, type, FancyWorldAnimationsClient.getDefaultState(newState, type), startTick, oldIsOpen, newIsOpen, oldState, newState);
            if (animation.isEnabled()) {
                FancyWorldAnimationsClient.animations.add(blockPos, animation);
            }
        }
    }

    private static double getPartialTick() {
        return (double)Minecraft.getInstance().level.getGameTime() + (double)Math.clamp(Minecraft.getInstance().getDeltaTracker().getGameTimeDeltaPartialTick(true), 0.0f, 1.0f);
    }

    private static void render(RenderLevelStageEvent.AfterEntities context, double nowTick) {
        if (animations.isEmpty() || Minecraft.getInstance().level == null) {
            return;
        }
        Vec3 cameraPos = Minecraft.getInstance().gameRenderer.getMainCamera().position();
        PoseStack poseStack = context.getPoseStack();
        MultiBufferSource.BufferSource bufferSource = Minecraft.getInstance().renderBuffers().bufferSource();
        for (Animation animation : FancyWorldAnimationsClient.animations.animations.values()) {
            FancyWorldAnimationsClient.renderAnimation(animation, nowTick, cameraPos, poseStack, bufferSource);
        }
        bufferSource.endBatch();
        animations.clean(nowTick);
    }

    private static boolean shouldStartAnimation(boolean oldIsOpen, boolean newIsOpen, Type type, BlockState oldState, BlockState newState) {
        if (type == Type.END_PORTAL_FRAME && SettingsManager.END_PORTAL_FRAME_INFINITE.getValue().booleanValue()) {
            return true;
        }
        if (type == Type.CHISELED_BOOKSHELF) {
            return oldState.getBlock() == newState.getBlock();
        }
        if (type == Type.JUKEBOX) {
            return (Boolean)newState.getValue((Property)JukeboxBlock.HAS_RECORD);
        }
        if (type == Type.REPEATER) {
            return oldState.getBlock() == newState.getBlock() && newState.getValue((Property)RepeaterBlock.DELAY) != oldState.getValue((Property)RepeaterBlock.DELAY);
        }
        if (type == Type.LAYERED_CAULDRON) {
            if (oldState.getBlock() == newState.getBlock() && newState.getBlock() instanceof LayeredCauldronBlock && newState.getValue((Property)LayeredCauldronBlock.LEVEL) != oldState.getValue((Property)LayeredCauldronBlock.LEVEL)) {
                return true;
            }
            if (oldState.getBlock() != newState.getBlock() && newState.getBlock() instanceof LayeredCauldronBlock && oldState.getBlock() instanceof CauldronBlock || oldState.getBlock() instanceof LayeredCauldronBlock && newState.getBlock() instanceof CauldronBlock) {
                return true;
            }
            return oldState.getBlock() != newState.getBlock() && (newState.getBlock() instanceof LavaCauldronBlock && oldState.getBlock() instanceof CauldronBlock || oldState.getBlock() instanceof LavaCauldronBlock && newState.getBlock() instanceof CauldronBlock);
        }
        if (type == Type.COMPOSTER) {
            return oldState.getBlock() == newState.getBlock() && newState.getBlock() instanceof ComposterBlock && newState.getValue((Property)ComposterBlock.LEVEL) != oldState.getValue((Property)ComposterBlock.LEVEL);
        }
        return oldIsOpen != newIsOpen;
    }

    private static void renderAnimation(Animation animation, double nowTick, Vec3 cameraPos, PoseStack poseStack, MultiBufferSource.BufferSource bufferSource) {
        BlockPos pos = animation.getPos();
        poseStack.pushPose();
        poseStack.translate((double)pos.getX() - cameraPos.x, (double)pos.getY() - cameraPos.y, (double)pos.getZ() - cameraPos.z);
        animation.render(poseStack, bufferSource, nowTick);
        poseStack.popPose();
    }

    private static boolean isOpen(BlockState state) {
        Block block = state.getBlock();
        if (block instanceof DoorBlock) {
            return (Boolean)state.getValue((Property)DoorBlock.OPEN);
        }
        if (block instanceof TrapDoorBlock) {
            return (Boolean)state.getValue((Property)TrapDoorBlock.OPEN);
        }
        if (block instanceof FenceGateBlock) {
            return (Boolean)state.getValue((Property)FenceGateBlock.OPEN);
        }
        if (block instanceof LeverBlock) {
            return (Boolean)state.getValue((Property)LeverBlock.POWERED);
        }
        if (block instanceof LecternBlock) {
            return (Boolean)state.getValue((Property)LecternBlock.HAS_BOOK);
        }
        if (block instanceof ButtonBlock) {
            return (Boolean)state.getValue((Property)ButtonBlock.POWERED);
        }
        if (block instanceof JukeboxBlock) {
            return (Boolean)state.getValue((Property)JukeboxBlock.HAS_RECORD);
        }
        if (block instanceof EndPortalFrameBlock) {
            return (Boolean)state.getValue((Property)EndPortalFrameBlock.HAS_EYE);
        }
        if (block instanceof BellBlock) {
            return true;
        }
        if (block instanceof CampfireBlock) {
            return (Boolean)state.getValue((Property)CampfireBlock.LIT);
        }
        if (block instanceof TripWireHookBlock) {
            return (Boolean)state.getValue((Property)TripWireHookBlock.ATTACHED);
        }
        return false;
    }

    private static BlockState getDefaultState(BlockState state, Type type) {
        return switch (type.ordinal()) {
            case 0 -> (BlockState)state.setValue((Property)DoorBlock.OPEN, (Comparable)Boolean.valueOf(false));
            case 1 -> (BlockState)state.setValue((Property)TrapDoorBlock.OPEN, (Comparable)Boolean.valueOf(false));
            case 2 -> (BlockState)state.setValue((Property)FenceGateBlock.OPEN, (Comparable)Boolean.valueOf(false));
            case 3 -> (BlockState)state.setValue((Property)LeverBlock.POWERED, (Comparable)Boolean.valueOf(false));
            case 5 -> (BlockState)state.setValue((Property)LecternBlock.HAS_BOOK, (Comparable)Boolean.valueOf(false));
            case 6 -> (BlockState)state.setValue((Property)ButtonBlock.POWERED, (Comparable)Boolean.valueOf(false));
            case 7 -> (BlockState)state.setValue((Property)JukeboxBlock.HAS_RECORD, (Comparable)Boolean.valueOf(false));
            case 8 -> (BlockState)state.setValue((Property)EndPortalFrameBlock.HAS_EYE, (Comparable)Boolean.valueOf(false));
            case 9 -> (BlockState)state.setValue((Property)RepeaterBlock.DELAY, (Comparable)Integer.valueOf(1));
            case 12 -> (BlockState)state.setValue((Property)CampfireBlock.LIT, (Comparable)Boolean.valueOf(false));
            case 14 -> (BlockState)state.setValue((Property)TripWireHookBlock.ATTACHED, (Comparable)Boolean.valueOf(false));
            default -> state;
        };
    }

    private static Animation createAnimation(BlockPos pos, Type type, BlockState defaultState, double startTick, boolean oldIsOpen, boolean newIsOpen, BlockState oldState, BlockState newState) {
        switch (type.ordinal()) {
            case 0: {
                return new DoorAnimation(pos, defaultState, startTick, oldIsOpen, newIsOpen);
            }
            case 1: {
                return new TrapDoorAnimation(pos, defaultState, startTick, oldIsOpen, newIsOpen);
            }
            case 2: {
                return new FenceGateAnimation(pos, defaultState, startTick, oldIsOpen, newIsOpen);
            }
            case 3: {
                return new LeverAnimation(pos, defaultState, startTick, oldIsOpen, newIsOpen);
            }
            case 4: {
                return new ChiseledBookShelfAnimation(pos, newState, startTick, oldIsOpen, newIsOpen, oldState);
            }
            case 5: {
                return new LecternAnimation(pos, defaultState, startTick, oldIsOpen, newIsOpen);
            }
            case 6: {
                return new ButtonAnimation(pos, defaultState, startTick, oldIsOpen, newIsOpen);
            }
            case 7: {
                return new JukeBoxAnimation(pos, defaultState, startTick, oldIsOpen, newIsOpen, newState);
            }
            case 8: {
                return new EndPortalFrameAnimation(pos, defaultState, startTick, oldIsOpen, newIsOpen);
            }
            case 9: {
                return new RepeaterAnimation(pos, defaultState, startTick, oldIsOpen, newIsOpen, newState, oldState);
            }
            case 10: {
                return new LayeredCauldronAnimation(pos, defaultState, startTick, oldIsOpen, newIsOpen, newState, oldState);
            }
            case 11: {
                return new BellAnimation(pos, defaultState, startTick, oldIsOpen, newIsOpen);
            }
            case 12: {
                return new CampfireAnimation(pos, defaultState, startTick, oldIsOpen, newIsOpen, oldState, newState);
            }
            case 13: {
                return new ComposterAnimation(pos, defaultState, startTick, oldIsOpen, newIsOpen, newState, oldState);
            }
            case 14: {
                return new TripWireHookAnimation(pos, defaultState, startTick, oldIsOpen, newIsOpen);
            }
        }
        return new Animation(pos, defaultState, startTick, oldIsOpen, newIsOpen);
    }

    private static Type typeOf(BlockState state) {
        Block block = state.getBlock();
        if (block instanceof DoorBlock) {
            return Type.DOOR;
        }
        if (block instanceof TrapDoorBlock) {
            return Type.TRAPDOOR;
        }
        if (block instanceof FenceGateBlock) {
            return Type.FENCE_GATE;
        }
        if (block instanceof LeverBlock) {
            return Type.LEVER;
        }
        if (block instanceof ChiseledBookShelfBlock) {
            return Type.CHISELED_BOOKSHELF;
        }
        if (block instanceof LecternBlock) {
            return Type.LECTERN;
        }
        if (block instanceof ButtonBlock) {
            return Type.BUTTON;
        }
        if (block instanceof JukeboxBlock) {
            return Type.JUKEBOX;
        }
        if (block instanceof EndPortalFrameBlock) {
            return Type.END_PORTAL_FRAME;
        }
        if (block instanceof RepeaterBlock) {
            return Type.REPEATER;
        }
        if (block instanceof LayeredCauldronBlock || block instanceof CauldronBlock || block instanceof LavaCauldronBlock) {
            return Type.LAYERED_CAULDRON;
        }
        if (block instanceof BellBlock) {
            return Type.BELL;
        }
        if (block instanceof CampfireBlock) {
            return Type.CAMPFIRE;
        }
        if (block instanceof ComposterBlock) {
            return Type.COMPOSTER;
        }
        return Type.USELESS;
    }

    private static Type typeOf(BlockState oldState, BlockState newState) {
        Type type = FancyWorldAnimationsClient.typeOf(oldState);
        if (type != Type.USELESS) {
            return type;
        }
        return FancyWorldAnimationsClient.typeOf(newState);
    }

    private static boolean isSameType(Type type, BlockState state) {
        return type == FancyWorldAnimationsClient.typeOf(state);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean shouldCancelBlockEntityRendering(BlockPos pos) {
        Animations animations = FancyWorldAnimationsClient.animations;
        synchronized (animations) {
            if (FancyWorldAnimationsClient.animations.containsAt(pos)) {
                Animation animation = FancyWorldAnimationsClient.animations.getAt(pos);
                return animation.hideOriginalBlockEntity();
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean shouldCancelBlockRendering(BlockPos pos) {
        Animations animations = FancyWorldAnimationsClient.animations;
        synchronized (animations) {
            if (FancyWorldAnimationsClient.animations.containsAt(pos)) {
                Animation animation = FancyWorldAnimationsClient.animations.getAt(pos);
                return animation.hideOriginalBlock();
            }
            return false;
        }
    }

    public static enum Type {
        DOOR,
        TRAPDOOR,
        FENCE_GATE,
        LEVER,
        CHISELED_BOOKSHELF,
        LECTERN,
        BUTTON,
        JUKEBOX,
        END_PORTAL_FRAME,
        REPEATER,
        LAYERED_CAULDRON,
        BELL,
        CAMPFIRE,
        COMPOSTER,
        TRIPWIRE_HOOK,
        USELESS;

    }
}

