/*
 * Decompiled with CFR 0.152.
 */
package fr.madu59.fwa.anims;

import com.mojang.blaze3d.vertex.PoseStack;
import fr.madu59.fwa.utils.Curves;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.state.BlockState;

public class Animation {
    protected final BlockPos position;
    protected final double startTick;
    protected final boolean oldIsOpen;
    protected final boolean newIsOpen;
    protected final BlockState defaultState;

    public Animation(BlockPos position, BlockState defaultState, double startTick, boolean oldIsOpen, boolean newIsOpen) {
        this.position = position;
        this.defaultState = defaultState;
        this.startTick = startTick;
        this.oldIsOpen = oldIsOpen;
        this.newIsOpen = newIsOpen;
    }

    public boolean isUnique() {
        return true;
    }

    public <T extends Enum<T>> T getCurve() {
        return (T)((Object)Curves.Classic.LINEAR);
    }

    public boolean isEnabled() {
        return true;
    }

    public static boolean hasInfiniteAnimation() {
        return false;
    }

    public boolean hideOriginalBlock() {
        return true;
    }

    public boolean hideOriginalBlockEntity() {
        return true;
    }

    public BlockPos getPos() {
        return this.position;
    }

    public double getStartTick() {
        return this.startTick;
    }

    public boolean isFinished(double nowTick) {
        return nowTick - this.startTick >= this.getLifeSpan();
    }

    public double getAnimDuration() {
        return 0.0;
    }

    public double getLifeSpan() {
        return this.getAnimDuration();
    }

    public double getProgress(double nowTick) {
        return Math.clamp((nowTick - this.startTick) / this.getAnimDuration(), 0.0, 1.0);
    }

    public void render(PoseStack poseStack, MultiBufferSource.BufferSource bufferSource, double nowTick) {
        int light = LevelRenderer.getLightColor((BlockAndTintGetter)Minecraft.getInstance().level, (BlockPos)this.position);
        Minecraft.getInstance().getBlockRenderer().renderSingleBlock(this.defaultState, poseStack, (MultiBufferSource)bufferSource, light, OverlayTexture.NO_OVERLAY);
    }
}

