/*
 * Decompiled with CFR 0.152.
 */
package fr.madu59.fwa.anims;

import com.mojang.blaze3d.vertex.PoseStack;
import fr.madu59.fwa.anims.Animation;
import fr.madu59.fwa.config.SettingsManager;
import fr.madu59.fwa.utils.FwaModel;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.object.bell.BellModel;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.SubmitNodeStorage;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.Identifier;
import net.minecraft.util.Mth;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.BellBlock;
import net.minecraft.world.level.block.entity.BellBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BellAttachType;
import net.minecraft.world.level.block.state.properties.Property;

public class BellAnimation
extends Animation {
    private final BellModel bellModel;
    private final float hash;
    private BellBlockEntity bellBlockEntity;

    public BellAnimation(BlockPos position, BlockState defaultState, double startTick, boolean oldIsOpen, boolean newIsOpen) {
        super(position, defaultState, startTick, oldIsOpen, newIsOpen);
        this.bellBlockEntity = (BellBlockEntity)Minecraft.getInstance().level.getBlockEntity(this.position);
        this.bellModel = new BellModel(Minecraft.getInstance().getEntityModels().bakeLayer(ModelLayers.BELL));
        this.hash = position.hashCode();
    }

    @Override
    public double getAnimDuration() {
        return 50.0 * SettingsManager.BELL_SPEED.getValue();
    }

    @Override
    public boolean isEnabled() {
        return SettingsManager.BELL_STATE.getValue();
    }

    @Override
    public boolean hideOriginalBlock() {
        return false;
    }

    public static boolean hasInfiniteAnimation() {
        return SettingsManager.BELL_INFINITE.getValue();
    }

    @Override
    public double getLifeSpan() {
        return !BellAnimation.hasInfiniteAnimation() ? this.getAnimDuration() : Double.MAX_VALUE;
    }

    private float animateIdle(float time) {
        float uniqueOffset = this.hash % 100.0f;
        float slowWave = (float)Math.sin((time += uniqueOffset) * 0.1f) * 0.05f;
        float fastWave = (float)Math.sin(time * 0.25f) * 0.02f;
        return (slowWave + fastWave) / 2.0f * Math.clamp(time - (float)this.getAnimDuration(), 0.0f, 5.0f) / 5.0f;
    }

    private float animatePlacement(double nowTick) {
        double progress = this.getProgress(nowTick);
        return Mth.sin((double)(progress * this.getAnimDuration() / 3.1415927)) / (float)(4.0 + progress * this.getAnimDuration() / 3.0);
    }

    private ModelPart rotateBell(ModelPart bellBody, float rot, Direction facing, BellAttachType attachment) {
        float f = 0.0f;
        float g = 0.0f;
        switch (facing) {
            case NORTH: {
                f = -rot;
                break;
            }
            case SOUTH: {
                f = rot;
                break;
            }
            case WEST: {
                g = -rot;
                break;
            }
            case EAST: {
                g = rot;
                break;
            }
        }
        if (attachment == BellAttachType.SINGLE_WALL) {
            bellBody.xRot = g;
            bellBody.zRot = f;
        } else {
            bellBody.xRot = f;
            bellBody.zRot = g;
        }
        return bellBody;
    }

    @Override
    public void render(PoseStack poseStack, MultiBufferSource.BufferSource bufferSource, double nowTick) {
        if (this.bellBlockEntity == null) {
            this.bellBlockEntity = (BellBlockEntity)Minecraft.getInstance().level.getBlockEntity(this.position);
            return;
        }
        TextureAtlasSprite sprite = Minecraft.getInstance().getAtlasManager().getAtlasOrThrow(Identifier.tryParse((String)"minecraft:blocks")).getSprite(Identifier.tryParse((String)"minecraft:entity/bell/bell_body"));
        Direction facing = (Direction)this.defaultState.getValue((Property)BellBlock.FACING);
        BellAttachType attachment = (BellAttachType)this.defaultState.getValue((Property)BellBlock.ATTACHMENT);
        int light = LevelRenderer.getLightColor((BlockAndTintGetter)Minecraft.getInstance().level, (BlockPos)this.position);
        float ticks = (float)this.bellBlockEntity.ticks + Math.clamp(Minecraft.getInstance().getDeltaTracker().getGameTimeDeltaPartialTick(true), 0.0f, 1.0f);
        Direction shakeDirection = this.bellBlockEntity.shaking ? this.bellBlockEntity.clickDirection : null;
        this.bellModel.setupAnim(new BellModel.State(ticks, shakeDirection));
        ModelPart bellBody = ((FwaModel)this.bellModel).getChildPart("bell_body");
        if (this.bellBlockEntity.ticks == 0) {
            float time = (float)(nowTick - this.startTick);
            float rot = (double)time <= this.getAnimDuration() ? this.animatePlacement(nowTick) : this.animateIdle(time);
            bellBody = this.rotateBell(bellBody, rot, facing, attachment);
        }
        SubmitNodeStorage submitNodeCollector = Minecraft.getInstance().gameRenderer.getSubmitNodeStorage();
        submitNodeCollector.submitModelPart(bellBody, poseStack, ItemBlockRenderTypes.getRenderType((BlockState)this.defaultState), light, OverlayTexture.NO_OVERLAY, sprite);
    }
}

