/*
 * Decompiled with CFR 0.152.
 */
package fr.madu59.fwa.anims;

import com.mojang.blaze3d.vertex.PoseStack;
import fr.madu59.fwa.anims.Animation;
import fr.madu59.fwa.config.SettingsManager;
import fr.madu59.fwa.utils.Curves;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.ButtonBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.AttachFace;
import net.minecraft.world.level.block.state.properties.Property;

public class ButtonAnimation
extends Animation {
    public ButtonAnimation(BlockPos position, BlockState defaultState, double startTick, boolean oldIsOpen, boolean newIsOpen) {
        super(position, defaultState, startTick, oldIsOpen, newIsOpen);
    }

    @Override
    public double getAnimDuration() {
        return 3.0 * SettingsManager.BUTTON_SPEED.getValue();
    }

    @Override
    public <T extends Enum<T>> T getCurve() {
        return (T)((Object)SettingsManager.BUTTON_EASING.getValue());
    }

    @Override
    public boolean isEnabled() {
        return SettingsManager.BUTTON_STATE.getValue();
    }

    @Override
    public void render(PoseStack poseStack, MultiBufferSource.BufferSource bufferSource, double nowTick) {
        Direction facing = (Direction)this.defaultState.getValue((Property)ButtonBlock.FACING);
        AttachFace face = (AttachFace)this.defaultState.getValue((Property)ButtonBlock.FACE);
        float x = 0.0f;
        float y = (float)Curves.ease(this.getProgress(nowTick), this.getCurve()) / 16.0f;
        y = this.newIsOpen ? -y : -0.0625f + y;
        float z = 0.0f;
        if (face == AttachFace.CEILING) {
            y = -y;
        } else if (face == AttachFace.WALL) {
            if (facing.getAxis() == Direction.Axis.X) {
                if (facing == Direction.WEST) {
                    y = -y;
                }
                x = y;
                y = 0.0f;
            }
            if (facing.getAxis() == Direction.Axis.Z) {
                if (facing == Direction.NORTH) {
                    y = -y;
                }
                z = y;
                y = 0.0f;
            }
        }
        poseStack.translate(x, y, z);
        int light = LevelRenderer.getLightColor((BlockAndTintGetter)Minecraft.getInstance().level, (BlockPos)this.position);
        Minecraft.getInstance().getBlockRenderer().renderSingleBlock(this.defaultState, poseStack, (MultiBufferSource)bufferSource, light, OverlayTexture.NO_OVERLAY);
    }
}

