/*
 * Decompiled with CFR 0.152.
 */
package fr.madu59.fwa.anims;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import fr.madu59.fwa.anims.Animation;
import fr.madu59.fwa.config.SettingsManager;
import fr.madu59.fwa.utils.Curves;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.BlockModelPart;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.state.BlockState;

public class CampfireAnimation
extends Animation {
    private final BlockState oldState;
    private final BlockState newState;
    private final RandomSource random = RandomSource.create((long)42L);

    public CampfireAnimation(BlockPos position, BlockState defaultState, double startTick, boolean oldIsOpen, boolean newIsOpen, BlockState oldBlockState, BlockState newBlockState) {
        super(position, defaultState, startTick, oldIsOpen, newIsOpen);
        this.newState = newBlockState;
        this.oldState = oldBlockState;
    }

    @Override
    public double getAnimDuration() {
        return 15.0 * SettingsManager.CAMPFIRE_SPEED.getValue();
    }

    @Override
    public boolean isEnabled() {
        return SettingsManager.CAMPFIRE_STATE.getValue();
    }

    @Override
    public boolean hideOriginalBlockEntity() {
        return false;
    }

    @Override
    public <T extends Enum<T>> T getCurve() {
        return (T)((Object)Curves.Door.DEFAULT);
    }

    @Override
    public void render(PoseStack poseStack, MultiBufferSource.BufferSource bufferSource, double nowTick) {
        BlockState state = this.oldIsOpen ? this.oldState : this.newState;
        BlockModelPart part = (BlockModelPart)Minecraft.getInstance().getBlockRenderer().getBlockModel(state).collectParts(this.random).get(0);
        int light = LevelRenderer.getLightColor((BlockAndTintGetter)Minecraft.getInstance().level, (BlockPos)this.position);
        VertexConsumer buffer = bufferSource.getBuffer(ItemBlockRenderTypes.getRenderType((BlockState)state));
        this.renderFilteredQuads(poseStack, buffer, part.getQuads(null), false, light);
        for (Direction dir : Direction.values()) {
            this.renderFilteredQuads(poseStack, buffer, part.getQuads(dir), false, light);
        }
        float scaleY = this.newIsOpen ? (float)(1.0 + 2.70158 * Math.pow(this.getProgress(nowTick) - 1.0, 3.0) + 1.70158 * Math.pow(this.getProgress(nowTick) - 1.0, 2.0)) : 1.0f - (float)Curves.ease(this.getProgress(nowTick), Curves.Door.DEFAULT);
        float scaleXZ = Math.min(1.0f, scaleY);
        poseStack.translate(0.5f, 0.0625f, 0.5f);
        poseStack.scale(scaleXZ, scaleY, scaleXZ);
        poseStack.translate(-0.5f, -0.0625f, -0.5f);
        this.renderFilteredQuads(poseStack, buffer, part.getQuads(null), true, light);
        for (Direction dir : Direction.values()) {
            this.renderFilteredQuads(poseStack, buffer, part.getQuads(dir), true, light);
        }
    }

    private void renderFilteredQuads(PoseStack poseStack, VertexConsumer buffer, List<BakedQuad> quads, boolean wantFire, int light) {
        for (BakedQuad quad : quads) {
            String path = quad.sprite().contents().name().getPath();
            if (path.contains("fire_fire") != wantFire) continue;
            buffer.putBulkData(poseStack.last(), quad, 1.0f, 1.0f, 1.0f, 1.0f, light, OverlayTexture.NO_OVERLAY);
        }
    }
}

