/*
 * Decompiled with CFR 0.152.
 */
package fr.madu59.fwa.anims;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import fr.madu59.fwa.anims.Animation;
import fr.madu59.fwa.config.SettingsManager;
import fr.madu59.fwa.utils.Curves;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.Identifier;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.ChiseledBookShelfBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import org.joml.Matrix4fc;
import org.joml.Quaternionfc;

public class ChiseledBookShelfAnimation
extends Animation {
    int pos = 0;
    boolean isAdding;

    public ChiseledBookShelfAnimation(BlockPos position, BlockState defaultState, double startTick, boolean oldIsOpen, boolean newIsOpen, BlockState oldBlockState) {
        super(position, defaultState, startTick, oldIsOpen, newIsOpen);
        for (BooleanProperty prop : ChiseledBookShelfBlock.SLOT_OCCUPIED_PROPERTIES) {
            ++this.pos;
            if (defaultState.getValue((Property)prop) == oldBlockState.getValue((Property)prop)) continue;
            this.isAdding = (Boolean)defaultState.getValue((Property)prop);
            break;
        }
    }

    @Override
    public double getAnimDuration() {
        return 5.0 * SettingsManager.CHISELED_BOOKSHELF_SPEED.getValue();
    }

    @Override
    public <T extends Enum<T>> T getCurve() {
        return (T)((Object)SettingsManager.CHISELED_BOOKSHELF_EASING.getValue());
    }

    @Override
    public boolean isEnabled() {
        return SettingsManager.CHISELED_BOOKSHELF_STATE.getValue();
    }

    @Override
    public boolean isUnique() {
        return false;
    }

    @Override
    public boolean hideOriginalBlock() {
        return false;
    }

    private float getDistance(double nowTick) {
        float max = 0.1875f;
        float min = 0.0625f;
        float progress = (float)Curves.ease(this.getProgress(nowTick), this.getCurve());
        return this.isAdding ? min + (max - min) * progress : max - (max - min) * progress;
    }

    @Override
    public void render(PoseStack poseStack, MultiBufferSource.BufferSource bufferSource, double nowTick) {
        TextureAtlasSprite sprite = Minecraft.getInstance().getAtlasManager().getAtlasOrThrow(Identifier.tryParse((String)"minecraft:blocks")).getSprite(Identifier.tryParse((String)"minecraft:block/chiseled_bookshelf_occupied"));
        Direction facing = (Direction)this.defaultState.getValue((Property)ChiseledBookShelfBlock.FACING);
        PoseStack.Pose entry = poseStack.last();
        float w = 0.25f;
        float h = this.pos == 1 || this.pos == 5 ? 0.3125f : 0.375f;
        float d = 0.33333334f;
        float y = this.pos > 3 ? 0.25f : 0.75f;
        float x = 0.1875f + (float)((this.pos - 1) % 3) * 5.0f / 16.0f;
        float z = this.getDistance(nowTick);
        if (facing == Direction.EAST) {
            x = 1.0f - x;
            z = 1.0f - z;
        }
        if (facing == Direction.SOUTH || facing == Direction.NORTH) {
            float temp = z;
            z = x;
            x = temp;
            if (facing == Direction.NORTH) {
                z = 1.0f - z;
            }
            if (facing == Direction.SOUTH) {
                x = 1.0f - x;
            }
        }
        poseStack.translate(z, y, x);
        poseStack.mulPose((Quaternionfc)Axis.YP.rotationDegrees(-facing.toYRot()));
        poseStack.translate(-w / 2.0f, -0.1875f, -d / 2.0f);
        float u1 = 0.0625f + (float)((this.pos - 1) % 3) * 5.0f / 16.0f;
        float u2 = u1 + w;
        float v1 = 1.0f - (y - 0.1875f + h);
        float v2 = v1 + h;
        int light = LevelRenderer.getLightColor((BlockAndTintGetter)Minecraft.getInstance().level, (BlockPos)this.position.relative(facing));
        VertexConsumer buffer = bufferSource.getBuffer(ItemBlockRenderTypes.getRenderType((BlockState)this.defaultState));
        this.writeQuad(entry, buffer, 0.0f, 0.0f, d, 0.0f, h, d, w, h, d, w, 0.0f, d, u1, v1, u2, v2, light, 0.0f, 0.0f, -1.0f, sprite);
        this.writeQuad(entry, buffer, w, 0.0f, 0.0f, w, h, 0.0f, 0.0f, h, 0.0f, 0.0f, 0.0f, 0.0f, u1, v1, u2, v2, light, 0.0f, 0.0f, 1.0f, sprite);
        this.writeQuad(entry, buffer, 0.0f, h, d, 0.0f, h, 0.0f, w, h, 0.0f, w, h, d, u1, v1, u2, v2, light, 0.0f, -1.0f, 0.0f, sprite);
        this.writeQuad(entry, buffer, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, d, w, 0.0f, d, w, 0.0f, 0.0f, u1, v1, u2, v2, light, 0.0f, 1.0f, 0.0f, sprite);
        this.writeQuad(entry, buffer, w, 0.0f, d, w, h, d, w, h, 0.0f, w, 0.0f, 0.0f, u1, v1, u2, v2, light, -1.0f, 0.0f, 0.0f, sprite);
        this.writeQuad(entry, buffer, 0.0f, 0.0f, 0.0f, 0.0f, h, 0.0f, 0.0f, h, d, 0.0f, 0.0f, d, u1, v1, u2, v2, light, 1.0f, 0.0f, 0.0f, sprite);
        poseStack.translate(0.0f, 0.0f, 0.0f);
    }

    private void writeQuad(PoseStack.Pose pose, VertexConsumer buffer, float x1, float y1, float z1, float x2, float y2, float z2, float x3, float y3, float z3, float x4, float y4, float z4, float uMin, float vMin, float uMax, float vMax, int light, float nx, float ny, float nz, TextureAtlasSprite sprite) {
        uMin = sprite.getU(uMin);
        uMax = sprite.getU(uMax);
        vMin = sprite.getV(vMin);
        vMax = sprite.getV(vMax);
        this.vertex(pose, buffer, x1, y1, z1, uMin, vMax, light, nx, ny, nz);
        this.vertex(pose, buffer, x4, y4, z4, uMax, vMax, light, nx, ny, nz);
        this.vertex(pose, buffer, x3, y3, z3, uMax, vMin, light, nx, ny, nz);
        this.vertex(pose, buffer, x2, y2, z2, uMin, vMin, light, nx, ny, nz);
    }

    private void vertex(PoseStack.Pose pose, VertexConsumer buffer, float x, float y, float z, float u, float v, int light, float nx, float ny, float nz) {
        buffer.addVertex((Matrix4fc)pose.pose(), x, y, z).setColor(255, 255, 255, 255).setUv(u, v).setOverlay(OverlayTexture.NO_OVERLAY).setLight(light).setNormal(nx, ny, nz);
    }
}

