/*
 * Decompiled with CFR 0.152.
 */
package fr.madu59.fwa.anims;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import fr.madu59.fwa.anims.Animation;
import fr.madu59.fwa.config.SettingsManager;
import fr.madu59.fwa.utils.Curves;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.BlockModelPart;
import net.minecraft.client.renderer.block.model.BlockStateModel;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.ComposterBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class ComposterAnimation
extends Animation {
    private final BlockState oldState;
    private final BlockState newState;
    private final RandomSource random = RandomSource.create((long)42L);
    private final BlockStateModel model;

    public ComposterAnimation(BlockPos position, BlockState defaultState, double startTick, boolean oldIsOpen, boolean newIsOpen, BlockState newBlockState, BlockState oldBlockState) {
        super(position, defaultState, startTick, oldIsOpen, newIsOpen);
        this.newState = newBlockState;
        this.oldState = oldBlockState;
        this.model = Minecraft.getInstance().getBlockRenderer().getBlockModel(this.newState);
    }

    @Override
    public double getAnimDuration() {
        return 10.0 * SettingsManager.COMPOSTER_SPEED.getValue();
    }

    @Override
    public <T extends Enum<T>> T getCurve() {
        return (T)((Object)SettingsManager.COMPOSTER_EASING.getValue());
    }

    @Override
    public boolean isEnabled() {
        return SettingsManager.COMPOSTER_STATE.getValue();
    }

    private float getPosition(double nowTick, double newPos, double oldPos) {
        return (float)(oldPos - newPos - (oldPos - newPos) * Curves.ease(this.getProgress(nowTick), this.getCurve()));
    }

    private double getHeight(BlockState state) {
        return Math.min(((double)((Integer)state.getValue((Property)ComposterBlock.LEVEL)).intValue() * 2.0 + 1.0) / 16.0, 0.9375);
    }

    @Override
    public void render(PoseStack poseStack, MultiBufferSource.BufferSource bufferSource, double nowTick) {
        int light = LevelRenderer.getLightColor((BlockAndTintGetter)Minecraft.getInstance().level, (BlockPos)this.position);
        VertexConsumer buffer = bufferSource.getBuffer(ItemBlockRenderTypes.getRenderType((BlockState)this.newState));
        List partList = this.model.collectParts(this.random);
        for (BlockModelPart part : partList) {
            this.renderFilteredQuads(poseStack, buffer, part.getQuads(null), false, light);
            for (Direction dir : Direction.values()) {
                this.renderFilteredQuads(poseStack, buffer, part.getQuads(dir), false, light);
            }
            float dy = this.getPosition(nowTick, this.getHeight(this.newState), this.getHeight(this.oldState));
            poseStack.translate(0.0f, dy, 0.0f);
            this.renderFilteredQuads(poseStack, buffer, part.getQuads(null), true, light);
            for (Direction dir : Direction.values()) {
                this.renderFilteredQuads(poseStack, buffer, part.getQuads(dir), true, light);
            }
        }
    }

    private void renderFilteredQuads(PoseStack poseStack, VertexConsumer buffer, List<BakedQuad> quads, boolean wantCompost, int light) {
        for (BakedQuad quad : quads) {
            String path = quad.sprite().contents().name().getPath();
            if ((path.contains("_compost") || path.contains("_ready")) != wantCompost) continue;
            buffer.putBulkData(poseStack.last(), quad, 1.0f, 1.0f, 1.0f, 1.0f, light, OverlayTexture.NO_OVERLAY);
        }
    }
}

