/*
 * Decompiled with CFR 0.152.
 */
package fr.madu59.fwa.anims;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import fr.madu59.fwa.anims.Animation;
import fr.madu59.fwa.config.SettingsManager;
import fr.madu59.fwa.utils.Curves;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.DoorHingeSide;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import org.joml.Quaternionfc;

public class DoorAnimation
extends Animation {
    public DoorAnimation(BlockPos position, BlockState defaultState, double startTick, boolean oldIsOpen, boolean newIsOpen) {
        super(position, defaultState, startTick, oldIsOpen, newIsOpen);
    }

    @Override
    public double getAnimDuration() {
        return 10.0 * SettingsManager.DOOR_SPEED.getValue();
    }

    @Override
    public <T extends Enum<T>> T getCurve() {
        return (T)((Object)SettingsManager.DOOR_EASING.getValue());
    }

    @Override
    public boolean isEnabled() {
        return SettingsManager.DOOR_STATE.getValue();
    }

    private double getStartAngle(boolean isOpen, DoorHingeSide hinge) {
        if (!isOpen) {
            return 0.0;
        }
        return hinge == DoorHingeSide.RIGHT ? -90.0 : 90.0;
    }

    private double getAngle(double nowTick, DoorHingeSide hinge) {
        double angle1 = this.getStartAngle(this.oldIsOpen, hinge);
        double angle2 = this.getStartAngle(this.newIsOpen, hinge);
        return angle1 + (angle2 - angle1) * Curves.ease(this.getProgress(nowTick), this.getCurve());
    }

    @Override
    public void render(PoseStack poseStack, MultiBufferSource.BufferSource bufferSource, double nowTick) {
        Direction facing = (Direction)this.defaultState.getValue((Property)DoorBlock.FACING);
        DoorHingeSide hinge = (DoorHingeSide)this.defaultState.getValue((Property)DoorBlock.HINGE);
        Direction hingeSide = hinge == DoorHingeSide.RIGHT ? facing.getClockWise(Direction.Axis.Y) : facing.getCounterClockWise(Direction.Axis.Y);
        AABB boundingBox = this.defaultState.getShape((BlockGetter)Minecraft.getInstance().level, BlockPos.ZERO).bounds();
        float pivotX = (float)((boundingBox.minX + boundingBox.maxX) * 0.5);
        float pivotZ = (float)((boundingBox.minZ + boundingBox.maxZ) * 0.5);
        switch (hingeSide) {
            case EAST: {
                pivotX = (float)boundingBox.maxX;
                break;
            }
            case WEST: {
                pivotX = (float)boundingBox.minX;
                break;
            }
            case SOUTH: {
                pivotZ = (float)boundingBox.maxZ;
                break;
            }
            case NORTH: {
                pivotZ = (float)boundingBox.minZ;
                break;
            }
        }
        float thickness = facing == Direction.NORTH || facing == Direction.SOUTH ? (float)(boundingBox.maxZ - boundingBox.minZ) : (float)(boundingBox.maxX - boundingBox.minX);
        float dX = 0.0f;
        float dZ = 0.0f;
        switch (facing) {
            case NORTH: {
                dZ = thickness * 0.5f;
                break;
            }
            case SOUTH: {
                dZ = -thickness * 0.5f;
                break;
            }
            case WEST: {
                dX = thickness * 0.5f;
                break;
            }
            case EAST: {
                dX = -thickness * 0.5f;
                break;
            }
        }
        double angle = this.getAngle(nowTick, hinge);
        double rad = Math.toRadians(angle);
        float cos = (float)Math.cos(rad);
        float sin = (float)Math.sin(rad);
        float rotDX = dX * cos - dZ * sin;
        float rotDZ = dX * sin + dZ * cos;
        float shiftX = dX - rotDX;
        float shiftZ = dZ - rotDZ;
        poseStack.translate(shiftX, 0.0f, shiftZ);
        poseStack.translate(pivotX, 0.0f, pivotZ);
        poseStack.mulPose((Quaternionfc)Axis.YP.rotationDegrees((float)angle));
        poseStack.translate(-pivotX, 0.0f, -pivotZ);
        int light = LevelRenderer.getLightColor((BlockAndTintGetter)Minecraft.getInstance().level, (BlockPos)this.position);
        Minecraft.getInstance().getBlockRenderer().renderSingleBlock(this.defaultState, poseStack, (MultiBufferSource)bufferSource, light, OverlayTexture.NO_OVERLAY);
    }
}

