/*
 * Decompiled with CFR 0.152.
 */
package fr.madu59.fwa.anims;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import fr.madu59.fwa.anims.Animation;
import fr.madu59.fwa.config.SettingsManager;
import fr.madu59.fwa.utils.Curves;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.BlockModelPart;
import net.minecraft.client.renderer.block.model.BlockStateModel;
import net.minecraft.client.renderer.rendertype.RenderTypes;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.EndPortalFrameBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class EndPortalFrameAnimation
extends Animation {
    private final RandomSource random = RandomSource.create((long)42L);

    public EndPortalFrameAnimation(BlockPos position, BlockState defaultState, double startTick, boolean oldIsOpen, boolean newIsOpen) {
        super(position, defaultState, startTick, oldIsOpen, newIsOpen);
    }

    @Override
    public double getAnimDuration() {
        return 10.0 * SettingsManager.END_PORTAL_FRAME_SPEED.getValue();
    }

    @Override
    public <T extends Enum<T>> T getCurve() {
        return (T)((Object)SettingsManager.END_PORTAL_FRAME_EASING.getValue());
    }

    @Override
    public boolean isEnabled() {
        return SettingsManager.END_PORTAL_FRAME_STATE.getValue();
    }

    @Override
    public boolean hideOriginalBlock() {
        return this.newIsOpen;
    }

    public static boolean hasInfiniteAnimation() {
        return SettingsManager.END_PORTAL_FRAME_INFINITE.getValue();
    }

    @Override
    public double getLifeSpan() {
        return !EndPortalFrameAnimation.hasInfiniteAnimation() || this.newIsOpen ? this.getAnimDuration() : Double.MAX_VALUE;
    }

    @Override
    public void render(PoseStack poseStack, MultiBufferSource.BufferSource bufferSource, double nowTick) {
        int light = LevelRenderer.getLightColor((BlockAndTintGetter)Minecraft.getInstance().level, (BlockPos)this.position);
        BlockState eyeState = (BlockState)this.defaultState.setValue((Property)EndPortalFrameBlock.HAS_EYE, (Comparable)Boolean.valueOf(true));
        BlockStateModel model = Minecraft.getInstance().getBlockRenderer().getBlockModel(eyeState);
        BlockModelPart part = (BlockModelPart)model.collectParts(this.random).get(0);
        if (this.newIsOpen) {
            VertexConsumer buffer = bufferSource.getBuffer(ItemBlockRenderTypes.getRenderType((BlockState)eyeState));
            Minecraft.getInstance().getBlockRenderer().renderSingleBlock(this.defaultState, poseStack, (MultiBufferSource)bufferSource, light, OverlayTexture.NO_OVERLAY);
            poseStack.translate(0.0f, 0.25f - (float)Curves.ease(this.getProgress(nowTick), this.getCurve()) / 4.0f, 0.0f);
            this.renderFilteredQuads(poseStack, buffer, part.getQuads(null), true, light, 1.0f, 1.0f, 1.0f, 1.0f);
            for (Direction dir : Direction.values()) {
                this.renderFilteredQuads(poseStack, buffer, part.getQuads(dir), true, light, 1.0f, 1.0f, 1.0f, 1.0f);
            }
        } else {
            VertexConsumer buffer = bufferSource.getBuffer(RenderTypes.translucentMovingBlock());
            float time = (float)(nowTick - this.startTick);
            float alpha = 0.1f + Math.abs((float)Math.sin((double)time * 0.07)) * 0.3f;
            this.renderFilteredQuads(poseStack, buffer, part.getQuads(null), true, light, 0.0f, 1.0f, 0.0f, alpha);
            for (Direction dir : Direction.values()) {
                this.renderFilteredQuads(poseStack, buffer, part.getQuads(dir), true, light, 0.0f, 1.0f, 0.0f, alpha);
            }
        }
    }

    private void renderFilteredQuads(PoseStack poseStack, VertexConsumer buffer, List<BakedQuad> quads, boolean wantEye, int light, float r, float g, float b, float a) {
        for (BakedQuad quad : quads) {
            String path = quad.sprite().contents().name().getPath();
            if (path.contains("eye") != wantEye) continue;
            buffer.putBulkData(poseStack.last(), quad, r, g, b, a, light, OverlayTexture.NO_OVERLAY);
        }
    }
}

