/*
 * Decompiled with CFR 0.152.
 */
package fr.madu59.fwa.anims;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import fr.madu59.fwa.anims.Animation;
import fr.madu59.fwa.config.SettingsManager;
import fr.madu59.fwa.utils.Curves;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.BlockModelPart;
import net.minecraft.client.renderer.block.model.BlockStateModel;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.FenceGateBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.joml.Quaternionfc;
import org.joml.Vector3fc;

public class FenceGateAnimation
extends Animation {
    private final RandomSource random = RandomSource.create((long)42L);
    private final float EPSILON = 1.0E-4f;

    public FenceGateAnimation(BlockPos position, BlockState defaultState, double startTick, boolean oldIsOpen, boolean newIsOpen) {
        super(position, defaultState, startTick, oldIsOpen, newIsOpen);
    }

    @Override
    public double getAnimDuration() {
        return 10.0 * SettingsManager.FENCEGATE_SPEED.getValue();
    }

    @Override
    public <T extends Enum<T>> T getCurve() {
        return (T)((Object)SettingsManager.FENCEGATE_EASING.getValue());
    }

    @Override
    public boolean isEnabled() {
        return SettingsManager.FENCEGATE_STATE.getValue();
    }

    private double getStartAngle(boolean isOpen) {
        if (!isOpen) {
            return 0.0;
        }
        return 90.0;
    }

    private double getAngle(double nowTick, Direction facing) {
        double angle1 = this.getStartAngle(this.oldIsOpen);
        double angle2 = this.getStartAngle(this.newIsOpen);
        double finalAngle = angle1 + (angle2 - angle1) * Curves.ease(this.getProgress(nowTick), this.getCurve());
        if (facing == Direction.NORTH || facing == Direction.WEST) {
            finalAngle = -finalAngle;
        }
        return finalAngle;
    }

    @Override
    public void render(PoseStack poseStack, MultiBufferSource.BufferSource bufferSource, double nowTick) {
        Direction facing = (Direction)this.defaultState.getValue((Property)FenceGateBlock.FACING);
        int light = LevelRenderer.getLightColor((BlockAndTintGetter)Minecraft.getInstance().level, (BlockPos)this.position);
        VertexConsumer buffer = bufferSource.getBuffer(ItemBlockRenderTypes.getRenderType((BlockState)this.defaultState));
        BlockStateModel model = Minecraft.getInstance().getBlockRenderer().getBlockModel(this.defaultState);
        BlockModelPart part = (BlockModelPart)model.collectParts(this.random).get(0);
        ArrayList<BakedQuad> quads = new ArrayList<BakedQuad>();
        for (Direction dir : Direction.values()) {
            quads.addAll(part.getQuads(dir));
        }
        quads.addAll(part.getQuads(null));
        FenceGate fenceGate = this.splitFenceGateQuads(quads, facing);
        for (BakedQuad quad : fenceGate.postQuadList) {
            buffer.putBulkData(poseStack.last(), quad, 1.0f, 1.0f, 1.0f, 1.0f, light, OverlayTexture.NO_OVERLAY);
        }
        boolean onAxisZ = facing.getAxis() == Direction.Axis.Z;
        float leftPivotX = onAxisZ ? 0.0625f : 0.5f;
        float leftPivotZ = onAxisZ ? 0.5f : 0.0625f;
        float rightPivotX = onAxisZ ? 0.9375f : 0.5f;
        float rightPivotZ = onAxisZ ? 0.5f : 0.9375f;
        float angle = (float)this.getAngle(nowTick, facing);
        float leftAngle = onAxisZ ? -angle : angle;
        float rightAngle = onAxisZ ? angle : -angle;
        poseStack.translate(leftPivotX, 0.0f, leftPivotZ);
        poseStack.mulPose((Quaternionfc)Axis.YP.rotationDegrees(leftAngle));
        poseStack.translate(-leftPivotX, 0.0f, -leftPivotZ);
        for (BakedQuad quad : fenceGate.leftQuadList) {
            buffer.putBulkData(poseStack.last(), quad, 1.0f, 1.0f, 1.0f, 1.0f, light, OverlayTexture.NO_OVERLAY);
        }
        poseStack.translate(leftPivotX, 0.0f, leftPivotZ);
        poseStack.mulPose((Quaternionfc)Axis.YP.rotationDegrees(-leftAngle));
        poseStack.translate(-leftPivotX, 0.0f, -leftPivotZ);
        poseStack.translate(rightPivotX, 0.0f, rightPivotZ);
        poseStack.mulPose((Quaternionfc)Axis.YP.rotationDegrees(rightAngle));
        poseStack.translate(-rightPivotX, 0.0f, -rightPivotZ);
        for (BakedQuad quad : fenceGate.rightQuadList) {
            buffer.putBulkData(poseStack.last(), quad, 1.0f, 1.0f, 1.0f, 1.0f, light, OverlayTexture.NO_OVERLAY);
        }
    }

    public FenceGate splitFenceGateQuads(List<BakedQuad> quads, Direction facing) {
        ArrayList<BakedQuad> post = new ArrayList<BakedQuad>();
        ArrayList<BakedQuad> left = new ArrayList<BakedQuad>();
        ArrayList<BakedQuad> right = new ArrayList<BakedQuad>();
        for (BakedQuad quad : quads) {
            float max;
            float min;
            Vector3fc pos1 = quad.position0();
            Vector3fc pos2 = quad.position1();
            Vector3fc pos3 = quad.position2();
            Vector3fc pos4 = quad.position3();
            if (facing.getAxis() == Direction.Axis.X) {
                min = Math.min(pos1.z(), Math.min(pos2.z(), Math.min(pos3.z(), pos4.z())));
                max = Math.max(pos1.z(), Math.max(pos2.z(), Math.max(pos3.z(), pos4.z())));
            } else {
                min = Math.min(pos1.x(), Math.min(pos2.x(), Math.min(pos3.x(), pos4.x())));
                max = Math.max(pos1.x(), Math.max(pos2.x(), Math.max(pos3.x(), pos4.x())));
            }
            if (this.gte(min, 0.125f) && this.lte(max, 0.875f) && (!this.is(max, min) || !this.lte(max, 0.125f) && !this.gte(max, 0.875f))) {
                if (this.is(min, 0.5f) && this.is(max, 0.5f)) {
                    right.add(quad);
                    left.add(quad);
                    continue;
                }
                if (this.gte(min, 0.5f) && this.gte(max, 0.5f)) {
                    right.add(quad);
                    continue;
                }
                left.add(quad);
                continue;
            }
            post.add(quad);
        }
        return new FenceGate(this, post, left, right);
    }

    private boolean is(float value, float target) {
        return Math.abs(value - target) < 1.0E-4f;
    }

    private boolean gte(float value, float target) {
        return value > target - 1.0E-4f;
    }

    private boolean lte(float value, float target) {
        return value < target + 1.0E-4f;
    }

    public class FenceGate {
        List<BakedQuad> postQuadList;
        List<BakedQuad> leftQuadList;
        List<BakedQuad> rightQuadList;

        public FenceGate(FenceGateAnimation this$0, List<BakedQuad> postQuadList, List<BakedQuad> leftQuadList, List<BakedQuad> rightQuadList) {
            this.postQuadList = postQuadList;
            this.leftQuadList = leftQuadList;
            this.rightQuadList = rightQuadList;
        }
    }
}

