/*
 * Decompiled with CFR 0.152.
 */
package fr.madu59.fwa.anims;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import fr.madu59.fwa.anims.Animation;
import fr.madu59.fwa.config.SettingsManager;
import fr.madu59.fwa.utils.Curves;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.SubmitNodeCollector;
import net.minecraft.client.renderer.SubmitNodeStorage;
import net.minecraft.client.renderer.item.ItemStackRenderState;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.entity.JukeboxBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import org.joml.Quaternionfc;

public class JukeBoxAnimation
extends Animation {
    BlockState newState;
    private final ItemStackRenderState discState = new ItemStackRenderState();

    public JukeBoxAnimation(BlockPos position, BlockState defaultState, double startTick, boolean oldIsOpen, boolean newIsOpen, BlockState newState) {
        super(position, defaultState, startTick, oldIsOpen, newIsOpen);
        this.newState = newState;
    }

    @Override
    public double getAnimDuration() {
        return 10.0 * SettingsManager.JUKEBOX_SPEED.getValue();
    }

    @Override
    public double getLifeSpan() {
        return JukeBoxAnimation.hasInfiniteAnimation() ? Double.MAX_VALUE : this.getAnimDuration();
    }

    @Override
    public <T extends Enum<T>> T getCurve() {
        return (T)((Object)SettingsManager.JUKEBOX_EASING.getValue());
    }

    @Override
    public boolean isEnabled() {
        return SettingsManager.JUKEBOX_STATE.getValue();
    }

    public static boolean hasInfiniteAnimation() {
        return SettingsManager.JUKEBOX_INFINITE.getValue();
    }

    @Override
    public boolean hideOriginalBlock() {
        return false;
    }

    private float getDeltaY(double nowTick) {
        float progress = (float)Curves.ease(this.getProgress(nowTick), this.getCurve());
        if (JukeBoxAnimation.hasInfiniteAnimation()) {
            return 3.0f * progress / 4.0f;
        }
        return progress;
    }

    @Override
    public void render(PoseStack poseStack, MultiBufferSource.BufferSource bufferSource, double nowTick) {
        float scale = 0.67f;
        JukeboxBlockEntity jukeboxBlockEntity = (JukeboxBlockEntity)Minecraft.getInstance().level.getBlockEntity(this.position);
        ItemStack discItemStack = new ItemStack((ItemLike)Items.MUSIC_DISC_13);
        if (jukeboxBlockEntity != null && (discItemStack = jukeboxBlockEntity.getTheItem()).isEmpty()) {
            discItemStack = new ItemStack((ItemLike)Items.MUSIC_DISC_13);
        }
        int light = LevelRenderer.getLightColor((BlockAndTintGetter)Minecraft.getInstance().level, (BlockPos)this.position.above());
        float dy = this.getDeltaY(nowTick);
        dy = this.newIsOpen ? 1.0f - dy : dy;
        poseStack.mulPose((Quaternionfc)Axis.YP.rotationDegrees(90.0f));
        poseStack.scale(scale, scale, 1.0f);
        poseStack.translate(-0.71875f, 1.1875f + dy, 0.5f);
        Minecraft.getInstance().getItemModelResolver().updateForTopItem(this.discState, discItemStack, ItemDisplayContext.ON_SHELF, Minecraft.getInstance().player.level(), null, this.position.hashCode());
        SubmitNodeStorage submitNodeCollector = Minecraft.getInstance().gameRenderer.getSubmitNodeStorage();
        this.discState.submit(poseStack, (SubmitNodeCollector)submitNodeCollector, light, OverlayTexture.NO_OVERLAY, 0);
    }
}

