/*
 * Decompiled with CFR 0.152.
 */
package fr.madu59.fwa.anims;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import fr.madu59.fwa.anims.Animation;
import fr.madu59.fwa.config.SettingsManager;
import fr.madu59.fwa.mixin.GetContentHeightInvoker;
import fr.madu59.fwa.utils.Curves;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.BlockModelPart;
import net.minecraft.client.renderer.block.model.BlockStateModel;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.CauldronBlock;
import net.minecraft.world.level.block.LavaCauldronBlock;
import net.minecraft.world.level.block.LayeredCauldronBlock;
import net.minecraft.world.level.block.state.BlockState;

public class LayeredCauldronAnimation
extends Animation {
    private final BlockState oldState;
    private final BlockState newState;
    private final boolean isInverted;
    private final RandomSource random = RandomSource.create((long)42L);
    private final BlockStateModel model;

    public LayeredCauldronAnimation(BlockPos position, BlockState defaultState, double startTick, boolean oldIsOpen, boolean newIsOpen, BlockState newBlockState, BlockState oldBlockState) {
        super(position, defaultState, startTick, oldIsOpen, newIsOpen);
        if (newBlockState.getBlock() instanceof CauldronBlock) {
            this.newState = oldBlockState;
            this.oldState = newBlockState;
            this.isInverted = true;
        } else {
            this.newState = newBlockState;
            this.oldState = oldBlockState;
            this.isInverted = false;
        }
        this.model = Minecraft.getInstance().getBlockRenderer().getBlockModel(this.newState);
    }

    @Override
    public double getAnimDuration() {
        return 10.0 * SettingsManager.CAULDRON_SPEED.getValue();
    }

    @Override
    public <T extends Enum<T>> T getCurve() {
        return (T)((Object)SettingsManager.CAULDRON_EASING.getValue());
    }

    @Override
    public boolean isEnabled() {
        return SettingsManager.CAULDRON_STATE.getValue();
    }

    private float getPosition(double nowTick, double newPos, double oldPos) {
        if (this.isInverted) {
            return (float)((oldPos - newPos) * Curves.ease(this.getProgress(nowTick), this.getCurve()));
        }
        return (float)(oldPos - newPos - (oldPos - newPos) * Curves.ease(this.getProgress(nowTick), this.getCurve()));
    }

    private double getHeight(BlockState state) {
        if (state.getBlock() instanceof LayeredCauldronBlock) {
            return ((GetContentHeightInvoker)state.getBlock()).fwa$getContentHeight(state);
        }
        if (state.getBlock() instanceof LavaCauldronBlock) {
            return 0.9375;
        }
        return 0.25;
    }

    @Override
    public void render(PoseStack poseStack, MultiBufferSource.BufferSource bufferSource, double nowTick) {
        int light = LevelRenderer.getLightColor((BlockAndTintGetter)Minecraft.getInstance().level, (BlockPos)this.position);
        VertexConsumer buffer = bufferSource.getBuffer(ItemBlockRenderTypes.getRenderType((BlockState)this.newState));
        BlockModelPart part = (BlockModelPart)this.model.collectParts(this.random).get(0);
        this.renderFilteredQuads(poseStack, buffer, part.getQuads(null), false, light);
        for (Direction dir : Direction.values()) {
            this.renderFilteredQuads(poseStack, buffer, part.getQuads(dir), false, light);
        }
        float dy = this.getPosition(nowTick, this.getHeight(this.newState), this.getHeight(this.oldState));
        poseStack.translate(0.0f, dy, 0.0f);
        this.renderFilteredQuads(poseStack, buffer, part.getQuads(null), true, light);
        for (Direction dir : Direction.values()) {
            this.renderFilteredQuads(poseStack, buffer, part.getQuads(dir), true, light);
        }
    }

    private void renderFilteredQuads(PoseStack poseStack, VertexConsumer buffer, List<BakedQuad> quads, boolean wantLiquid, int light) {
        for (BakedQuad quad : quads) {
            String path = quad.sprite().contents().name().getPath();
            if (path.contains("cauldron") == wantLiquid) continue;
            float r = 1.0f;
            float g = 1.0f;
            float b = 1.0f;
            if (quad.isTinted()) {
                int color = Minecraft.getInstance().getBlockColors().getColor(this.newState, (BlockAndTintGetter)Minecraft.getInstance().level, this.position, quad.tintIndex());
                r = (float)(color >> 16 & 0xFF) / 255.0f;
                g = (float)(color >> 8 & 0xFF) / 255.0f;
                b = (float)(color & 0xFF) / 255.0f;
            }
            buffer.putBulkData(poseStack.last(), quad, r, g, b, 1.0f, light, OverlayTexture.NO_OVERLAY);
        }
    }
}

