/*
 * Decompiled with CFR 0.152.
 */
package fr.madu59.fwa.anims;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import fr.madu59.fwa.anims.Animation;
import fr.madu59.fwa.config.SettingsManager;
import fr.madu59.fwa.utils.Curves;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.model.object.book.BookModel;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.rendertype.RenderTypes;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.Identifier;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.LecternBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.joml.Quaternionfc;

public class LecternAnimation
extends Animation {
    private final BookModel bookModel = new BookModel(Minecraft.getInstance().getEntityModels().bakeLayer(ModelLayers.BOOK));
    private final float hash;

    public LecternAnimation(BlockPos position, BlockState defaultState, double startTick, boolean oldIsOpen, boolean newIsOpen) {
        super(position, defaultState, startTick, oldIsOpen, newIsOpen);
        this.hash = position.hashCode();
    }

    @Override
    public double getAnimDuration() {
        return 5.0 * SettingsManager.LECTERN_SPEED.getValue();
    }

    @Override
    public double getLifeSpan() {
        return !LecternAnimation.hasInfiniteAnimation() || !this.newIsOpen ? this.getAnimDuration() : Double.MAX_VALUE;
    }

    @Override
    public <T extends Enum<T>> T getCurve() {
        return (T)((Object)SettingsManager.LECTERN_EASING.getValue());
    }

    @Override
    public boolean isEnabled() {
        return SettingsManager.LECTERN_STATE.getValue();
    }

    @Override
    public boolean hideOriginalBlock() {
        return false;
    }

    public static boolean hasInfiniteAnimation() {
        return SettingsManager.LECTERN_INFINITE.getValue();
    }

    private double getAngle(double progress) {
        double startAngle = this.oldIsOpen ? 1.2 : 0.0;
        double endAngle = this.newIsOpen ? 1.2 : 0.0;
        return startAngle + (endAngle - startAngle) * progress;
    }

    private float getPageAngle(float defaultVal, double nowTick) {
        float time = (float)(nowTick - this.startTick);
        if ((double)time <= this.getAnimDuration()) {
            return defaultVal;
        }
        float uniqueOffset = (this.hash + defaultVal * 67.0f) % 100.0f;
        float slowWave = (float)Math.sin((time += uniqueOffset) * 0.1f) * 0.05f;
        float fastWave = (float)Math.sin(time * 0.25f) * 0.02f;
        return defaultVal + (slowWave + fastWave) / 2.0f;
    }

    @Override
    public void render(PoseStack poseStack, MultiBufferSource.BufferSource bufferSource, double nowTick) {
        Direction facing = (Direction)this.defaultState.getValue((Property)LecternBlock.FACING);
        VertexConsumer buffer = bufferSource.getBuffer(RenderTypes.entityCutoutNoCull((Identifier)Identifier.tryParse((String)"minecraft:textures/entity/enchanting_table_book.png")));
        int light = LevelRenderer.getLightColor((BlockAndTintGetter)Minecraft.getInstance().level, (BlockPos)this.position);
        BookModel.State bookState = new BookModel.State(0.0f, this.getPageAngle(0.1f, nowTick), this.getPageAngle(0.9f, nowTick), (float)this.getAngle(Curves.ease(this.getProgress(nowTick), this.getCurve())));
        this.bookModel.setupAnim(bookState);
        poseStack.translate(0.5f, 1.0625f, 0.5f);
        poseStack.mulPose((Quaternionfc)Axis.YP.rotationDegrees(-facing.getClockWise().toYRot()));
        poseStack.mulPose((Quaternionfc)Axis.ZP.rotationDegrees(67.5f));
        poseStack.translate(0.0f, -0.125f, 0.0f);
        this.bookModel.renderToBuffer(poseStack, buffer, light, OverlayTexture.NO_OVERLAY);
    }
}

