/*
 * Decompiled with CFR 0.152.
 */
package fr.madu59.fwa.anims;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import fr.madu59.fwa.anims.Animation;
import fr.madu59.fwa.config.SettingsManager;
import fr.madu59.fwa.utils.Curves;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.BlockModelPart;
import net.minecraft.client.renderer.block.model.BlockStateModel;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.LeverBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.AttachFace;
import net.minecraft.world.level.block.state.properties.Property;
import org.joml.Quaternionfc;

public class LeverAnimation
extends Animation {
    private final RandomSource random = RandomSource.create((long)42L);
    private final BlockStateModel model;

    public LeverAnimation(BlockPos position, BlockState defaultState, double startTick, boolean oldIsOpen, boolean newIsOpen) {
        super(position, defaultState, startTick, oldIsOpen, newIsOpen);
        this.model = Minecraft.getInstance().getBlockRenderer().getBlockModel(defaultState);
    }

    @Override
    public double getAnimDuration() {
        return 5.0 * SettingsManager.LEVER_SPEED.getValue();
    }

    @Override
    public <T extends Enum<T>> T getCurve() {
        return (T)((Object)SettingsManager.LEVER_EASING.getValue());
    }

    @Override
    public boolean isEnabled() {
        return SettingsManager.LEVER_STATE.getValue();
    }

    private double getStartAngle(boolean isOpen) {
        if (!isOpen) {
            return 0.0;
        }
        return 90.0;
    }

    private double getAngle(double nowTick, Direction facing) {
        double angle1 = this.getStartAngle(this.oldIsOpen);
        double angle2 = this.getStartAngle(this.newIsOpen);
        double finalAngle = angle1 + (angle2 - angle1) * Curves.ease(this.getProgress(nowTick), this.getCurve());
        if (facing == Direction.NORTH || facing == Direction.EAST) {
            finalAngle = -finalAngle;
        }
        return finalAngle;
    }

    @Override
    public void render(PoseStack poseStack, MultiBufferSource.BufferSource bufferSource, double nowTick) {
        Direction facing = (Direction)this.defaultState.getValue((Property)LeverBlock.FACING);
        AttachFace face = (AttachFace)this.defaultState.getValue((Property)LeverBlock.FACE);
        int light = LevelRenderer.getLightColor((BlockAndTintGetter)Minecraft.getInstance().level, (BlockPos)this.position);
        VertexConsumer buffer = bufferSource.getBuffer(ItemBlockRenderTypes.getRenderType((BlockState)this.defaultState));
        BlockModelPart part = (BlockModelPart)this.model.collectParts(this.random).get(0);
        this.renderFilteredQuads(poseStack, buffer, part.getQuads(null), false, light);
        for (Direction dir : Direction.values()) {
            this.renderFilteredQuads(poseStack, buffer, part.getQuads(dir), false, light);
        }
        double angle = this.getAngle(nowTick, facing);
        float pivotX = 0.5f;
        float pivotY = 0.0625f;
        float pivotZ = 0.5f;
        Axis axis = Axis.XP;
        if (face == AttachFace.FLOOR) {
            switch (facing) {
                case EAST: 
                case WEST: {
                    axis = Axis.ZP;
                    break;
                }
            }
        } else if (face == AttachFace.CEILING) {
            pivotY = 0.9375f;
            switch (facing) {
                case EAST: 
                case WEST: {
                    axis = Axis.ZN;
                    break;
                }
                default: {
                    axis = Axis.XN;
                    break;
                }
            }
        } else if (face == AttachFace.WALL) {
            pivotY = 0.5f;
            switch (facing) {
                case EAST: 
                case WEST: {
                    axis = Axis.ZP;
                    pivotX = facing == Direction.WEST ? 0.9375f : 0.0625f;
                    pivotZ = 0.5f;
                    break;
                }
                default: {
                    axis = Axis.XP;
                    pivotX = 0.5f;
                    pivotZ = facing == Direction.NORTH ? 0.9375f : 0.0625f;
                }
            }
        }
        poseStack.translate(pivotX, pivotY, pivotZ);
        poseStack.mulPose((Quaternionfc)axis.rotationDegrees((float)angle));
        poseStack.translate(-pivotX, -pivotY, -pivotZ);
        this.renderFilteredQuads(poseStack, buffer, part.getQuads(null), true, light);
    }

    private void renderFilteredQuads(PoseStack poseStack, VertexConsumer buffer, List<BakedQuad> quads, boolean wantHandle, int light) {
        for (BakedQuad quad : quads) {
            String path = quad.sprite().contents().name().getPath();
            if (path.contains("lever") != wantHandle) continue;
            buffer.putBulkData(poseStack.last(), quad, 1.0f, 1.0f, 1.0f, 1.0f, light, OverlayTexture.NO_OVERLAY);
        }
    }
}

