/*
 * Decompiled with CFR 0.152.
 */
package fr.madu59.fwa.anims;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import fr.madu59.fwa.anims.Animation;
import fr.madu59.fwa.config.SettingsManager;
import fr.madu59.fwa.utils.Curves;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.BlockModelPart;
import net.minecraft.client.renderer.block.model.BlockStateModel;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.RepeaterBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class RepeaterAnimation
extends Animation {
    private final BlockState oldState;
    private final BlockState newState;
    private final RandomSource random = RandomSource.create((long)42L);
    private final BlockStateModel model;

    public RepeaterAnimation(BlockPos position, BlockState defaultState, double startTick, boolean oldIsOpen, boolean newIsOpen, BlockState newBlockState, BlockState oldBlockState) {
        super(position, defaultState, startTick, oldIsOpen, newIsOpen);
        this.newState = newBlockState;
        this.oldState = oldBlockState;
        this.model = Minecraft.getInstance().getBlockRenderer().getBlockModel(defaultState);
    }

    @Override
    public double getAnimDuration() {
        return 10.0 * SettingsManager.REPEATER_SPEED.getValue();
    }

    @Override
    public <T extends Enum<T>> T getCurve() {
        return (T)((Object)SettingsManager.REPEATER_EASING.getValue());
    }

    @Override
    public boolean isEnabled() {
        return SettingsManager.REPEATER_STATE.getValue();
    }

    private float getPosition(double nowTick, int newPos, int oldPos) {
        return (float)((double)oldPos + (double)(newPos - oldPos) * Curves.ease(this.getProgress(nowTick), this.getCurve()));
    }

    @Override
    public void render(PoseStack poseStack, MultiBufferSource.BufferSource bufferSource, double nowTick) {
        Direction facing = (Direction)this.defaultState.getValue((Property)RepeaterBlock.FACING);
        int light = LevelRenderer.getLightColor((BlockAndTintGetter)Minecraft.getInstance().level, (BlockPos)this.position);
        VertexConsumer buffer = bufferSource.getBuffer(ItemBlockRenderTypes.getRenderType((BlockState)this.defaultState));
        BlockModelPart part = (BlockModelPart)this.model.collectParts(this.random).get(0);
        this.renderFilteredQuads(poseStack, buffer, part.getQuads(null), false, light);
        for (Direction dir : Direction.values()) {
            this.renderFilteredQuads(poseStack, buffer, part.getQuads(dir), false, light);
        }
        float dx = this.getPosition(nowTick, (Integer)this.newState.getValue((Property)RepeaterBlock.DELAY), (Integer)this.oldState.getValue((Property)RepeaterBlock.DELAY));
        dx = (dx - 1.0f) * 2.0f / 16.0f * (float)facing.getAxisDirection().getStep();
        if (facing.getAxis() == Direction.Axis.X) {
            poseStack.translate(dx, 0.0f, 0.0f);
        } else {
            poseStack.translate(0.0f, 0.0f, dx);
        }
        this.renderFilteredQuads(poseStack, buffer, part.getQuads(null), true, light);
        for (Direction dir : Direction.values()) {
            this.renderFilteredQuads(poseStack, buffer, part.getQuads(dir), true, light);
        }
    }

    private void renderFilteredQuads(PoseStack poseStack, VertexConsumer buffer, List<BakedQuad> quads, boolean wantTorch, int light) {
        for (BakedQuad quad : quads) {
            String path = quad.sprite().contents().name().getPath();
            if ((path.contains("redstone_torch") && quad.position0().x() > 0.3125f && quad.position0().x() < 0.6875f && quad.position2().x() > 0.3125f && quad.position2().x() < 0.6875f && quad.position0().z() > 0.3125f && quad.position0().z() < 0.6875f && quad.position2().z() > 0.3125f && quad.position2().z() < 0.6875f) != wantTorch) continue;
            buffer.putBulkData(poseStack.last(), quad, 1.0f, 1.0f, 1.0f, 1.0f, light, OverlayTexture.NO_OVERLAY);
        }
    }
}

