/*
 * Decompiled with CFR 0.152.
 */
package fr.madu59.fwa.anims;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import fr.madu59.fwa.anims.Animation;
import fr.madu59.fwa.config.SettingsManager;
import fr.madu59.fwa.utils.Curves;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.TrapDoorBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Half;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.joml.Quaternionfc;

public class TrapDoorAnimation
extends Animation {
    public TrapDoorAnimation(BlockPos position, BlockState defaultState, double startTick, boolean oldIsOpen, boolean newIsOpen) {
        super(position, defaultState, startTick, oldIsOpen, newIsOpen);
    }

    @Override
    public double getAnimDuration() {
        return 5.0 * SettingsManager.TRAPDOOR_SPEED.getValue();
    }

    @Override
    public <T extends Enum<T>> T getCurve() {
        return (T)((Object)SettingsManager.TRAPDOOR_EASING.getValue());
    }

    @Override
    public boolean isEnabled() {
        return SettingsManager.TRAPDOOR_STATE.getValue();
    }

    private double getStartAngle(boolean isOpen, Direction hingeSide) {
        if (!isOpen) {
            return 0.0;
        }
        return hingeSide == Direction.NORTH || hingeSide == Direction.EAST ? 90.0 : -90.0;
    }

    private double getAngle(double nowTick, Direction hingeSide) {
        double angle1 = this.getStartAngle(this.oldIsOpen, hingeSide);
        double angle2 = this.getStartAngle(this.newIsOpen, hingeSide);
        return angle1 + (angle2 - angle1) * Curves.ease(this.getProgress(nowTick), this.getCurve());
    }

    @Override
    public void render(PoseStack poseStack, MultiBufferSource.BufferSource bufferSource, double nowTick) {
        Direction facing = (Direction)this.defaultState.getValue((Property)TrapDoorBlock.FACING);
        Half half = (Half)this.defaultState.getValue((Property)TrapDoorBlock.HALF);
        VoxelShape collShape = this.defaultState.getCollisionShape((BlockGetter)Minecraft.getInstance().level, BlockPos.ZERO);
        AABB boundingBox = collShape.isEmpty() ? this.defaultState.getShape((BlockGetter)Minecraft.getInstance().level, BlockPos.ZERO).bounds() : collShape.bounds();
        Direction hingeSide = facing.getOpposite();
        double angle = this.getAngle(nowTick, hingeSide);
        if (half == Half.BOTTOM) {
            angle = -angle;
        }
        float pivotX = (float)((boundingBox.minX + boundingBox.maxX) * 0.5);
        float pivotZ = (float)((boundingBox.minZ + boundingBox.maxZ) * 0.5);
        switch (hingeSide) {
            case EAST: {
                pivotX = (float)boundingBox.maxX;
                break;
            }
            case WEST: {
                pivotX = (float)boundingBox.minX;
                break;
            }
            case SOUTH: {
                pivotZ = (float)boundingBox.maxZ;
                break;
            }
            case NORTH: {
                pivotZ = (float)boundingBox.minZ;
                break;
            }
        }
        float pivotY = half == Half.TOP ? (float)boundingBox.maxY : (float)boundingBox.minY;
        float thickness = (float)(boundingBox.maxY - boundingBox.minY);
        float halfThickness = thickness > 0.0f ? thickness * 0.5f : 0.09375f;
        float dY = half == Half.TOP ? -halfThickness : halfThickness;
        double rad = Math.toRadians(angle);
        float cos = (float)Math.cos(rad);
        float sin = (float)Math.sin(rad);
        float shiftX = 0.0f;
        float shiftY = 0.0f;
        float shiftZ = 0.0f;
        if (hingeSide == Direction.NORTH || hingeSide == Direction.SOUTH) {
            float rotY = dY * cos;
            float rotZ = dY * sin;
            shiftY = dY - rotY;
            shiftZ = -rotZ;
        } else {
            float rotX = -dY * sin;
            float rotY = dY * cos;
            shiftX = -rotX;
            shiftY = dY - rotY;
        }
        poseStack.translate(shiftX, shiftY, shiftZ);
        poseStack.translate(pivotX, pivotY, pivotZ);
        if (hingeSide == Direction.NORTH || hingeSide == Direction.SOUTH) {
            poseStack.mulPose((Quaternionfc)Axis.XP.rotationDegrees((float)angle));
        } else {
            poseStack.mulPose((Quaternionfc)Axis.ZP.rotationDegrees((float)angle));
        }
        poseStack.translate(-pivotX, -pivotY, -pivotZ);
        poseStack.translate(-shiftX, -shiftY, -shiftZ);
        int light = LevelRenderer.getLightColor((BlockAndTintGetter)Minecraft.getInstance().level, (BlockPos)this.position);
        Minecraft.getInstance().getBlockRenderer().renderSingleBlock(this.defaultState, poseStack, (MultiBufferSource)bufferSource, light, OverlayTexture.NO_OVERLAY);
    }
}

