/*
 * Decompiled with CFR 0.152.
 */
package fr.madu59.fwa.config.configscreen;

import fr.madu59.fwa.config.Option;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.AbstractSliderButton;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.ContainerObjectSelectionList;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.client.input.MouseButtonEvent;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.sounds.SoundEvents;

public class MyConfigListWidget
extends ContainerObjectSelectionList<Entry> {
    public MyConfigListWidget(Minecraft client, int width, int height, int top, int itemHeight) {
        super(client, width, height, top, itemHeight);
    }

    protected int scrollBarX() {
        return this.getX() + this.getWidth() - 6;
    }

    public int getRowWidth() {
        return this.width;
    }

    public void addCategory(String name) {
        this.addEntry((AbstractSelectionList.Entry)new CategoryEntry(name));
    }

    public void addButton(String name, Button.OnPress onPress) {
        this.addEntry((AbstractSelectionList.Entry)new ButtonEntry(Button.builder((Component)Component.literal((String)name), (Button.OnPress)onPress).bounds(0, 0, 100, 20).build(), null, ""));
    }

    public void addButton(Option<?> option) {
        this.addButton(option, "");
    }

    public void addButton(Option<?> option, String indent) {
        this.addEntry((AbstractSelectionList.Entry)new ButtonEntry(Button.builder((Component)Component.translatable((String)("fwa.config.value." + option.getValue().toString().toLowerCase())), btn -> option.setToNextValue()).bounds(0, 0, 100, 20).build(), option, indent));
    }

    public <N extends Number> void addSlider(Option<N> option, N min, N max, N step) {
        this.addSlider(option, min, max, step, "");
    }

    public <N extends Number> void addSlider(final Option<N> option, final N min, final N max, final N step, String indent) {
        double dMin = min.doubleValue();
        double dMax = max.doubleValue();
        double dCurrent = ((Number)option.getValue()).doubleValue();
        double initialPosition = dMax <= dMin ? 0.0 : (dCurrent - dMin) / (dMax - dMin);
        initialPosition = Math.max(0.0, Math.min(1.0, initialPosition));
        this.addEntry((AbstractSelectionList.Entry)new SliderEntry(new AbstractSliderButton(this, 0, 0, 100, 20, (Component)Component.literal((String)((Number)option.getValue()).toString()), initialPosition){

            protected void updateMessage() {
                String stepStr = step.toString();
                int decimalPlaces = 0;
                if (stepStr.contains(".")) {
                    decimalPlaces = stepStr.length() - stepStr.indexOf(46) - 1;
                }
                String format = "%." + decimalPlaces + "f";
                String formattedValue = String.format(Locale.ROOT, format, option.getValue());
                this.setMessage((Component)Component.literal((String)formattedValue));
            }

            protected void applyValue() {
                if (option.getValue() instanceof Integer) {
                    int imax = max.intValue();
                    int imin = min.intValue();
                    int istep = step.intValue();
                    int newValue = imin + Math.round((float)(imax - imin) * (float)this.value / (float)istep) * istep;
                    option.setValue(Math.round(newValue));
                } else if (option.getValue() instanceof Double) {
                    double dmax = max.doubleValue();
                    double dmin = min.doubleValue();
                    double dstep = step.doubleValue();
                    double newValue = dmin + (double)Math.round((dmax - dmin) * this.value / dstep) * dstep;
                    option.setValue(newValue);
                } else if (option.getValue() instanceof Float) {
                    float fmax = max.floatValue();
                    float fmin = min.floatValue();
                    float fstep = step.floatValue();
                    float newValue = fmin + (float)Math.round((fmax - fmin) * (float)this.value / fstep) * fstep;
                    option.setValue((Number)Float.valueOf(newValue));
                }
            }
        }, option, indent));
    }

    public static class CategoryEntry
    extends Entry {
        private final String name;

        public CategoryEntry(String name) {
            this.name = name;
        }

        public void renderContent(GuiGraphics context, int mouseX, int mouseY, boolean hovered, float tickDelta) {
            Font textRenderer = Minecraft.getInstance().font;
            int textX = this.getContentX() + this.getContentWidth() / 2;
            int n = this.getContentY();
            int n2 = this.getContentHeight();
            Objects.requireNonNull(textRenderer);
            int textY = n + (n2 - 9) / 2;
            context.drawCenteredString(textRenderer, (Component)Component.translatable((String)this.name).withStyle(ChatFormatting.UNDERLINE), textX, textY, -1);
        }

        public List<? extends NarratableEntry> narratables() {
            return List.of();
        }

        public List<? extends GuiEventListener> children() {
            return List.of();
        }
    }

    public static class ButtonEntry
    extends Entry {
        private final Button button;
        private final String name;
        private final String indent;
        private final Option<?> option;

        public ButtonEntry(Button button, Option<?> option, String indent) {
            this.button = button;
            this.name = option.getName();
            this.indent = indent;
            this.option = option;
        }

        public void renderContent(GuiGraphics context, int mouseX, int mouseY, boolean hovered, float tickDelta) {
            this.button.setY(this.getContentY() + (this.getContentHeight() - this.button.getHeight()) / 2);
            this.button.setX(this.getContentWidth() - this.button.getWidth() - 10);
            this.button.render(context, mouseX, mouseY, tickDelta);
            if (this.name == null) {
                return;
            }
            Font textRenderer = Minecraft.getInstance().font;
            MutableComponent mutableComponent = Component.literal((String)(this.indent + this.name));
            int n = this.getContentY();
            int n2 = this.getContentHeight();
            Objects.requireNonNull(textRenderer);
            context.drawString(textRenderer, (Component)mutableComponent, 10, n + (n2 - 9) / 2, -1, true);
        }

        public List<? extends NarratableEntry> narratables() {
            return List.of(this.button);
        }

        public List<? extends GuiEventListener> children() {
            return List.of(this.button);
        }

        public boolean mouseClicked(MouseButtonEvent click, boolean doubleClick) {
            if (this.button.mouseClicked(click, doubleClick)) {
                Minecraft.getInstance().getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((Holder)SoundEvents.UI_BUTTON_CLICK, (float)1.0f));
                if (this.option != null) {
                    this.button.setMessage((Component)Component.translatable((String)("fwa.config.value." + this.option.getValue().toString().toLowerCase())));
                }
                return true;
            }
            return false;
        }
    }

    public static class SliderEntry
    extends Entry {
        private final AbstractSliderButton slider;
        private final String name;
        private final String indent;

        public SliderEntry(AbstractSliderButton slider, Option<?> option, String indent) {
            this.slider = slider;
            this.name = option.getName();
            this.indent = indent;
        }

        public void renderContent(GuiGraphics context, int mouseX, int mouseY, boolean hovered, float tickDelta) {
            this.slider.setY(this.getContentY() + (this.getContentHeight() - this.slider.getHeight()) / 2);
            this.slider.setX(this.getContentWidth() - this.slider.getWidth() - 10);
            this.slider.render(context, mouseX, mouseY, tickDelta);
            if (this.name == null) {
                return;
            }
            Font textRenderer = Minecraft.getInstance().font;
            MutableComponent mutableComponent = Component.literal((String)(this.indent + this.name));
            int n = this.getContentY();
            int n2 = this.getContentHeight();
            Objects.requireNonNull(textRenderer);
            context.drawString(textRenderer, (Component)mutableComponent, 10, n + (n2 - 9) / 2, -1, true);
        }

        public List<? extends NarratableEntry> narratables() {
            return List.of(this.slider);
        }

        public List<? extends GuiEventListener> children() {
            return List.of(this.slider);
        }
    }

    public static abstract class Entry
    extends ContainerObjectSelectionList.Entry<Entry> {
    }
}

