/*
 * Decompiled with CFR 0.152.
 */
package fr.madu59.fwa.utils;

public class Curves {
    public static double ease(double progress, Enum<?> type, boolean isForward) {
        return isForward ? Curves.ease(progress, type) : 1.0 - Curves.ease(1.0 - progress, type);
    }

    public static double ease(double progress, Enum<?> type) {
        if (type instanceof Classic) {
            Classic c = (Classic)type;
            switch (c.ordinal()) {
                default: 
            }
            return progress;
        }
        if (type instanceof Door) {
            Door c = (Door)type;
            switch (c.ordinal()) {
                case 1: {
                    return Curves.wrap(1.0 + 2.70158 * Math.pow(progress - 1.0, 3.0) + 1.70158 * Math.pow(progress - 1.0, 2.0));
                }
                case 0: {
                    return Curves.wrap(1.0 - Math.pow(1.0 - progress, 5.0));
                }
            }
            return progress;
        }
        return progress;
    }

    public static double unease(double progress, Enum<?> type) {
        if (type instanceof Classic) {
            Classic c = (Classic)type;
            switch (c.ordinal()) {
                default: 
            }
            return progress;
        }
        if (type instanceof Door) {
            Door c = (Door)type;
            switch (c.ordinal()) {
                case 0: {
                    return 1.0 - Math.pow(1.0 - progress, 0.0);
                }
            }
            return progress;
        }
        return progress;
    }

    private static double wrap(double value) {
        if (value >= 0.0 && value <= 1.0) {
            return value;
        }
        if (value < 0.0) {
            return -value;
        }
        return 1.0 - (value - 1.0);
    }

    public static double getSpeedCoeff(Speed speed) {
        switch (speed.ordinal()) {
            case 2: {
                return 1.5;
            }
            case 0: {
                return 0.65;
            }
        }
        return 1.0;
    }

    public static enum Classic {
        LINEAR;

    }

    public static enum Door {
        DEFAULT,
        SPRINGY,
        LINEAR;

    }

    public static enum Speed {
        SLOW,
        DEFAULT,
        FAST;

    }
}

