/*
 * Decompiled with CFR 0.152.
 */
package fr.madu59.fwa.anims;

import fr.madu59.fwa.anims.Animation;
import fr.madu59.fwa.config.SettingsManager;
import fr.madu59.fwa.utils.Curves;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_10889;
import net.minecraft.class_1920;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_4696;
import net.minecraft.class_5819;
import net.minecraft.class_761;
import net.minecraft.class_777;

@Environment(value=EnvType.CLIENT)
public class CampfireAnimation
extends Animation {
    private final class_310 client = class_310.method_1551();
    private final class_2680 oldState;
    private final class_2680 newState;
    private final class_5819 random = class_5819.method_43049((long)42L);

    public CampfireAnimation(class_2338 position, class_2680 defaultState, double startTick, boolean oldIsOpen, boolean newIsOpen, class_2680 oldBlockState, class_2680 newBlockState) {
        super(position, defaultState, startTick, oldIsOpen, newIsOpen);
        this.newState = newBlockState;
        this.oldState = oldBlockState;
    }

    @Override
    public double getAnimDuration() {
        return 15.0 * SettingsManager.CAMPFIRE_SPEED.getValue();
    }

    @Override
    public boolean isEnabled() {
        return SettingsManager.CAMPFIRE_STATE.getValue();
    }

    @Override
    public boolean hideOriginalBlockEntity() {
        return false;
    }

    @Override
    public <T extends Enum<T>> T getCurve() {
        return (T)((Object)Curves.Door.DEFAULT);
    }

    @Override
    public void render(class_4587 poseStack, class_4597.class_4598 bufferSource, double nowTick) {
        class_2680 state = this.oldIsOpen ? this.oldState : this.newState;
        class_10889 part = (class_10889)this.client.method_1541().method_3349(state).method_68512(this.random).get(0);
        int light = class_761.method_23794((class_1920)class_310.method_1551().field_1687, (class_2338)this.position);
        class_4588 buffer = bufferSource.method_73477(class_4696.method_23683((class_2680)state));
        this.renderFilteredQuads(poseStack, buffer, part.method_68509(null), false, light);
        for (class_2350 dir : class_2350.values()) {
            this.renderFilteredQuads(poseStack, buffer, part.method_68509(dir), false, light);
        }
        float scaleY = this.newIsOpen ? (float)(1.0 + 2.70158 * Math.pow(this.getProgress(nowTick) - 1.0, 3.0) + 1.70158 * Math.pow(this.getProgress(nowTick) - 1.0, 2.0)) : 1.0f - (float)Curves.ease(this.getProgress(nowTick), Curves.Door.DEFAULT);
        float scaleXZ = Math.min(1.0f, scaleY);
        poseStack.method_46416(0.5f, 0.0625f, 0.5f);
        poseStack.method_22905(scaleXZ, scaleY, scaleXZ);
        poseStack.method_46416(-0.5f, -0.0625f, -0.5f);
        this.renderFilteredQuads(poseStack, buffer, part.method_68509(null), true, light);
        for (class_2350 dir : class_2350.values()) {
            this.renderFilteredQuads(poseStack, buffer, part.method_68509(dir), true, light);
        }
    }

    private void renderFilteredQuads(class_4587 poseStack, class_4588 buffer, List<class_777> quads, boolean wantFire, int light) {
        for (class_777 quad : quads) {
            String path = quad.comp_3724().method_45851().method_45816().method_12832();
            if (path.contains("fire_fire") != wantFire) continue;
            buffer.method_22919(poseStack.method_23760(), quad, 1.0f, 1.0f, 1.0f, 1.0f, light, class_4608.field_21444);
        }
    }
}

