/*
 * Decompiled with CFR 0.152.
 */
package fr.madu59.fwa.anims;

import fr.madu59.fwa.anims.Animation;
import fr.madu59.fwa.config.SettingsManager;
import fr.madu59.fwa.utils.Curves;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1058;
import net.minecraft.class_1920;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.minecraft.class_2746;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_4696;
import net.minecraft.class_761;
import net.minecraft.class_7714;
import net.minecraft.class_7833;
import org.joml.Matrix4fc;
import org.joml.Quaternionfc;

@Environment(value=EnvType.CLIENT)
public class ChiseledBookShelfAnimation
extends Animation {
    int pos = 0;
    boolean isAdding;
    class_1058 sprite = class_310.method_1551().method_72703().method_73025(class_2960.method_12829((String)"minecraft:blocks")).method_4608(class_2960.method_12829((String)"minecraft:block/chiseled_bookshelf_occupied"));

    public ChiseledBookShelfAnimation(class_2338 position, class_2680 defaultState, double startTick, boolean oldIsOpen, boolean newIsOpen, class_2680 oldBlockState) {
        super(position, defaultState, startTick, oldIsOpen, newIsOpen);
        for (class_2746 prop : class_7714.field_41308) {
            ++this.pos;
            if (defaultState.method_11654((class_2769)prop) == oldBlockState.method_11654((class_2769)prop)) continue;
            this.isAdding = (Boolean)defaultState.method_11654((class_2769)prop);
            break;
        }
    }

    @Override
    public double getAnimDuration() {
        return 5.0 * SettingsManager.CHISELED_BOOKSHELF_SPEED.getValue();
    }

    @Override
    public <T extends Enum<T>> T getCurve() {
        return (T)((Object)SettingsManager.CHISELED_BOOKSHELF_EASING.getValue());
    }

    @Override
    public boolean isEnabled() {
        return SettingsManager.CHISELED_BOOKSHELF_STATE.getValue();
    }

    @Override
    public boolean isUnique() {
        return false;
    }

    @Override
    public boolean hideOriginalBlock() {
        return false;
    }

    private float getDistance(double nowTick) {
        float max = 0.1875f;
        float min = 0.0625f;
        float progress = (float)Curves.ease(this.getProgress(nowTick), this.getCurve());
        return this.isAdding ? min + (max - min) * progress : max - (max - min) * progress;
    }

    @Override
    public void render(class_4587 poseStack, class_4597.class_4598 bufferSource, double nowTick) {
        class_2350 facing = (class_2350)this.defaultState.method_11654((class_2769)class_7714.field_61990);
        class_4587.class_4665 entry = poseStack.method_23760();
        float w = 0.25f;
        float h = this.pos == 1 || this.pos == 5 ? 0.3125f : 0.375f;
        float d = 0.33333334f;
        float y = this.pos > 3 ? 0.25f : 0.75f;
        float x = 0.1875f + (float)((this.pos - 1) % 3) * 5.0f / 16.0f;
        float z = this.getDistance(nowTick);
        if (facing == class_2350.field_11034) {
            x = 1.0f - x;
            z = 1.0f - z;
        }
        if (facing == class_2350.field_11035 || facing == class_2350.field_11043) {
            float temp = z;
            z = x;
            x = temp;
            if (facing == class_2350.field_11043) {
                z = 1.0f - z;
            }
            if (facing == class_2350.field_11035) {
                x = 1.0f - x;
            }
        }
        poseStack.method_46416(z, y, x);
        poseStack.method_22907((Quaternionfc)class_7833.field_40716.rotationDegrees(-facing.method_10144()));
        poseStack.method_46416(-w / 2.0f, -0.1875f, -d / 2.0f);
        float u1 = 0.0625f + (float)((this.pos - 1) % 3) * 5.0f / 16.0f;
        float u2 = u1 + w;
        float v1 = 1.0f - (y - 0.1875f + h);
        float v2 = v1 + h;
        int light = class_761.method_23794((class_1920)class_310.method_1551().field_1687, (class_2338)this.position.method_10093(facing));
        class_4588 buffer = bufferSource.method_73477(class_4696.method_23683((class_2680)this.defaultState));
        this.writeQuad(entry, buffer, 0.0f, 0.0f, d, 0.0f, h, d, w, h, d, w, 0.0f, d, u1, v1, u2, v2, light, 0.0f, 0.0f, -1.0f);
        this.writeQuad(entry, buffer, w, 0.0f, 0.0f, w, h, 0.0f, 0.0f, h, 0.0f, 0.0f, 0.0f, 0.0f, u1, v1, u2, v2, light, 0.0f, 0.0f, 1.0f);
        this.writeQuad(entry, buffer, 0.0f, h, d, 0.0f, h, 0.0f, w, h, 0.0f, w, h, d, u1, v1, u2, v2, light, 0.0f, -1.0f, 0.0f);
        this.writeQuad(entry, buffer, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, d, w, 0.0f, d, w, 0.0f, 0.0f, u1, v1, u2, v2, light, 0.0f, 1.0f, 0.0f);
        this.writeQuad(entry, buffer, w, 0.0f, d, w, h, d, w, h, 0.0f, w, 0.0f, 0.0f, u1, v1, u2, v2, light, -1.0f, 0.0f, 0.0f);
        this.writeQuad(entry, buffer, 0.0f, 0.0f, 0.0f, 0.0f, h, 0.0f, 0.0f, h, d, 0.0f, 0.0f, d, u1, v1, u2, v2, light, 1.0f, 0.0f, 0.0f);
        poseStack.method_46416(0.0f, 0.0f, 0.0f);
    }

    private void writeQuad(class_4587.class_4665 pose, class_4588 buffer, float x1, float y1, float z1, float x2, float y2, float z2, float x3, float y3, float z3, float x4, float y4, float z4, float uMin, float vMin, float uMax, float vMax, int light, float nx, float ny, float nz) {
        uMin = this.sprite.method_4580(uMin);
        uMax = this.sprite.method_4580(uMax);
        vMin = this.sprite.method_4570(vMin);
        vMax = this.sprite.method_4570(vMax);
        this.vertex(pose, buffer, x1, y1, z1, uMin, vMax, light, nx, ny, nz);
        this.vertex(pose, buffer, x4, y4, z4, uMax, vMax, light, nx, ny, nz);
        this.vertex(pose, buffer, x3, y3, z3, uMax, vMin, light, nx, ny, nz);
        this.vertex(pose, buffer, x2, y2, z2, uMin, vMin, light, nx, ny, nz);
    }

    private void vertex(class_4587.class_4665 pose, class_4588 buffer, float x, float y, float z, float u, float v, int light, float nx, float ny, float nz) {
        buffer.method_22918((Matrix4fc)pose.method_23761(), x, y, z).method_1336(255, 255, 255, 255).method_22913(u, v).method_22922(class_4608.field_21444).method_60803(light).method_22914(nx, ny, nz);
    }
}

