/*
 * Decompiled with CFR 0.152.
 */
package fr.madu59.fwa.anims;

import fr.madu59.fwa.anims.Animation;
import fr.madu59.fwa.config.SettingsManager;
import fr.madu59.fwa.utils.Curves;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1087;
import net.minecraft.class_10889;
import net.minecraft.class_1920;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_310;
import net.minecraft.class_3962;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_4696;
import net.minecraft.class_5819;
import net.minecraft.class_761;
import net.minecraft.class_777;

@Environment(value=EnvType.CLIENT)
public class ComposterAnimation
extends Animation {
    private final class_2680 oldState;
    private final class_2680 newState;
    private final class_5819 random = class_5819.method_43049((long)42L);
    private final class_1087 model;

    public ComposterAnimation(class_2338 position, class_2680 defaultState, double startTick, boolean oldIsOpen, boolean newIsOpen, class_2680 newBlockState, class_2680 oldBlockState) {
        super(position, defaultState, startTick, oldIsOpen, newIsOpen);
        this.newState = newBlockState;
        this.oldState = oldBlockState;
        this.model = class_310.method_1551().method_1541().method_3349(this.newState);
    }

    @Override
    public double getAnimDuration() {
        return 10.0 * SettingsManager.COMPOSTER_SPEED.getValue();
    }

    @Override
    public <T extends Enum<T>> T getCurve() {
        return (T)((Object)SettingsManager.COMPOSTER_EASING.getValue());
    }

    @Override
    public boolean isEnabled() {
        return SettingsManager.COMPOSTER_STATE.getValue();
    }

    private float getPosition(double nowTick, double newPos, double oldPos) {
        return (float)(oldPos - newPos - (oldPos - newPos) * Curves.ease(this.getProgress(nowTick), this.getCurve()));
    }

    private double getHeight(class_2680 state) {
        return Math.min(((double)((Integer)state.method_11654((class_2769)class_3962.field_17565)).intValue() * 2.0 + 1.0) / 16.0, 0.9375);
    }

    @Override
    public void render(class_4587 poseStack, class_4597.class_4598 bufferSource, double nowTick) {
        int light = class_761.method_23794((class_1920)class_310.method_1551().field_1687, (class_2338)this.position);
        class_4588 buffer = bufferSource.method_73477(class_4696.method_23683((class_2680)this.newState));
        List partList = this.model.method_68512(this.random);
        for (class_10889 part : partList) {
            this.renderFilteredQuads(poseStack, buffer, part.method_68509(null), false, light);
            for (class_2350 dir : class_2350.values()) {
                this.renderFilteredQuads(poseStack, buffer, part.method_68509(dir), false, light);
            }
            float dy = this.getPosition(nowTick, this.getHeight(this.newState), this.getHeight(this.oldState));
            poseStack.method_46416(0.0f, dy, 0.0f);
            this.renderFilteredQuads(poseStack, buffer, part.method_68509(null), true, light);
            for (class_2350 dir : class_2350.values()) {
                this.renderFilteredQuads(poseStack, buffer, part.method_68509(dir), true, light);
            }
        }
    }

    private void renderFilteredQuads(class_4587 poseStack, class_4588 buffer, List<class_777> quads, boolean wantCompost, int light) {
        for (class_777 quad : quads) {
            String path = quad.comp_3724().method_45851().method_45816().method_12832();
            if ((path.contains("_compost") || path.contains("_ready")) != wantCompost) continue;
            buffer.method_22919(poseStack.method_23760(), quad, 1.0f, 1.0f, 1.0f, 1.0f, light, class_4608.field_21444);
        }
    }
}

