/*
 * Decompiled with CFR 0.152.
 */
package fr.madu59.fwa.anims;

import fr.madu59.fwa.anims.Animation;
import fr.madu59.fwa.config.SettingsManager;
import fr.madu59.fwa.utils.Curves;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_10444;
import net.minecraft.class_11659;
import net.minecraft.class_11661;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1920;
import net.minecraft.class_1935;
import net.minecraft.class_2338;
import net.minecraft.class_2619;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_761;
import net.minecraft.class_7833;
import net.minecraft.class_811;
import org.joml.Quaternionfc;

@Environment(value=EnvType.CLIENT)
public class JukeBoxAnimation
extends Animation {
    class_2680 newState;
    private final class_10444 discState = new class_10444();
    private final class_310 client = class_310.method_1551();

    public JukeBoxAnimation(class_2338 position, class_2680 defaultState, double startTick, boolean oldIsOpen, boolean newIsOpen, class_2680 newState) {
        super(position, defaultState, startTick, oldIsOpen, newIsOpen);
        this.newState = newState;
    }

    @Override
    public double getAnimDuration() {
        return 10.0 * SettingsManager.JUKEBOX_SPEED.getValue();
    }

    @Override
    public double getLifeSpan() {
        return JukeBoxAnimation.hasInfiniteAnimation() ? Double.MAX_VALUE : this.getAnimDuration();
    }

    @Override
    public <T extends Enum<T>> T getCurve() {
        return (T)((Object)SettingsManager.JUKEBOX_EASING.getValue());
    }

    @Override
    public boolean isEnabled() {
        return SettingsManager.JUKEBOX_STATE.getValue();
    }

    public static boolean hasInfiniteAnimation() {
        return SettingsManager.JUKEBOX_INFINITE.getValue();
    }

    @Override
    public boolean hideOriginalBlock() {
        return false;
    }

    private float getDeltaY(double nowTick) {
        float progress = (float)Curves.ease(this.getProgress(nowTick), this.getCurve());
        if (JukeBoxAnimation.hasInfiniteAnimation()) {
            return 3.0f * progress / 4.0f;
        }
        return progress;
    }

    @Override
    public void render(class_4587 poseStack, class_4597.class_4598 bufferSource, double nowTick) {
        float scale = 0.67f;
        class_2619 jukeboxBlockEntity = (class_2619)this.client.field_1687.method_8321(this.position);
        class_1799 discItemStack = new class_1799((class_1935)class_1802.field_8144);
        if (jukeboxBlockEntity != null && (discItemStack = jukeboxBlockEntity.method_54079()).method_7960()) {
            discItemStack = new class_1799((class_1935)class_1802.field_8144);
        }
        int light = class_761.method_23794((class_1920)this.client.field_1687, (class_2338)this.position.method_10084());
        float dy = this.getDeltaY(nowTick);
        dy = this.newIsOpen ? 1.0f - dy : dy;
        poseStack.method_22907((Quaternionfc)class_7833.field_40716.rotationDegrees(90.0f));
        poseStack.method_22905(scale, scale, 1.0f);
        poseStack.method_46416(-0.71875f, 1.1875f + dy, 0.5f);
        this.client.method_65386().method_65598(this.discState, discItemStack, class_811.field_61988, this.client.field_1724.method_73183(), null, this.position.hashCode());
        class_11661 submitNodeCollector = this.client.field_1773.method_72910();
        this.discState.method_65604(poseStack, (class_11659)submitNodeCollector, light, class_4608.field_21444, 0);
    }
}

