/*
 * Decompiled with CFR 0.152.
 */
package fr.madu59.fwa;

import fr.madu59.fwa.Animations;
import fr.madu59.fwa.anims.Animation;
import fr.madu59.fwa.anims.BellAnimation;
import fr.madu59.fwa.anims.ButtonAnimation;
import fr.madu59.fwa.anims.CampfireAnimation;
import fr.madu59.fwa.anims.ChiseledBookShelfAnimation;
import fr.madu59.fwa.anims.ComposterAnimation;
import fr.madu59.fwa.anims.DoorAnimation;
import fr.madu59.fwa.anims.EndPortalFrameAnimation;
import fr.madu59.fwa.anims.FenceGateAnimation;
import fr.madu59.fwa.anims.JukeBoxAnimation;
import fr.madu59.fwa.anims.LayeredCauldronAnimation;
import fr.madu59.fwa.anims.LecternAnimation;
import fr.madu59.fwa.anims.LeverAnimation;
import fr.madu59.fwa.anims.RepeaterAnimation;
import fr.madu59.fwa.anims.TrapDoorAnimation;
import fr.madu59.fwa.anims.TripWireHookAnimation;
import fr.madu59.fwa.config.SettingsManager;
import fr.madu59.fwa.config.configscreen.FancyWorldAnimationsConfigScreen;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.rendering.v1.world.WorldRenderContext;
import net.fabricmc.fabric.api.client.rendering.v1.world.WorldRenderEvents;
import net.minecraft.class_2248;
import net.minecraft.class_2269;
import net.minecraft.class_2323;
import net.minecraft.class_2333;
import net.minecraft.class_2338;
import net.minecraft.class_2349;
import net.minecraft.class_2387;
import net.minecraft.class_2401;
import net.minecraft.class_243;
import net.minecraft.class_2462;
import net.minecraft.class_2533;
import net.minecraft.class_2537;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_310;
import net.minecraft.class_3709;
import net.minecraft.class_3715;
import net.minecraft.class_3922;
import net.minecraft.class_3962;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_5546;
import net.minecraft.class_5553;
import net.minecraft.class_5556;
import net.minecraft.class_7714;

@Environment(value=EnvType.CLIENT)
public class FancyWorldAnimationsClient
implements ClientModInitializer {
    public static final class_310 client = class_310.method_1551();
    private static final Animations animations = new Animations();

    public void onInitializeClient() {
        FancyWorldAnimationsConfigScreen.registerCommand();
        WorldRenderEvents.AFTER_ENTITIES.register(context -> {
            double tickDelta = FancyWorldAnimationsClient.getPartialTick();
            FancyWorldAnimationsClient.render(context, tickDelta);
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void onBlockUpdate(class_2338 blockPos, class_2680 oldState, class_2680 newState) {
        if (FancyWorldAnimationsClient.client.field_1687 == null) {
            return;
        }
        Type type = FancyWorldAnimationsClient.typeOf(oldState, newState);
        if (type == Type.USELESS) {
            Animations animations = FancyWorldAnimationsClient.animations;
            synchronized (animations) {
                FancyWorldAnimationsClient.animations.removeAt(blockPos);
            }
            return;
        }
        if (!FancyWorldAnimationsClient.isSameType(type, newState)) {
            Animations animations = FancyWorldAnimationsClient.animations;
            synchronized (animations) {
                FancyWorldAnimationsClient.animations.removeAt(blockPos);
            }
            return;
        }
        boolean oldIsOpen = FancyWorldAnimationsClient.isOpen(oldState);
        boolean newIsOpen = FancyWorldAnimationsClient.isOpen(newState);
        double startTick = FancyWorldAnimationsClient.client.field_1687.method_8510();
        Animations animations = FancyWorldAnimationsClient.animations;
        synchronized (animations) {
            Animation animation;
            if (FancyWorldAnimationsClient.animations.containsAt(blockPos) && (animation = FancyWorldAnimationsClient.animations.getAt(blockPos)).isUnique()) {
                startTick = (double)FancyWorldAnimationsClient.client.field_1687.method_8510() - animation.getAnimDuration() * (1.0 - animation.getProgress(FancyWorldAnimationsClient.getPartialTick()));
                FancyWorldAnimationsClient.animations.removeAt(blockPos);
            }
            if (!FancyWorldAnimationsClient.shouldStartAnimation(oldIsOpen, newIsOpen, type, oldState, newState)) {
                return;
            }
            animation = FancyWorldAnimationsClient.createAnimation(blockPos, type, FancyWorldAnimationsClient.getDefaultState(newState, type), startTick, oldIsOpen, newIsOpen, oldState, newState);
            if (animation.isEnabled()) {
                FancyWorldAnimationsClient.animations.add(blockPos, animation);
            }
        }
    }

    private static double getPartialTick() {
        return (double)FancyWorldAnimationsClient.client.field_1687.method_8510() + (double)Math.clamp(client.method_61966().method_60637(true), 0.0f, 1.0f);
    }

    private static void render(WorldRenderContext context, double nowTick) {
        if (animations.isEmpty() || FancyWorldAnimationsClient.client.field_1687 == null) {
            return;
        }
        class_243 cameraPos = FancyWorldAnimationsClient.client.field_1773.method_19418().method_71156();
        class_4587 poseStack = context.matrices();
        class_4597.class_4598 bufferSource = client.method_22940().method_23000();
        for (Animation animation : FancyWorldAnimationsClient.animations.animations.values()) {
            FancyWorldAnimationsClient.renderAnimation(animation, nowTick, cameraPos, poseStack, bufferSource);
        }
        bufferSource.method_22993();
        animations.clean(nowTick);
    }

    private static boolean shouldStartAnimation(boolean oldIsOpen, boolean newIsOpen, Type type, class_2680 oldState, class_2680 newState) {
        if (type == Type.END_PORTAL_FRAME && SettingsManager.END_PORTAL_FRAME_INFINITE.getValue().booleanValue()) {
            return true;
        }
        if (type == Type.CHISELED_BOOKSHELF) {
            return oldState.method_26204() == newState.method_26204();
        }
        if (type == Type.JUKEBOX) {
            return (Boolean)newState.method_11654((class_2769)class_2387.field_11180);
        }
        if (type == Type.REPEATER) {
            return oldState.method_26204() == newState.method_26204() && newState.method_11654((class_2769)class_2462.field_11451) != oldState.method_11654((class_2769)class_2462.field_11451);
        }
        if (type == Type.LAYERED_CAULDRON) {
            if (oldState.method_26204() == newState.method_26204() && newState.method_26204() instanceof class_5556 && newState.method_11654((class_2769)class_5556.field_27206) != oldState.method_11654((class_2769)class_5556.field_27206)) {
                return true;
            }
            if (oldState.method_26204() != newState.method_26204() && newState.method_26204() instanceof class_5556 && oldState.method_26204() instanceof class_5546 || oldState.method_26204() instanceof class_5556 && newState.method_26204() instanceof class_5546) {
                return true;
            }
            return oldState.method_26204() != newState.method_26204() && (newState.method_26204() instanceof class_5553 && oldState.method_26204() instanceof class_5546 || oldState.method_26204() instanceof class_5553 && newState.method_26204() instanceof class_5546);
        }
        if (type == Type.COMPOSTER) {
            return oldState.method_26204() == newState.method_26204() && newState.method_26204() instanceof class_3962 && newState.method_11654((class_2769)class_3962.field_17565) != oldState.method_11654((class_2769)class_3962.field_17565);
        }
        return oldIsOpen != newIsOpen;
    }

    private static void renderAnimation(Animation animation, double nowTick, class_243 cameraPos, class_4587 poseStack, class_4597.class_4598 bufferSource) {
        class_2338 pos = animation.getPos();
        poseStack.method_22903();
        poseStack.method_22904((double)pos.method_10263() - cameraPos.field_1352, (double)pos.method_10264() - cameraPos.field_1351, (double)pos.method_10260() - cameraPos.field_1350);
        animation.render(poseStack, bufferSource, nowTick);
        poseStack.method_22909();
    }

    private static boolean isOpen(class_2680 state) {
        class_2248 block = state.method_26204();
        if (block instanceof class_2323) {
            return (Boolean)state.method_11654((class_2769)class_2323.field_10945);
        }
        if (block instanceof class_2533) {
            return (Boolean)state.method_11654((class_2769)class_2533.field_11631);
        }
        if (block instanceof class_2349) {
            return (Boolean)state.method_11654((class_2769)class_2349.field_11026);
        }
        if (block instanceof class_2401) {
            return (Boolean)state.method_11654((class_2769)class_2401.field_11265);
        }
        if (block instanceof class_3715) {
            return (Boolean)state.method_11654((class_2769)class_3715.field_17366);
        }
        if (block instanceof class_2269) {
            return (Boolean)state.method_11654((class_2769)class_2269.field_10729);
        }
        if (block instanceof class_2387) {
            return (Boolean)state.method_11654((class_2769)class_2387.field_11180);
        }
        if (block instanceof class_2333) {
            return (Boolean)state.method_11654((class_2769)class_2333.field_10958);
        }
        if (block instanceof class_3709) {
            return true;
        }
        if (block instanceof class_3922) {
            return (Boolean)state.method_11654((class_2769)class_3922.field_17352);
        }
        if (block instanceof class_2537) {
            return (Boolean)state.method_11654((class_2769)class_2537.field_11669);
        }
        return false;
    }

    private static class_2680 getDefaultState(class_2680 state, Type type) {
        return switch (type.ordinal()) {
            case 0 -> (class_2680)state.method_11657((class_2769)class_2323.field_10945, (Comparable)Boolean.valueOf(false));
            case 1 -> (class_2680)state.method_11657((class_2769)class_2533.field_11631, (Comparable)Boolean.valueOf(false));
            case 2 -> (class_2680)state.method_11657((class_2769)class_2349.field_11026, (Comparable)Boolean.valueOf(false));
            case 3 -> (class_2680)state.method_11657((class_2769)class_2401.field_11265, (Comparable)Boolean.valueOf(false));
            case 5 -> (class_2680)state.method_11657((class_2769)class_3715.field_17366, (Comparable)Boolean.valueOf(false));
            case 6 -> (class_2680)state.method_11657((class_2769)class_2269.field_10729, (Comparable)Boolean.valueOf(false));
            case 7 -> (class_2680)state.method_11657((class_2769)class_2387.field_11180, (Comparable)Boolean.valueOf(false));
            case 8 -> (class_2680)state.method_11657((class_2769)class_2333.field_10958, (Comparable)Boolean.valueOf(false));
            case 9 -> (class_2680)state.method_11657((class_2769)class_2462.field_11451, (Comparable)Integer.valueOf(1));
            case 12 -> (class_2680)state.method_11657((class_2769)class_3922.field_17352, (Comparable)Boolean.valueOf(false));
            case 14 -> (class_2680)state.method_11657((class_2769)class_2537.field_11669, (Comparable)Boolean.valueOf(false));
            default -> state;
        };
    }

    private static Animation createAnimation(class_2338 pos, Type type, class_2680 defaultState, double startTick, boolean oldIsOpen, boolean newIsOpen, class_2680 oldState, class_2680 newState) {
        switch (type.ordinal()) {
            case 0: {
                return new DoorAnimation(pos, defaultState, startTick, oldIsOpen, newIsOpen);
            }
            case 1: {
                return new TrapDoorAnimation(pos, defaultState, startTick, oldIsOpen, newIsOpen);
            }
            case 2: {
                return new FenceGateAnimation(pos, defaultState, startTick, oldIsOpen, newIsOpen);
            }
            case 3: {
                return new LeverAnimation(pos, defaultState, startTick, oldIsOpen, newIsOpen);
            }
            case 4: {
                return new ChiseledBookShelfAnimation(pos, newState, startTick, oldIsOpen, newIsOpen, oldState);
            }
            case 5: {
                return new LecternAnimation(pos, defaultState, startTick, oldIsOpen, newIsOpen);
            }
            case 6: {
                return new ButtonAnimation(pos, defaultState, startTick, oldIsOpen, newIsOpen);
            }
            case 7: {
                return new JukeBoxAnimation(pos, defaultState, startTick, oldIsOpen, newIsOpen, newState);
            }
            case 8: {
                return new EndPortalFrameAnimation(pos, defaultState, startTick, oldIsOpen, newIsOpen);
            }
            case 9: {
                return new RepeaterAnimation(pos, defaultState, startTick, oldIsOpen, newIsOpen, newState, oldState);
            }
            case 10: {
                return new LayeredCauldronAnimation(pos, defaultState, startTick, oldIsOpen, newIsOpen, newState, oldState);
            }
            case 11: {
                return new BellAnimation(pos, defaultState, startTick, oldIsOpen, newIsOpen);
            }
            case 12: {
                return new CampfireAnimation(pos, defaultState, startTick, oldIsOpen, newIsOpen, oldState, newState);
            }
            case 13: {
                return new ComposterAnimation(pos, defaultState, startTick, oldIsOpen, newIsOpen, newState, oldState);
            }
            case 14: {
                return new TripWireHookAnimation(pos, defaultState, startTick, oldIsOpen, newIsOpen);
            }
        }
        return new Animation(pos, defaultState, startTick, oldIsOpen, newIsOpen);
    }

    private static Type typeOf(class_2680 state) {
        class_2248 block = state.method_26204();
        if (block instanceof class_2323) {
            return Type.DOOR;
        }
        if (block instanceof class_2533) {
            return Type.TRAPDOOR;
        }
        if (block instanceof class_2349) {
            return Type.FENCE_GATE;
        }
        if (block instanceof class_2401) {
            return Type.LEVER;
        }
        if (block instanceof class_7714) {
            return Type.CHISELED_BOOKSHELF;
        }
        if (block instanceof class_3715) {
            return Type.LECTERN;
        }
        if (block instanceof class_2269) {
            return Type.BUTTON;
        }
        if (block instanceof class_2387) {
            return Type.JUKEBOX;
        }
        if (block instanceof class_2333) {
            return Type.END_PORTAL_FRAME;
        }
        if (block instanceof class_2462) {
            return Type.REPEATER;
        }
        if (block instanceof class_5556 || block instanceof class_5546 || block instanceof class_5553) {
            return Type.LAYERED_CAULDRON;
        }
        if (block instanceof class_3709) {
            return Type.BELL;
        }
        if (block instanceof class_3922) {
            return Type.CAMPFIRE;
        }
        if (block instanceof class_3962) {
            return Type.COMPOSTER;
        }
        return Type.USELESS;
    }

    private static Type typeOf(class_2680 oldState, class_2680 newState) {
        Type type = FancyWorldAnimationsClient.typeOf(oldState);
        if (type != Type.USELESS) {
            return type;
        }
        return FancyWorldAnimationsClient.typeOf(newState);
    }

    private static boolean isSameType(Type type, class_2680 state) {
        return type == FancyWorldAnimationsClient.typeOf(state);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean shouldCancelBlockEntityRendering(class_2338 pos) {
        Animations animations = FancyWorldAnimationsClient.animations;
        synchronized (animations) {
            if (FancyWorldAnimationsClient.animations.containsAt(pos)) {
                Animation animation = FancyWorldAnimationsClient.animations.getAt(pos);
                return animation.hideOriginalBlockEntity();
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean shouldCancelBlockRendering(class_2338 pos) {
        Animations animations = FancyWorldAnimationsClient.animations;
        synchronized (animations) {
            if (FancyWorldAnimationsClient.animations.containsAt(pos)) {
                Animation animation = FancyWorldAnimationsClient.animations.getAt(pos);
                return animation.hideOriginalBlock();
            }
            return false;
        }
    }

    @Environment(value=EnvType.CLIENT)
    public static enum Type {
        DOOR,
        TRAPDOOR,
        FENCE_GATE,
        LEVER,
        CHISELED_BOOKSHELF,
        LECTERN,
        BUTTON,
        JUKEBOX,
        END_PORTAL_FRAME,
        REPEATER,
        LAYERED_CAULDRON,
        BELL,
        CAMPFIRE,
        COMPOSTER,
        TRIPWIRE_HOOK,
        USELESS;

    }
}

