/*
 * Decompiled with CFR 0.152.
 */
package fr.madu59.fwa.anims;

import fr.madu59.fwa.anims.Animation;
import fr.madu59.fwa.config.SettingsManager;
import fr.madu59.fwa.utils.Curves;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1920;
import net.minecraft.class_1922;
import net.minecraft.class_2323;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2680;
import net.minecraft.class_2750;
import net.minecraft.class_2769;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_761;
import net.minecraft.class_7833;
import org.joml.Quaternionfc;

@Environment(value=EnvType.CLIENT)
public class DoorAnimation
extends Animation {
    public DoorAnimation(class_2338 position, class_2680 defaultState, double startTick, boolean oldIsOpen, boolean newIsOpen) {
        super(position, defaultState, startTick, oldIsOpen, newIsOpen);
    }

    @Override
    public double getAnimDuration() {
        return 10.0 * SettingsManager.DOOR_SPEED.getValue();
    }

    @Override
    public <T extends Enum<T>> T getCurve() {
        return (T)((Object)SettingsManager.DOOR_EASING.getValue());
    }

    @Override
    public boolean isEnabled() {
        return SettingsManager.DOOR_STATE.getValue();
    }

    private double getStartAngle(boolean isOpen, class_2750 hinge) {
        if (!isOpen) {
            return 0.0;
        }
        return hinge == class_2750.field_12586 ? -90.0 : 90.0;
    }

    private double getAngle(double nowTick, class_2750 hinge) {
        double angle1 = this.getStartAngle(this.oldIsOpen, hinge);
        double angle2 = this.getStartAngle(this.newIsOpen, hinge);
        return angle1 + (angle2 - angle1) * Curves.ease(this.getProgress(nowTick), this.getCurve());
    }

    @Override
    public void render(class_4587 poseStack, class_4597.class_4598 bufferSource, double nowTick) {
        class_2350 facing = (class_2350)this.defaultState.method_11654((class_2769)class_2323.field_10938);
        class_2750 hinge = (class_2750)this.defaultState.method_11654((class_2769)class_2323.field_10941);
        class_2350 hingeSide = hinge == class_2750.field_12586 ? facing.method_35833(class_2350.class_2351.field_11052) : facing.method_35834(class_2350.class_2351.field_11052);
        class_238 boundingBox = this.defaultState.method_26218((class_1922)class_310.method_1551().field_1687, class_2338.field_10980).method_1107();
        float pivotX = (float)((boundingBox.field_1323 + boundingBox.field_1320) * 0.5);
        float pivotZ = (float)((boundingBox.field_1321 + boundingBox.field_1324) * 0.5);
        switch (hingeSide) {
            case field_11034: {
                pivotX = (float)boundingBox.field_1320;
                break;
            }
            case field_11039: {
                pivotX = (float)boundingBox.field_1323;
                break;
            }
            case field_11035: {
                pivotZ = (float)boundingBox.field_1324;
                break;
            }
            case field_11043: {
                pivotZ = (float)boundingBox.field_1321;
                break;
            }
        }
        float thickness = facing == class_2350.field_11043 || facing == class_2350.field_11035 ? (float)(boundingBox.field_1324 - boundingBox.field_1321) : (float)(boundingBox.field_1320 - boundingBox.field_1323);
        float dX = 0.0f;
        float dZ = 0.0f;
        switch (facing) {
            case field_11043: {
                dZ = thickness * 0.5f;
                break;
            }
            case field_11035: {
                dZ = -thickness * 0.5f;
                break;
            }
            case field_11039: {
                dX = thickness * 0.5f;
                break;
            }
            case field_11034: {
                dX = -thickness * 0.5f;
                break;
            }
        }
        double angle = this.getAngle(nowTick, hinge);
        double rad = Math.toRadians(angle);
        float cos = (float)Math.cos(rad);
        float sin = (float)Math.sin(rad);
        float rotDX = dX * cos - dZ * sin;
        float rotDZ = dX * sin + dZ * cos;
        float shiftX = dX - rotDX;
        float shiftZ = dZ - rotDZ;
        poseStack.method_46416(shiftX, 0.0f, shiftZ);
        poseStack.method_46416(pivotX, 0.0f, pivotZ);
        poseStack.method_22907((Quaternionfc)class_7833.field_40716.rotationDegrees((float)angle));
        poseStack.method_46416(-pivotX, 0.0f, -pivotZ);
        int light = class_761.method_23794((class_1920)class_310.method_1551().field_1687, (class_2338)this.position);
        class_310.method_1551().method_1541().method_3353(this.defaultState, poseStack, (class_4597)bufferSource, light, class_4608.field_21444);
    }
}

