/*
 * Decompiled with CFR 0.152.
 */
package fr.madu59.fwa.anims;

import fr.madu59.fwa.anims.Animation;
import fr.madu59.fwa.config.SettingsManager;
import fr.madu59.fwa.utils.Curves;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1087;
import net.minecraft.class_10889;
import net.minecraft.class_1920;
import net.minecraft.class_1921;
import net.minecraft.class_2333;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_4696;
import net.minecraft.class_5819;
import net.minecraft.class_761;
import net.minecraft.class_777;

@Environment(value=EnvType.CLIENT)
public class EndPortalFrameAnimation
extends Animation {
    private final class_5819 random = class_5819.method_43049((long)42L);

    public EndPortalFrameAnimation(class_2338 position, class_2680 defaultState, double startTick, boolean oldIsOpen, boolean newIsOpen) {
        super(position, defaultState, startTick, oldIsOpen, newIsOpen);
    }

    @Override
    public double getAnimDuration() {
        return 10.0 * SettingsManager.END_PORTAL_FRAME_SPEED.getValue();
    }

    @Override
    public <T extends Enum<T>> T getCurve() {
        return (T)((Object)SettingsManager.END_PORTAL_FRAME_EASING.getValue());
    }

    @Override
    public boolean isEnabled() {
        return SettingsManager.END_PORTAL_FRAME_STATE.getValue();
    }

    @Override
    public boolean hideOriginalBlock() {
        return this.newIsOpen;
    }

    public static boolean hasInfiniteAnimation() {
        return SettingsManager.END_PORTAL_FRAME_INFINITE.getValue();
    }

    @Override
    public double getLifeSpan() {
        return !EndPortalFrameAnimation.hasInfiniteAnimation() || this.newIsOpen ? this.getAnimDuration() : Double.MAX_VALUE;
    }

    @Override
    public void render(class_4587 poseStack, class_4597.class_4598 bufferSource, double nowTick) {
        int light = class_761.method_23794((class_1920)class_310.method_1551().field_1687, (class_2338)this.position);
        class_2680 eyeState = (class_2680)this.defaultState.method_11657((class_2769)class_2333.field_10958, (Comparable)Boolean.valueOf(true));
        class_1087 model = class_310.method_1551().method_1541().method_3349(eyeState);
        class_10889 part = (class_10889)model.method_68512(this.random).get(0);
        if (this.newIsOpen) {
            class_4588 buffer = bufferSource.method_73477(class_4696.method_23683((class_2680)eyeState));
            class_310.method_1551().method_1541().method_3353(this.defaultState, poseStack, (class_4597)bufferSource, light, class_4608.field_21444);
            poseStack.method_46416(0.0f, 0.25f - (float)Curves.ease(this.getProgress(nowTick), this.getCurve()) / 4.0f, 0.0f);
            this.renderFilteredQuads(poseStack, buffer, part.method_68509(null), true, light, 1.0f, 1.0f, 1.0f, 1.0f);
            for (class_2350 dir : class_2350.values()) {
                this.renderFilteredQuads(poseStack, buffer, part.method_68509(dir), true, light, 1.0f, 1.0f, 1.0f, 1.0f);
            }
        } else {
            class_4588 buffer = bufferSource.method_73477(class_1921.method_29380());
            float time = (float)(nowTick - this.startTick);
            float alpha = 0.1f + Math.abs((float)Math.sin((double)time * 0.07)) * 0.3f;
            this.renderFilteredQuads(poseStack, buffer, part.method_68509(null), true, light, 0.0f, 1.0f, 0.0f, alpha);
            for (class_2350 dir : class_2350.values()) {
                this.renderFilteredQuads(poseStack, buffer, part.method_68509(dir), true, light, 0.0f, 1.0f, 0.0f, alpha);
            }
        }
    }

    private void renderFilteredQuads(class_4587 poseStack, class_4588 buffer, List<class_777> quads, boolean wantEye, int light, float r, float g, float b, float a) {
        for (class_777 quad : quads) {
            String path = quad.comp_3724().method_45851().method_45816().method_12832();
            if (path.contains("eye") != wantEye) continue;
            buffer.method_22919(poseStack.method_23760(), quad, r, g, b, a, light, class_4608.field_21444);
        }
    }
}

