/*
 * Decompiled with CFR 0.152.
 */
package fr.madu59.fwa.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import fr.madu59.fwa.FancyWorldAnimations;
import fr.madu59.fwa.config.Option;
import fr.madu59.fwa.utils.Curves;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Type;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.loader.api.FabricLoader;

@Environment(value=EnvType.CLIENT)
public class SettingsManager {
    public static List<Option<?>> ALL_OPTIONS = new ArrayList();
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final Path CONFIG_PATH = FabricLoader.getInstance().getConfigDir().resolve("fwa.json");
    private static Map<String, String> loadedSettings = SettingsManager.loadSettings();
    public static Option<Boolean> MOD_TOGGLE = SettingsManager.loadOptionWithDefaults("mod_toggle", "fwa.config.option.mod_toggle.name", "fwa.config.option.toggle_name.description", true);
    public static Option<Boolean> DOOR_STATE = SettingsManager.loadOptionWithDefaults("door_state", "fwa.config.option.state.name", "fwa.config.option.state.description", true);
    public static Option<Curves.Door> DOOR_EASING = SettingsManager.loadOptionWithDefaults("door_easing", "fwa.config.option.easing.name", "fwa.config.option.easing.description", Curves.Door.DEFAULT);
    public static Option<Double> DOOR_SPEED = SettingsManager.loadOptionWithDefaults("door_speed", "fwa.config.option.speed.name", "fwa.config.option.speed.description", 1.0);
    public static Option<Boolean> TRAPDOOR_STATE = SettingsManager.loadOptionWithDefaults("trapdoor_state", "fwa.config.option.state.name", "fwa.config.option.state.description", true);
    public static Option<Curves.Door> TRAPDOOR_EASING = SettingsManager.loadOptionWithDefaults("trapdoor_easing", "fwa.config.option.easing.name", "fwa.config.option.easing.description", Curves.Door.DEFAULT);
    public static Option<Double> TRAPDOOR_SPEED = SettingsManager.loadOptionWithDefaults("trapdoor_speed", "fwa.config.option.speed.name", "fwa.config.option.speed.description", 1.0);
    public static Option<Boolean> FENCEGATE_STATE = SettingsManager.loadOptionWithDefaults("fencegate_state", "fwa.config.option.state.name", "fwa.config.option.state.description", true);
    public static Option<Curves.Door> FENCEGATE_EASING = SettingsManager.loadOptionWithDefaults("fencegate_easing", "fwa.config.option.easing.name", "fwa.config.option.easing.description", Curves.Door.SPRINGY);
    public static Option<Double> FENCEGATE_SPEED = SettingsManager.loadOptionWithDefaults("fencegate_speed", "fwa.config.option.speed.name", "fwa.config.option.speed.description", 1.0);
    public static Option<Boolean> LEVER_STATE = SettingsManager.loadOptionWithDefaults("lever_state", "fwa.config.option.state.name", "fwa.config.option.state.description", true);
    public static Option<Curves.Door> LEVER_EASING = SettingsManager.loadOptionWithDefaults("lever_easing", "fwa.config.option.easing.name", "fwa.config.option.easing.description", Curves.Door.LINEAR);
    public static Option<Double> LEVER_SPEED = SettingsManager.loadOptionWithDefaults("lever_speed", "fwa.config.option.speed.name", "fwa.config.option.speed.description", 1.0);
    public static Option<Boolean> LECTERN_STATE = SettingsManager.loadOptionWithDefaults("lectern_state", "fwa.config.option.state.name", "fwa.config.option.state.description", true);
    public static Option<Curves.Door> LECTERN_EASING = SettingsManager.loadOptionWithDefaults("lectern_easing", "fwa.config.option.easing.name", "fwa.config.option.easing.description", Curves.Door.DEFAULT);
    public static Option<Double> LECTERN_SPEED = SettingsManager.loadOptionWithDefaults("lectern_speed", "fwa.config.option.speed.name", "fwa.config.option.speed.description", 1.0);
    public static Option<Boolean> LECTERN_INFINITE = SettingsManager.loadOptionWithDefaults("lectern_infinite", "fwa.config.option.infinite.name", "fwa.config.option.infinite.description", true);
    public static Option<Boolean> JUKEBOX_STATE = SettingsManager.loadOptionWithDefaults("jukebox_state", "fwa.config.option.state.name", "fwa.config.option.state.description", true);
    public static Option<Curves.Door> JUKEBOX_EASING = SettingsManager.loadOptionWithDefaults("jukebox_easing", "fwa.config.option.easing.name", "fwa.config.option.easing.description", Curves.Door.DEFAULT);
    public static Option<Double> JUKEBOX_SPEED = SettingsManager.loadOptionWithDefaults("jukebox_speed", "fwa.config.option.speed.name", "fwa.config.option.speed.description", 1.0);
    public static Option<Boolean> JUKEBOX_INFINITE = SettingsManager.loadOptionWithDefaults("lectern_infinite", "fwa.config.option.infinite.name", "fwa.config.option.infinite.description", true);
    public static Option<Boolean> BELL_STATE = SettingsManager.loadOptionWithDefaults("bell_state", "fwa.config.option.state.name", "fwa.config.option.state.description", true);
    public static Option<Double> BELL_SPEED = SettingsManager.loadOptionWithDefaults("bell_speed", "fwa.config.option.speed.name", "fwa.config.option.speed.description", 1.0);
    public static Option<Boolean> BELL_INFINITE = SettingsManager.loadOptionWithDefaults("bell_infinite", "fwa.config.option.infinite.name", "fwa.config.option.infinite.description", true);
    public static Option<Boolean> CHISELED_BOOKSHELF_STATE = SettingsManager.loadOptionWithDefaults("chiseled_bookshelf_state", "fwa.config.option.state.name", "fwa.config.option.state.description", true);
    public static Option<Curves.Door> CHISELED_BOOKSHELF_EASING = SettingsManager.loadOptionWithDefaults("chiseled_bookshelf_easing", "fwa.config.option.easing.name", "fwa.config.option.easing.description", Curves.Door.LINEAR);
    public static Option<Double> CHISELED_BOOKSHELF_SPEED = SettingsManager.loadOptionWithDefaults("chiseled_bookshelf_speed", "fwa.config.option.speed.name", "fwa.config.option.speed.description", 1.0);
    public static Option<Boolean> CAULDRON_STATE = SettingsManager.loadOptionWithDefaults("cauldron_state", "fwa.config.option.state.name", "fwa.config.option.state.description", true);
    public static Option<Curves.Door> CAULDRON_EASING = SettingsManager.loadOptionWithDefaults("cauldron_easing", "fwa.config.option.easing.name", "fwa.config.option.easing.description", Curves.Door.SPRINGY);
    public static Option<Double> CAULDRON_SPEED = SettingsManager.loadOptionWithDefaults("cauldron_speed", "fwa.config.option.speed.name", "fwa.config.option.speed.description", 1.0);
    public static Option<Boolean> COMPOSTER_STATE = SettingsManager.loadOptionWithDefaults("composter_state", "fwa.config.option.state.name", "fwa.config.option.state.description", true);
    public static Option<Curves.Door> COMPOSTER_EASING = SettingsManager.loadOptionWithDefaults("composter_easing", "fwa.config.option.easing.name", "fwa.config.option.easing.description", Curves.Door.SPRINGY);
    public static Option<Double> COMPOSTER_SPEED = SettingsManager.loadOptionWithDefaults("composter_speed", "fwa.config.option.speed.name", "fwa.config.option.speed.description", 1.0);
    public static Option<Boolean> BUTTON_STATE = SettingsManager.loadOptionWithDefaults("button_state", "fwa.config.option.state.name", "fwa.config.option.state.description", true);
    public static Option<Curves.Door> BUTTON_EASING = SettingsManager.loadOptionWithDefaults("button_easing", "fwa.config.option.easing.name", "fwa.config.option.easing.description", Curves.Door.LINEAR);
    public static Option<Double> BUTTON_SPEED = SettingsManager.loadOptionWithDefaults("button_speed", "fwa.config.option.speed.name", "fwa.config.option.speed.description", 1.0);
    public static Option<Boolean> REPEATER_STATE = SettingsManager.loadOptionWithDefaults("repeater_state", "fwa.config.option.state.name", "fwa.config.option.state.description", true);
    public static Option<Curves.Door> REPEATER_EASING = SettingsManager.loadOptionWithDefaults("repeater_easing", "fwa.config.option.easing.name", "fwa.config.option.easing.description", Curves.Door.SPRINGY);
    public static Option<Double> REPEATER_SPEED = SettingsManager.loadOptionWithDefaults("repeater_speed", "fwa.config.option.speed.name", "fwa.config.option.speed.description", 1.0);
    public static Option<Boolean> END_PORTAL_FRAME_STATE = SettingsManager.loadOptionWithDefaults("end_portal_frame_state", "fwa.config.option.state.name", "fwa.config.option.state.description", true);
    public static Option<Curves.Door> END_PORTAL_FRAME_EASING = SettingsManager.loadOptionWithDefaults("end_portal_frame_easing", "fwa.config.option.easing.name", "fwa.config.option.easing.description", Curves.Door.DEFAULT);
    public static Option<Double> END_PORTAL_FRAME_SPEED = SettingsManager.loadOptionWithDefaults("end_portal_frame_speed", "fwa.config.option.speed.name", "fwa.config.option.speed.description", 1.0);
    public static Option<Boolean> END_PORTAL_FRAME_INFINITE = SettingsManager.loadOptionWithDefaults("end_portal_frame_infinite", "fwa.config.option.infinite.name", "fwa.config.option.infinite.description", true);
    public static Option<Boolean> CAMPFIRE_STATE = SettingsManager.loadOptionWithDefaults("campfire_state", "fwa.config.option.state.name", "fwa.config.option.state.description", true);
    public static Option<Double> CAMPFIRE_SPEED = SettingsManager.loadOptionWithDefaults("campfire_speed", "fwa.config.option.speed.name", "fwa.config.option.speed.description", 1.0);
    public static Option<Curves.Door> CHEST_EASING = SettingsManager.loadOptionWithDefaults("chest_easing", "fwa.config.option.easing.name", "fwa.config.option.easing.description", Curves.Door.SPRINGY);

    public static void saveSettings(List<Option<?>> options) {
        Map<String, String> map = SettingsManager.toMap(options);
        try {
            Files.createDirectories(CONFIG_PATH.getParent(), new FileAttribute[0]);
            try (BufferedWriter writer = Files.newBufferedWriter(CONFIG_PATH, new OpenOption[0]);){
                GSON.toJson(map, (Appendable)writer);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static Map<String, String> toMap(List<Option<?>> options) {
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        for (Option<?> option : options) {
            if (option.getValue() == option.getDefaultValue()) continue;
            map.put(option.getId(), option.getValue().toString());
        }
        return map;
    }

    private static Map<String, String> loadSettings() {
        Map map;
        block8: {
            BufferedReader reader = Files.newBufferedReader(CONFIG_PATH);
            try {
                Map map2;
                Type type = new TypeToken<Map<String, String>>(){}.getType();
                map = map2 = (Map)GSON.fromJson((Reader)reader, type);
                if (reader == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (reader != null) {
                        try {
                            ((Reader)reader).close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    FancyWorldAnimations.LOGGER.info("[FWA] Config file not found or invalid, using default");
                    return null;
                }
            }
            ((Reader)reader).close();
        }
        return map;
    }

    private static <T> T getOptionValue(String key, T defaultValue) {
        if (loadedSettings == null || !loadedSettings.containsKey(key)) {
            return null;
        }
        if (defaultValue instanceof Enum) {
            Enum e = (Enum)defaultValue;
            return (T)Enum.valueOf(e.getDeclaringClass(), loadedSettings.get(key));
        }
        if (defaultValue instanceof Float) {
            return (T)Float.valueOf(loadedSettings.get(key));
        }
        return null;
    }

    private static <T> Option<T> loadOptionWithDefaults(String id, String name, String description, T defaultValue) {
        T optionValue = SettingsManager.getOptionValue(id, defaultValue);
        if (optionValue == null) {
            optionValue = defaultValue;
        }
        Option<T> option = new Option<T>(id, name, description, optionValue, defaultValue);
        return option;
    }
}

