/*
 * Decompiled with CFR 0.152.
 */
package fr.madu59.fwa.anims;

import fr.madu59.fwa.anims.Animation;
import fr.madu59.fwa.config.SettingsManager;
import fr.madu59.fwa.utils.Curves;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1087;
import net.minecraft.class_10889;
import net.minecraft.class_1920;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2401;
import net.minecraft.class_2680;
import net.minecraft.class_2738;
import net.minecraft.class_2769;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_4696;
import net.minecraft.class_5819;
import net.minecraft.class_761;
import net.minecraft.class_777;
import net.minecraft.class_7833;
import org.joml.Quaternionfc;

@Environment(value=EnvType.CLIENT)
public class LeverAnimation
extends Animation {
    private final class_5819 random = class_5819.method_43049((long)42L);
    private final class_1087 model;

    public LeverAnimation(class_2338 position, class_2680 defaultState, double startTick, boolean oldIsOpen, boolean newIsOpen) {
        super(position, defaultState, startTick, oldIsOpen, newIsOpen);
        this.model = class_310.method_1551().method_1541().method_3349(defaultState);
    }

    @Override
    public double getAnimDuration() {
        return 5.0 * SettingsManager.LEVER_SPEED.getValue();
    }

    @Override
    public <T extends Enum<T>> T getCurve() {
        return (T)((Object)SettingsManager.LEVER_EASING.getValue());
    }

    @Override
    public boolean isEnabled() {
        return SettingsManager.LEVER_STATE.getValue();
    }

    private double getStartAngle(boolean isOpen) {
        if (!isOpen) {
            return 0.0;
        }
        return 90.0;
    }

    private double getAngle(double nowTick, class_2350 facing) {
        double angle1 = this.getStartAngle(this.oldIsOpen);
        double angle2 = this.getStartAngle(this.newIsOpen);
        double finalAngle = angle1 + (angle2 - angle1) * Curves.ease(this.getProgress(nowTick), this.getCurve());
        if (facing == class_2350.field_11043 || facing == class_2350.field_11034) {
            finalAngle = -finalAngle;
        }
        return finalAngle;
    }

    @Override
    public void render(class_4587 poseStack, class_4597.class_4598 bufferSource, double nowTick) {
        class_2350 facing = (class_2350)this.defaultState.method_11654((class_2769)class_2401.field_11177);
        class_2738 face = (class_2738)this.defaultState.method_11654((class_2769)class_2401.field_11007);
        int light = class_761.method_23794((class_1920)class_310.method_1551().field_1687, (class_2338)this.position);
        class_4588 buffer = bufferSource.getBuffer(class_4696.method_23683((class_2680)this.defaultState));
        class_10889 part = (class_10889)this.model.method_68512(this.random).get(0);
        this.renderFilteredQuads(poseStack, buffer, part.method_68509(null), false, light);
        for (class_2350 dir : class_2350.values()) {
            this.renderFilteredQuads(poseStack, buffer, part.method_68509(dir), false, light);
        }
        double angle = this.getAngle(nowTick, facing);
        float pivotX = 0.5f;
        float pivotY = 0.0625f;
        float pivotZ = 0.5f;
        class_7833 axis = class_7833.field_40714;
        if (face == class_2738.field_12475) {
            switch (facing) {
                case field_11034: 
                case field_11039: {
                    axis = class_7833.field_40718;
                    break;
                }
            }
        } else if (face == class_2738.field_12473) {
            pivotY = 0.9375f;
            switch (facing) {
                case field_11034: 
                case field_11039: {
                    axis = class_7833.field_40717;
                    break;
                }
                default: {
                    axis = class_7833.field_40713;
                    break;
                }
            }
        } else if (face == class_2738.field_12471) {
            pivotY = 0.5f;
            switch (facing) {
                case field_11034: 
                case field_11039: {
                    axis = class_7833.field_40718;
                    pivotX = facing == class_2350.field_11039 ? 0.9375f : 0.0625f;
                    pivotZ = 0.5f;
                    break;
                }
                default: {
                    axis = class_7833.field_40714;
                    pivotX = 0.5f;
                    pivotZ = facing == class_2350.field_11043 ? 0.9375f : 0.0625f;
                }
            }
        }
        poseStack.method_46416(pivotX, pivotY, pivotZ);
        poseStack.method_22907((Quaternionfc)axis.rotationDegrees((float)angle));
        poseStack.method_46416(-pivotX, -pivotY, -pivotZ);
        this.renderFilteredQuads(poseStack, buffer, part.method_68509(null), true, light);
    }

    private void renderFilteredQuads(class_4587 poseStack, class_4588 buffer, List<class_777> quads, boolean wantHandle, int light) {
        for (class_777 quad : quads) {
            String path = quad.comp_3724().method_45851().method_45816().method_12832();
            if (path.contains("lever") != wantHandle) continue;
            buffer.method_22919(poseStack.method_23760(), quad, 1.0f, 1.0f, 1.0f, 1.0f, light, class_4608.field_21444);
        }
    }
}

