/*
 * Decompiled with CFR 0.152.
 */
package fr.madu59.fwa.anims;

import fr.madu59.fwa.anims.Animation;
import fr.madu59.fwa.config.SettingsManager;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1058;
import net.minecraft.class_1059;
import net.minecraft.class_1920;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3709;
import net.minecraft.class_3721;
import net.minecraft.class_3867;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_4696;
import net.minecraft.class_5602;
import net.minecraft.class_630;
import net.minecraft.class_761;
import net.minecraft.class_9943;

@Environment(value=EnvType.CLIENT)
public class BellAnimation
extends Animation {
    private final class_310 client = class_310.method_1551();
    private final class_9943 bellModel;
    private final float hash;
    private class_3721 bellBlockEntity;

    public BellAnimation(class_2338 position, class_2680 defaultState, double startTick, boolean oldIsOpen, boolean newIsOpen) {
        super(position, defaultState, startTick, oldIsOpen, newIsOpen);
        this.bellBlockEntity = (class_3721)this.client.field_1687.method_8321(this.position);
        this.bellModel = new class_9943(this.client.method_31974().method_32072(class_5602.field_27683));
        this.hash = position.hashCode();
    }

    @Override
    public double getAnimDuration() {
        return 50.0 * SettingsManager.BELL_SPEED.getValue();
    }

    @Override
    public boolean isEnabled() {
        return SettingsManager.BELL_STATE.getValue();
    }

    @Override
    public boolean hideOriginalBlock() {
        return false;
    }

    public static boolean hasInfiniteAnimation() {
        return SettingsManager.BELL_INFINITE.getValue();
    }

    @Override
    public double getLifeSpan() {
        return !BellAnimation.hasInfiniteAnimation() ? this.getAnimDuration() : Double.MAX_VALUE;
    }

    private float animateIdle(float time) {
        float uniqueOffset = this.hash % 100.0f;
        float slowWave = (float)Math.sin((time += uniqueOffset) * 0.1f) * 0.05f;
        float fastWave = (float)Math.sin(time * 0.25f) * 0.02f;
        return (slowWave + fastWave) / 2.0f * Math.clamp(time - (float)this.getAnimDuration(), 0.0f, 5.0f) / 5.0f;
    }

    private float animatePlacement(double nowTick) {
        double progress = this.getProgress(nowTick);
        return (float)Math.sin(progress * this.getAnimDuration() / 3.1415927) / (float)(4.0 + progress * this.getAnimDuration() / 3.0);
    }

    private class_630 rotateBell(class_630 bellBody, float rot, class_2350 facing, class_3867 attachment) {
        float f = 0.0f;
        float g = 0.0f;
        switch (facing) {
            case field_11043: {
                f = -rot;
                break;
            }
            case field_11035: {
                f = rot;
                break;
            }
            case field_11039: {
                g = -rot;
                break;
            }
            case field_11034: {
                g = rot;
                break;
            }
        }
        if (attachment == class_3867.field_17100) {
            bellBody.field_3654 = g;
            bellBody.field_3674 = f;
        } else {
            bellBody.field_3654 = f;
            bellBody.field_3674 = g;
        }
        return bellBody;
    }

    @Override
    public void render(class_4587 poseStack, class_4597.class_4598 bufferSource, double nowTick) {
        if (this.bellBlockEntity == null) {
            this.bellBlockEntity = (class_3721)this.client.field_1687.method_8321(this.position);
            return;
        }
        class_1058 sprite = (class_1058)this.client.method_1549(class_1059.field_5275).apply(class_2960.method_12829((String)"minecraft:entity/bell/bell_body"));
        class_2350 facing = (class_2350)this.defaultState.method_11654((class_2769)class_3709.field_16324);
        class_3867 attachment = (class_3867)this.defaultState.method_11654((class_2769)class_3709.field_16326);
        int light = class_761.method_23794((class_1920)this.client.field_1687, (class_2338)this.position);
        this.bellModel.method_62063(this.bellBlockEntity, Math.clamp(this.client.method_61966().method_60637(true), 0.0f, 1.0f));
        class_630 bellBody = ((class_630)this.bellModel.method_63513().get(0)).method_32086("bell_body");
        if (this.bellBlockEntity.field_17095 == 0) {
            float time = (float)(nowTick - this.startTick);
            float rot = (double)time <= this.getAnimDuration() ? this.animatePlacement(nowTick) : this.animateIdle(time);
            bellBody = this.rotateBell(bellBody, rot, facing, attachment);
        }
        bellBody.method_22699(poseStack, sprite.method_24108(bufferSource.getBuffer(class_4696.method_23683((class_2680)this.defaultState))), light, class_4608.field_21444, -1);
    }
}

